/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.util;

import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CircularLogBufferHandler
extends Handler {
    private final ArrayDeque<ImmutableLogRecord> buffer = new ArrayDeque();
    private final List<LogUpdateListener> listeners = new CopyOnWriteArrayList<LogUpdateListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        ArrayDeque<ImmutableLogRecord> arrayDeque = this.buffer;
        synchronized (arrayDeque) {
            this.buffer.addLast(new ImmutableLogRecord(record));
            this.listeners.forEach(c -> c.accept(this.buffer));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public void addUpdateListener(LogUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void removeUpdateListener(LogUpdateListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImmutableLogRecord> getLogRecords() {
        ArrayDeque<ImmutableLogRecord> arrayDeque = this.buffer;
        synchronized (arrayDeque) {
            return List.copyOf(this.buffer);
        }
    }

    public static interface LogUpdateListener
    extends Consumer<Collection<ImmutableLogRecord>> {
    }

    public static final class ImmutableLogRecord {
        private final String loggerName;
        private final Level level;
        private final String message;
        private final Throwable thrown;
        private final Instant instant;

        public ImmutableLogRecord(LogRecord record) {
            this.loggerName = record.getLoggerName();
            this.level = record.getLevel();
            this.message = record.getMessage();
            this.thrown = record.getThrown();
            this.instant = record.getInstant();
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        public Instant getInstant() {
            return this.instant;
        }
    }
}

