/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.InvalidFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class ModelLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(ModelLoader.class);
    private final String modelName;

    protected ModelLoader(String modelName) {
        this.modelName = Objects.requireNonNull(modelName, "modelName must not be null!");
    }

    protected abstract T loadModel(InputStream var1) throws IOException;

    public T load(File modelFile) {
        T model;
        long beginModelLoadingTime = System.currentTimeMillis();
        CmdLineUtil.checkInputFile(this.modelName + " model", modelFile);
        logger.info("Loading {} model ... ", (Object)this.modelName);
        try (BufferedInputStream modelIn = new BufferedInputStream(CmdLineUtil.openInFile(modelFile), 0x100000);){
            model = this.loadModel(modelIn);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, "Model has invalid format", e);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while loading model file '" + String.valueOf(modelFile) + "'", e);
        }
        long modelLoadingDuration = System.currentTimeMillis() - beginModelLoadingTime;
        logger.info(String.format("done (%.3fs)\n", (double)modelLoadingDuration / 1000.0));
        return model;
    }
}

