/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.io.File;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.api.v1.dto.MultiPart;
import org.apache.kyuubi.client.exception.KyuubiRestException;
import org.apache.kyuubi.client.exception.RetryableKyuubiRestException;
import org.apache.kyuubi.client.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements IRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private CloseableHttpClient httpclient;
    private String baseUrl;

    public RestClient(String baseUrl, CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        this.baseUrl = baseUrl;
    }

    @Override
    public void close() throws Exception {
        if (this.httpclient != null) {
            this.httpclient.close();
        }
    }

    @Override
    public <T> T get(String path, Map<String, Object> params, Class<T> type, String authHeader) {
        String responseJson = this.get(path, params, authHeader);
        return JsonUtils.fromJson(responseJson, type);
    }

    @Override
    public String get(String path, Map<String, Object> params, String authHeader) {
        return this.doRequest(this.buildURI(path, params), authHeader, RequestBuilder.get());
    }

    @Override
    public <T> T post(String path, String body, Class<T> type, String authHeader) {
        String responseJson = this.post(path, body, authHeader);
        return JsonUtils.fromJson(responseJson, type);
    }

    @Override
    public String post(String path, String body, String authHeader) {
        RequestBuilder postRequestBuilder = RequestBuilder.post();
        if (body != null) {
            postRequestBuilder.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
        }
        return this.doRequest(this.buildURI(path), authHeader, postRequestBuilder);
    }

    @Override
    public <T> T post(String path, Map<String, MultiPart> multiPartMap, Class<T> type, String authHeader) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8);
        multiPartMap.forEach((s, multiPart) -> {
            FileBody contentBody;
            Object payload = multiPart.getPayload();
            switch (multiPart.getType()) {
                case JSON: {
                    String string = payload instanceof String ? (String)payload : JsonUtils.toJson(payload);
                    contentBody = new StringBody(string, ContentType.APPLICATION_JSON);
                    break;
                }
                case FILE: {
                    contentBody = new FileBody((File)payload);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported multi part type:" + (Object)((Object)multiPart.getType()));
                }
            }
            entityBuilder.addPart(s, (ContentBody)contentBody);
        });
        HttpEntity httpEntity = entityBuilder.build();
        RequestBuilder postRequestBuilder = RequestBuilder.post((URI)this.buildURI(path));
        postRequestBuilder.setHeader(httpEntity.getContentType());
        postRequestBuilder.setEntity(httpEntity);
        String responseJson = this.doRequest(this.buildURI(path), authHeader, postRequestBuilder);
        return JsonUtils.fromJson(responseJson, type);
    }

    @Override
    public <T> T put(String path, String body, Class<T> type, String authHeader) {
        String responseJson = this.put(path, body, authHeader);
        return JsonUtils.fromJson(responseJson, type);
    }

    @Override
    public String put(String path, String body, String authHeader) {
        RequestBuilder putRequestBuilder = RequestBuilder.put();
        if (body != null) {
            putRequestBuilder.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
        }
        return this.doRequest(this.buildURI(path), authHeader, putRequestBuilder);
    }

    @Override
    public <T> T delete(String path, Map<String, Object> params, Class<T> type, String authHeader) {
        String responseJson = this.delete(path, params, authHeader);
        return JsonUtils.fromJson(responseJson, type);
    }

    @Override
    public String delete(String path, Map<String, Object> params, String authHeader) {
        return this.doRequest(this.buildURI(path, params), authHeader, RequestBuilder.delete());
    }

    private String doRequest(URI uri, String authHeader, RequestBuilder requestBuilder) {
        String response;
        try {
            if (requestBuilder.getFirstHeader("Content-Type") == null) {
                requestBuilder.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            }
            if (StringUtils.isNotBlank((CharSequence)authHeader)) {
                requestBuilder.setHeader("Authorization", authHeader);
            }
            HttpUriRequest httpRequest = requestBuilder.setUri(uri).build();
            LOG.debug("Executing {} request: {}", (Object)httpRequest.getMethod(), (Object)uri);
            ResponseHandler responseHandler = resp -> {
                String entityStr;
                int status = resp.getStatusLine().getStatusCode();
                HttpEntity entity = resp.getEntity();
                String string = entityStr = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                if (status >= 200 && status < 300) {
                    return entityStr;
                }
                throw new HttpResponseException(status, entityStr);
            };
            response = (String)this.httpclient.execute(httpRequest, responseHandler);
            LOG.debug("Response: {}", (Object)response);
        }
        catch (ConnectException | UnknownHostException | NoHttpResponseException | ConnectTimeoutException e) {
            throw new RetryableKyuubiRestException("Api request failed for " + uri.toString(), e);
        }
        catch (KyuubiRestException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            LOG.error("Error: ", (Throwable)e);
            throw new KyuubiRestException("Api request failed for " + uri.toString(), e);
        }
        return response;
    }

    private URI buildURI(String path) {
        return this.buildURI(path, null);
    }

    private URI buildURI(String path, Map<String, Object> params) {
        URI uri;
        try {
            String url = StringUtils.isNotBlank((CharSequence)path) ? this.baseUrl + "/" + path : this.baseUrl;
            URIBuilder builder = new URIBuilder(url);
            if (MapUtils.isNotEmpty(params)) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getValue() == null) continue;
                    builder.addParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new KyuubiRestException("invalid URI.", e);
        }
        return uri;
    }
}

