/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.arrow;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.arrow.vector.util.DateUtility;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnVector;
import org.apache.kyuubi.jdbc.hive.common.DateUtils;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalDayTime;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalYearMonth;

public class ArrowColumnarBatchRow {
    public int rowId;
    private final ArrowColumnVector[] columns;

    public ArrowColumnarBatchRow(ArrowColumnVector[] columns) {
        this.columns = columns;
    }

    public int numFields() {
        return this.columns.length;
    }

    public boolean anyNull() {
        throw new UnsupportedOperationException();
    }

    public boolean isNullAt(int ordinal) {
        return this.columns[ordinal].isNullAt(this.rowId);
    }

    public boolean getBoolean(int ordinal) {
        return this.columns[ordinal].getBoolean(this.rowId);
    }

    public byte getByte(int ordinal) {
        return this.columns[ordinal].getByte(this.rowId);
    }

    public short getShort(int ordinal) {
        return this.columns[ordinal].getShort(this.rowId);
    }

    public int getInt(int ordinal) {
        return this.columns[ordinal].getInt(this.rowId);
    }

    public long getLong(int ordinal) {
        return this.columns[ordinal].getLong(this.rowId);
    }

    public float getFloat(int ordinal) {
        return this.columns[ordinal].getFloat(this.rowId);
    }

    public double getDouble(int ordinal) {
        return this.columns[ordinal].getDouble(this.rowId);
    }

    public BigDecimal getDecimal(int ordinal, int precision, int scale) {
        return this.columns[ordinal].getDecimal(this.rowId, precision, scale);
    }

    public BigDecimal getDecimal(int ordinal) {
        return this.columns[ordinal].getDecimal(this.rowId);
    }

    public String getString(int ordinal) {
        return this.columns[ordinal].getString(this.rowId);
    }

    public byte[] getBinary(int ordinal) {
        return this.columns[ordinal].getBinary(this.rowId);
    }

    public Object getInterval(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public Object getStruct(int ordinal, int numFields) {
        throw new UnsupportedOperationException();
    }

    public Object getArray(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public Object getMap(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public Object get(int ordinal, TTypeId dataType, String timeZone, boolean timestampAsString) {
        switch (dataType) {
            case BOOLEAN_TYPE: {
                return this.getBoolean(ordinal);
            }
            case TINYINT_TYPE: {
                return this.getByte(ordinal);
            }
            case SMALLINT_TYPE: {
                return this.getShort(ordinal);
            }
            case INT_TYPE: {
                return this.getInt(ordinal);
            }
            case BIGINT_TYPE: {
                return this.getLong(ordinal);
            }
            case BINARY_TYPE: {
                return this.getBinary(ordinal);
            }
            case FLOAT_TYPE: {
                return Float.valueOf(this.getFloat(ordinal));
            }
            case DOUBLE_TYPE: {
                return this.getDouble(ordinal);
            }
            case DECIMAL_TYPE: {
                return this.getDecimal(ordinal);
            }
            case STRING_TYPE: {
                return this.getString(ordinal);
            }
            case TIMESTAMP_TYPE: {
                if (timestampAsString) {
                    return Timestamp.valueOf(this.getString(ordinal));
                }
                LocalDateTime localDateTime = DateUtility.getLocalDateTimeFromEpochMicro((long)this.getLong(ordinal), (String)timeZone);
                return Timestamp.valueOf(localDateTime);
            }
            case DATE_TYPE: {
                return DateUtils.internalToDate(this.getInt(ordinal));
            }
            case INTERVAL_DAY_TIME_TYPE: {
                long microseconds = this.getLong(ordinal);
                long seconds = microseconds / 1000000L;
                int nanos = (int)(microseconds % 1000000L) * 1000;
                return new HiveIntervalDayTime(seconds, nanos);
            }
            case INTERVAL_YEAR_MONTH_TYPE: {
                return new HiveIntervalYearMonth(this.getInt(ordinal));
            }
            case ARRAY_TYPE: {
                return this.getString(ordinal);
            }
            case MAP_TYPE: {
                return this.getString(ordinal);
            }
            case STRUCT_TYPE: {
                return this.getString(ordinal);
            }
        }
        throw new UnsupportedOperationException("Datatype not supported " + dataType);
    }
}

