/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.utils;

import java.io.Serializable;
import java.util.Map;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.metadata.cube.gridtable.NLayoutToGridTableMapping;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.query.runtime.plan.TableScanPlan$;
import org.apache.spark.sql.LayoutEntityConverter$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.utils.AggColumnInfo;
import org.apache.spark.sql.execution.utils.DeriveTableColumnInfo;
import org.apache.spark.sql.execution.utils.FactTableCulumnInfo;
import org.apache.spark.sql.execution.utils.TopNColumnInfo;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SparderConstants$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SchemaProcessor$ {
    public static SchemaProcessor$ MODULE$;

    static {
        new SchemaProcessor$();
    }

    public Seq<String> buildGTSchema(LayoutEntity cuboid, NLayoutToGridTableMapping mapping, String tableName) {
        return this.genColumnNames(tableName, cuboid, mapping);
    }

    private Seq<String> genColumnNames(String tableName, LayoutEntity cuboid, NLayoutToGridTableMapping mapping) {
        String[] columnMapping = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.initColumnNameMapping(cuboid))).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ImmutableBitSet colAll = new ImmutableBitSet(0, mapping.getDataTypes().length);
        Iterable measures = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)colAll.andNot(mapping.getPrimaryKey())).asScala();
        return (Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)mapping.getPrimaryKey()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new FactTableCulumnInfo(tableName, Predef$.MODULE$.Integer2int(i), columnMapping[Predef$.MODULE$.Integer2int(i)]).toString(), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$plus((GenTraversableOnce)((TraversableOnce)measures.map((Function1 & Serializable & scala.Serializable)i -> new FactTableCulumnInfo(tableName, Predef$.MODULE$.Integer2int(i), columnMapping[Predef$.MODULE$.Integer2int(i)]).toString(), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<String, String>[] initColumnNameMapping(LayoutEntity cuboid) {
        Tuple2[] cols = (Tuple2[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cuboid.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)col -> new Tuple2((Object)col.getIdentity().replace(".", "_"), (Object)col.getType().getName()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2[] measures = (Tuple2[])((TraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)cuboid.getOrderedMeasures()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)measure -> new Tuple2((Object)((MeasureDesc)measure._2()).getName().replace(".", "_"), (Object)((MeasureDesc)measure._2()).getFunction().getReturnType()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])measures)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public DataType generateFunctionReturnDataType(FunctionDesc function) {
        LongType$ longType$;
        String string = function.getExpression().toUpperCase();
        if ("SUM".equals(string)) {
            ParameterDesc parameter = (ParameterDesc)function.getParameters().get(0);
            longType$ = parameter.isColumnType() ? SparderTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), true) : SparderTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), true);
        } else if ("COUNT".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if (string.startsWith("TOP_N")) {
            Buffer fields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(function.getParameters()).asScala()).drop(1)).map((Function1 & Serializable & scala.Serializable)p -> new StructField(new StringBuilder(10).append("DIMENSION_").append(p.getColRef().getName()).toString(), SparderTypeUtil$.MODULE$.toSparkType(p.getColRef().getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom());
            longType$ = DataTypes.createArrayType((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("measure", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dim", (DataType)StructType$.MODULE$.apply((Seq)fields), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        } else {
            boolean bl = "MAX".equals(string) ? true : "MIN".equals(string);
            if (bl) {
                ParameterDesc parameter = (ParameterDesc)function.getParameters().get(0);
                longType$ = parameter.isColumnType() ? SparderTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()) : SparderTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), SparderTypeUtil$.MODULE$.toSparkType$default$2());
            } else if ("COLLECT_SET".equals(string)) {
                ParameterDesc parameter = (ParameterDesc)function.getParameters().get(0);
                longType$ = ArrayType$.MODULE$.apply(SparderTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()));
            } else {
                longType$ = SparderTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), SparderTypeUtil$.MODULE$.toSparkType$default$2());
            }
        }
        return longType$;
    }

    public void checkSchema(SparkSession sparkSession, String dfName, String project) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dsMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow df = dsMgr.getDataflow(dfName);
        NDataSegment latestReadySegment = (NDataSegment)df.getQueryableSegments().getFirstSegment();
        java.util.List allCuboidLayouts = df.getIndexPlan().getAllLayouts();
        String base = KapConfig.getInstanceFromEnv().getReadParquetStoragePath(df.getProject());
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allCuboidLayouts).foreach((Function1 & Serializable & scala.Serializable)nCuboidLayout -> {
            SchemaProcessor$.$anonfun$checkSchema$1(df, base, latestReadySegment, sparkSession, dfName, nCuboidLayout);
            return BoxedUnit.UNIT;
        });
    }

    public int factTableSchemaNameToColumnId(String schemaName) {
        String[] data = schemaName.split(SparderConstants$.MODULE$.COLUMN_NAME_SEPARATOR());
        return new StringOps(Predef$.MODULE$.augmentString(data[data.length - 1])).toInt();
    }

    public DeriveTableColumnInfo parseDeriveTableSchemaName(String schemaName) {
        String[] data = schemaName.split(SparderConstants$.MODULE$.COLUMN_NAME_SEPARATOR());
        DeriveTableColumnInfo deriveTableColumnInfo = new DeriveTableColumnInfo(data[2], new StringOps(Predef$.MODULE$.augmentString(data[3])).toInt(), data[1]);
        return deriveTableColumnInfo;
    }

    public String generateDeriveTableSchemaName(String deriveTableName, int colId, String columnName) {
        return new DeriveTableColumnInfo(deriveTableName, colId, columnName).toString();
    }

    public String generateDeriveTableSchemaName$default$3() {
        return "N";
    }

    public String replaceToAggravateSchemaName(int index, String aggFuncName, String hash, Seq<String> aggArgs) {
        return new AggColumnInfo(index, aggFuncName, hash, aggArgs).toString();
    }

    public String[] buildFactTableSortNames(Seq<Attribute> sourceSchema) {
        return (String[])((TraversableOnce)((TraversableLike)((SeqLike)((TraversableLike)sourceSchema.filter((Function1 & Serializable & scala.Serializable)att -> BoxesRunTime.boxToBoolean((boolean)SchemaProcessor$.$anonfun$buildFactTableSortNames$1(att)))).map((Function1 & Serializable & scala.Serializable)att -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)MODULE$.factTableSchemaNameToColumnId(att.name())), (Object)att.name()), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._2(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public StructType buildSchemaWithRawTable(ColumnDesc[] columnDescs) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnDescs)).map((Function1 & Serializable & scala.Serializable)columnDesc -> new StructField(columnDesc.getName(), SparderTypeUtil$.MODULE$.toSparkType(columnDesc.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public String genTopNSchema(String advanceTableName, int colId, String columnName) {
        return new TopNColumnInfo(advanceTableName, colId, columnName).toString();
    }

    public String genTopNSchema$default$3() {
        return "N";
    }

    public StructField createStructType(String name, DataType dataType, boolean nullable) {
        return new StructField(name, dataType, nullable, StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ void $anonfun$checkSchema$1(NDataflow df$1, String base$1, NDataSegment latestReadySegment$1, SparkSession sparkSession$1, String dfName$1, LayoutEntity nCuboidLayout) {
        String path = TableScanPlan$.MODULE$.toLayoutPath(df$1, nCuboidLayout.getId(), base$1, latestReadySegment$1);
        StructType schema = sparkSession$1.read().parquet(path).schema();
        StructType schemaFromNCuboidLayout = LayoutEntityConverter$.MODULE$.genCuboidSchemaFromNCuboidLayout(nCuboidLayout, LayoutEntityConverter$.MODULE$.genCuboidSchemaFromNCuboidLayout$default$2());
        StructType structType = schema;
        DataType dataType = StructType$.MODULE$.removeMetadata("__CHAR_VARCHAR_TYPE_STRING", (DataType)schemaFromNCuboidLayout);
        if (structType == null ? dataType != null : !structType.equals(dataType)) {
            throw new RuntimeException(new StringBuilder(62).append("Check schema failed : dfName: ").append(dfName$1).append(", layoutId: ").append(nCuboidLayout.getId()).append(", actual: ").append(schemaFromNCuboidLayout.treeString()).append(", expect: ").append(schema.treeString()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildFactTableSortNames$1(Attribute att) {
        return att.name().startsWith(new StringBuilder(1).append("F").append(SparderConstants$.MODULE$.COLUMN_NAME_SEPARATOR()).toString()) || att.name().startsWith(new StringBuilder(1).append("R").append(SparderConstants$.MODULE$.COLUMN_NAME_SEPARATOR()).toString());
    }

    private SchemaProcessor$() {
        MODULE$ = this;
    }
}

