/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.InternalError;
import org.mybatis.dynamic.sql.util.Messages;

public class FetchFirstPagingModelRenderer {
    private final RenderingStrategy renderingStrategy;
    private final PagingModel pagingModel;
    private final AtomicInteger sequence;

    public FetchFirstPagingModelRenderer(RenderingStrategy renderingStrategy, PagingModel pagingModel, AtomicInteger sequence) {
        this.renderingStrategy = renderingStrategy;
        this.pagingModel = pagingModel;
        this.sequence = sequence;
    }

    public FragmentAndParameters render() {
        return this.pagingModel.offset().map(this::renderWithOffset).orElseGet(this::renderFetchFirstRowsOnly);
    }

    private FragmentAndParameters renderWithOffset(Long offset) {
        return this.pagingModel.fetchFirstRows().map(ffr -> this.renderOffsetAndFetchFirstRows(offset, (Long)ffr)).orElseGet(() -> this.renderOffsetOnly(offset));
    }

    private FragmentAndParameters renderFetchFirstRowsOnly() {
        return this.pagingModel.fetchFirstRows().map(this::renderFetchFirstRowsOnly).orElseThrow(() -> new InvalidSqlException(Messages.getInternalErrorString(InternalError.INTERNAL_ERROR_13)));
    }

    private FragmentAndParameters renderFetchFirstRowsOnly(Long fetchFirstRows) {
        String mapKey = this.renderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("fetch first " + this.renderPlaceholder(mapKey) + " rows only").withParameter(mapKey, fetchFirstRows).build();
    }

    private FragmentAndParameters renderOffsetOnly(Long offset) {
        String mapKey = this.renderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("offset " + this.renderPlaceholder(mapKey) + " rows").withParameter(mapKey, offset).build();
    }

    private FragmentAndParameters renderOffsetAndFetchFirstRows(Long offset, Long fetchFirstRows) {
        String mapKey1 = this.renderingStrategy.formatParameterMapKey(this.sequence);
        String mapKey2 = this.renderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("offset " + this.renderPlaceholder(mapKey1) + " rows fetch first " + this.renderPlaceholder(mapKey2) + " rows only").withParameter(mapKey1, offset).withParameter(mapKey2, fetchFirstRows).build();
    }

    private String renderPlaceholder(String parameterName) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", parameterName);
    }
}

