/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.InsertColumnListModel;
import org.mybatis.dynamic.sql.insert.InsertSelectModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.util.Buildable;

public class InsertSelectDSL
implements Buildable<InsertSelectModel> {
    private final SqlTable table;
    private final InsertColumnListModel columnList;
    private final SelectModel selectModel;

    private InsertSelectDSL(SqlTable table, InsertColumnListModel columnList, SelectModel selectModel) {
        this.table = Objects.requireNonNull(table);
        this.selectModel = Objects.requireNonNull(selectModel);
        this.columnList = columnList;
    }

    private InsertSelectDSL(SqlTable table, SelectModel selectModel) {
        this.table = Objects.requireNonNull(table);
        this.selectModel = Objects.requireNonNull(selectModel);
        this.columnList = null;
    }

    @Override
    @NotNull
    public InsertSelectModel build() {
        return InsertSelectModel.withTable(this.table).withColumnList(this.columnList).withSelectModel(this.selectModel).build();
    }

    public static InsertColumnGatherer insertInto(SqlTable table) {
        return new InsertColumnGatherer(table);
    }

    public static class InsertColumnGatherer {
        private final SqlTable table;

        private InsertColumnGatherer(SqlTable table) {
            this.table = table;
        }

        public SelectGatherer withColumnList(SqlColumn<?> ... columns) {
            return this.withColumnList(Arrays.asList(columns));
        }

        public SelectGatherer withColumnList(List<SqlColumn<?>> columns) {
            return new SelectGatherer(this.table, columns);
        }

        public InsertSelectDSL withSelectStatement(Buildable<SelectModel> selectModelBuilder) {
            return new InsertSelectDSL(this.table, selectModelBuilder.build());
        }
    }

    public static class SelectGatherer {
        private final SqlTable table;
        private final InsertColumnListModel columnList;

        private SelectGatherer(SqlTable table, List<SqlColumn<?>> columns) {
            this.table = table;
            this.columnList = InsertColumnListModel.of(columns);
        }

        public InsertSelectDSL withSelectStatement(Buildable<SelectModel> selectModelBuilder) {
            return new InsertSelectDSL(this.table, this.columnList, selectModelBuilder.build());
        }
    }
}

