/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.util.Messages;

public class OrderByModel {
    private final List<SortSpecification> columns = new ArrayList<SortSpecification>();

    private OrderByModel(Collection<SortSpecification> columns) {
        Objects.requireNonNull(columns);
        if (columns.isEmpty()) {
            throw new InvalidSqlException(Messages.getString("ERROR.12"));
        }
        this.columns.addAll(columns);
    }

    public <R> Stream<R> mapColumns(Function<SortSpecification, R> mapper) {
        return this.columns.stream().map(mapper);
    }

    public static OrderByModel of(Collection<SortSpecification> columns) {
        return new OrderByModel(columns);
    }
}

