/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.constant.ObsConfig;

public class FileSystemUtil {
    public static final String S3_FILE_SYSTEM_CLASS = "S3AFileSystem";
    public static final String OSS_FILE_SYSTEM_CLASS = "AliyunOSSFileSystem";

    public static FileStatus[] listStatus(FileSystem fs, Path path) throws IOException {
        FileStatus[] statuses = fs.listStatus(path);
        if (fs.getClass().getName().endsWith(S3_FILE_SYSTEM_CLASS)) {
            for (int i = 0; i < statuses.length; ++i) {
                if (!statuses[i].isDirectory()) continue;
                statuses[i] = fs.getFileStatus(statuses[i].getPath());
            }
        }
        return statuses;
    }

    public static Map<String, String> generateRoleCredentialConf(String type, String bucket, String role, String endpoint, String region) {
        HashMap<String, String> conf = new HashMap<String, String>();
        ObsConfig obsConfig = ObsConfig.getByType(type).orElse(ObsConfig.S3);
        if (StringUtils.isNotEmpty((CharSequence)role)) {
            conf.put(String.format(Locale.ROOT, obsConfig.getRoleArnKey(), bucket), role);
            conf.put(String.format(Locale.ROOT, obsConfig.getCredentialProviderKey(), bucket), obsConfig.getCredentialProviderValue());
            conf.put(String.format(Locale.ROOT, obsConfig.getAssumedRoleCredentialProviderKey(), bucket), obsConfig.getAssumedRoleCredentialProviderValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)endpoint)) {
            conf.put(String.format(Locale.ROOT, obsConfig.getEndpointKey(), bucket), endpoint);
        }
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            conf.put(String.format(Locale.ROOT, obsConfig.getRegionKey(), bucket), region);
        }
        return conf;
    }
}

