/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.nio.charset.Charset;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptUtil.class);
    private static final byte[] key = new byte[]{116, 104, 105, 115, 73, 115, 65, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    public static final String ENC_PREFIX = "ENC('";
    public static final String ENC_SUBFIX = "')";
    public static final String DEC_FLAG = "DEC";

    public static boolean isEncrypted(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) && value.startsWith(ENC_PREFIX) && value.endsWith(ENC_SUBFIX);
    }

    public static String encrypt(String strToEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secretKey);
            return Base64.encodeBase64String((byte[])cipher.doFinal(strToEncrypt.getBytes(Charset.defaultCharset())));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String encryptWithPrefix(String value) {
        return ENC_PREFIX + EncryptUtil.encrypt(value) + ENC_SUBFIX;
    }

    public static String decrypt(String strToDecrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(2, secretKey);
            return new String(cipher.doFinal(Base64.decodeBase64((String)strToDecrypt)), Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decryptPassInKylin(String value) {
        return EncryptUtil.decrypt(value.substring(ENC_PREFIX.length(), value.length() - ENC_SUBFIX.length()));
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.kylin.common.util <your_password>");
    }

    public static String getDecryptedValue(String value) {
        try {
            if (EncryptUtil.isEncrypted(value)) {
                return EncryptUtil.decryptPassInKylin(value);
            }
            return value;
        }
        catch (Exception e) {
            log.error("Get decrypted value failed, {}", (Object)value, (Object)e);
            return null;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            EncryptUtil.printUsage();
            Unsafe.systemExit(1);
        }
        String passwordTxt = args[0];
        System.out.println(EncryptUtil.encrypt(passwordTxt));
    }
}

