/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class CompositeMapView<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V>[] composite;

    public CompositeMapView(Map<K, V> ... maps) {
        for (Map<K, V> map : maps) {
            Preconditions.checkNotNull(map);
        }
        this.composite = maps;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return Arrays.stream(this.composite).allMatch(Map::isEmpty);
    }

    @Override
    public boolean containsKey(Object key) {
        return Arrays.stream(this.composite).anyMatch(map -> map.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return Arrays.stream(this.composite).anyMatch(map -> map.containsValue(value));
    }

    @Override
    public V get(Object key) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(key)) continue;
            return this.composite[i].get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        HashSet keySet = Sets.newHashSet();
        Arrays.stream(this.composite).map(Map::keySet).forEach(keySet::addAll);
        return keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap compositeMap = Maps.newHashMapWithExpectedSize((int)this.size());
        Arrays.stream(this.composite).forEach(compositeMap::putAll);
        return compositeMap.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public void forEach(BiConsumer action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeMapView)) {
            return false;
        }
        CompositeMapView other = (CompositeMapView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.composite, other.composite);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CompositeMapView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.composite);
        return result;
    }
}

