/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public class ArgsTypeJsonDeserializer {
    private ArgsTypeJsonDeserializer() {
        throw new IllegalStateException("ArgsTypeJsonDeserializer class");
    }

    public static class IntegerJsonDeserializer
    extends JsonDeserializer<Integer> {
        public Integer getNullValue(DeserializationContext ctxt) {
            return 0;
        }

        public Integer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                String text = p.getText();
                if (StringUtils.isEmpty((CharSequence)text) || StringUtils.equals((CharSequence)"null", (CharSequence)text)) {
                    return 0;
                }
                return Integer.parseInt(text);
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ARGS_TYPE_CHECK, (Throwable)e, p.getText(), "Integer");
            }
        }
    }

    public static class ListJsonDeserializer
    extends JsonDeserializer<List<Object>> {
        public List<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return (List)p.readValueAs(List.class);
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ARGS_TYPE_CHECK, (Throwable)e, p.getText(), "List");
            }
        }
    }

    public static class BooleanJsonDeserializer
    extends JsonDeserializer<Boolean> {
        private final List<String> boolList = Lists.newArrayList((Object[])new String[]{"true", "false", "TRUE", "FALSE", "null"});

        public Boolean getNullValue(DeserializationContext ctxt) {
            return Boolean.FALSE;
        }

        public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                String text = p.getText();
                if (StringUtils.isEmpty((CharSequence)text)) {
                    return Boolean.FALSE;
                }
                if (this.boolList.contains(text)) {
                    return Boolean.parseBoolean(text);
                }
                return p.getBooleanValue();
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ARGS_TYPE_CHECK, (Throwable)e, p.getText(), "Boolean");
            }
        }
    }
}

