/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.logging;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="SensitivePatternMasker", category="Converter")
@ConverterKeys(value={"mask"})
public class SensitivePatternMasker
extends LogEventPatternConverter {
    private static final String PREFIX_GROUP_NAME = "prefix";
    private static final String SENSITIVE_GROUP_NAME = "sensitive";
    private static final String MASK = "******";
    private static final Pattern SENSITIVE_PATTERN = Pattern.compile(String.format(Locale.ROOT, "(?<%s>password\\s*[:=])(?<%s>[^,.!]*)", "prefix", "sensitive"), 2);

    public static SensitivePatternMasker newInstance(Configuration config, String[] options) {
        return new SensitivePatternMasker();
    }

    protected SensitivePatternMasker() {
        super("mask", "mask");
    }

    private String mask(String message) {
        Matcher matcher = SENSITIVE_PATTERN.matcher(message);
        if (matcher.find()) {
            return matcher.replaceAll(String.format(Locale.ROOT, "${%s}%s", PREFIX_GROUP_NAME, MASK));
        }
        return message;
    }

    @PerformanceSensitive(value={"allocation"})
    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append(this.mask(event.getMessage().getFormattedMessage()));
    }
}

