/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.constant;

import java.util.Optional;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ObsConfig {
    OSS("oss", "oss", "role", "oss_endpoint", "region", "fs.oss.bucket.%s.assumed.role.arn", "fs.oss.bucket.%s.credentials.provider", "fs.oss.bucket.%s.assumed.role.credentials.provider", "com.aliyun.oss.common.auth.STSAssumeRoleSessionCredentialsProvider", "com.aliyuncs.auth.InstanceProfileCredentialsProvider", "fs.oss.bucket.%s.endpoint", "fs.oss.bucket.%s.region"),
    S3("s3", "s3a", "role", "s3_endpoint", "region", "fs.s3a.bucket.%s.assumed.role.arn", "fs.s3a.bucket.%s.aws.credentials.provider", "fs.s3a.bucket.%s.assumed.role.credentials.provider", "org.apache.hadoop.fs.s3a.auth.AssumedRoleCredentialProvider", "com.amazonaws.auth.InstanceProfileCredentialsProvider", "fs.s3a.bucket.%s.endpoint", "fs.s3a.bucket.%s.region");

    @Generated
    private static final Logger log;
    private final String name;
    private final String type;
    private final String rolePropertiesKey;
    private final String endpointPropertiesKey;
    private final String regionPropertiesKey;
    private final String roleArnKey;
    private final String credentialProviderKey;
    private final String assumedRoleCredentialProviderKey;
    private final String credentialProviderValue;
    private final String assumedRoleCredentialProviderValue;
    private final String endpointKey;
    private final String regionKey;

    public static Optional<ObsConfig> getByType(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return Optional.empty();
        }
        for (ObsConfig obsConfig : ObsConfig.values()) {
            if (!obsConfig.getType().equalsIgnoreCase(type)) continue;
            return Optional.of(obsConfig);
        }
        return Optional.empty();
    }

    public static Optional<ObsConfig> getByLocation(String location) {
        if (Strings.isNullOrEmpty((String)location)) {
            return Optional.empty();
        }
        for (ObsConfig obsConfig : ObsConfig.values()) {
            if (!location.startsWith(obsConfig.getName())) continue;
            return Optional.of(obsConfig);
        }
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            String className = fs.getClass().getName();
            if (className.endsWith("S3AFileSystem")) {
                return Optional.of(S3);
            }
            if (fs.getClass().getName().endsWith("AliyunOSSFileSystem")) {
                return Optional.of(OSS);
            }
        }
        catch (Exception e) {
            log.warn("Failed to get file system", (Throwable)e);
        }
        return Optional.empty();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getRolePropertiesKey() {
        return this.rolePropertiesKey;
    }

    @Generated
    public String getEndpointPropertiesKey() {
        return this.endpointPropertiesKey;
    }

    @Generated
    public String getRegionPropertiesKey() {
        return this.regionPropertiesKey;
    }

    @Generated
    public String getRoleArnKey() {
        return this.roleArnKey;
    }

    @Generated
    public String getCredentialProviderKey() {
        return this.credentialProviderKey;
    }

    @Generated
    public String getAssumedRoleCredentialProviderKey() {
        return this.assumedRoleCredentialProviderKey;
    }

    @Generated
    public String getCredentialProviderValue() {
        return this.credentialProviderValue;
    }

    @Generated
    public String getAssumedRoleCredentialProviderValue() {
        return this.assumedRoleCredentialProviderValue;
    }

    @Generated
    public String getEndpointKey() {
        return this.endpointKey;
    }

    @Generated
    public String getRegionKey() {
        return this.regionKey;
    }

    @Generated
    private ObsConfig(String name, String type, String rolePropertiesKey, String endpointPropertiesKey, String regionPropertiesKey, String roleArnKey, String credentialProviderKey, String assumedRoleCredentialProviderKey, String credentialProviderValue, String assumedRoleCredentialProviderValue, String endpointKey, String regionKey) {
        this.name = name;
        this.type = type;
        this.rolePropertiesKey = rolePropertiesKey;
        this.endpointPropertiesKey = endpointPropertiesKey;
        this.regionPropertiesKey = regionPropertiesKey;
        this.roleArnKey = roleArnKey;
        this.credentialProviderKey = credentialProviderKey;
        this.assumedRoleCredentialProviderKey = assumedRoleCredentialProviderKey;
        this.credentialProviderValue = credentialProviderValue;
        this.assumedRoleCredentialProviderValue = assumedRoleCredentialProviderValue;
        this.endpointKey = endpointKey;
        this.regionKey = regionKey;
    }

    static {
        log = LoggerFactory.getLogger(ObsConfig.class);
    }
}

