/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.apache.kylin.common.ICachedExternalConfigLoader;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinExternalConfigLoader
implements ICachedExternalConfigLoader {
    private static final long serialVersionUID = 1694879531312203159L;
    private static final Logger logger = LoggerFactory.getLogger(KylinExternalConfigLoader.class);
    public static final String KYLIN_CONF_PROPERTIES_FILE = "kylin.properties";
    private final File propFile;
    private final Map<String, String> properties;
    private final ImmutableMap<Object, Object> propertyEntries;

    public KylinExternalConfigLoader(Map<String, String> map) {
        this(map.get("config-dir") == null ? KylinConfig.getSitePropertiesFile() : new File(map.get("config-dir")));
    }

    public KylinExternalConfigLoader(File file) {
        this.propFile = file;
        this.properties = this.loadProperties();
        this.propertyEntries = ImmutableMap.copyOf(this.properties);
    }

    private Map<String, String> loadProperties() {
        ConcurrentMap siteProperties = Maps.newConcurrentMap();
        OrderedProperties orderedProperties = this.buildSiteOrderedProps();
        for (Map.Entry<String, String> each : orderedProperties.entrySet()) {
            siteProperties.put(String.valueOf(each.getKey()), String.valueOf(each.getValue()));
        }
        return siteProperties;
    }

    private OrderedProperties buildSiteOrderedProps() {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource("kylin-defaults.properties");
            Preconditions.checkNotNull((Object)resource);
            logger.info("Loading kylin-defaults.properties from {}", (Object)resource.getPath());
            OrderedProperties orderedProperties = new OrderedProperties();
            KylinExternalConfigLoader.loadAndTrimProperties(resource.openStream(), orderedProperties);
            for (int i = 0; i < 10; ++i) {
                String fileName = "kylin-defaults" + i + ".properties";
                URL additionalResource = Thread.currentThread().getContextClassLoader().getResource(fileName);
                if (additionalResource == null) continue;
                logger.info("Loading {} from {} ", (Object)fileName, (Object)additionalResource.getPath());
                KylinExternalConfigLoader.loadAndTrimProperties(additionalResource.openStream(), orderedProperties);
            }
            if (this.propFile == null || !this.propFile.exists()) {
                logger.error("fail to locate kylin.properties");
                throw new KylinConfigCannotInitException("fail to locate kylin.properties");
            }
            KylinExternalConfigLoader.loadAndTrimProperties(Files.newInputStream(this.propFile.toPath(), new OpenOption[0]), orderedProperties);
            File propOverrideFile = new File(this.propFile.getParentFile(), this.propFile.getName() + ".override");
            if (propOverrideFile.exists()) {
                KylinExternalConfigLoader.loadAndTrimProperties(Files.newInputStream(propOverrideFile.toPath(), new OpenOption[0]), orderedProperties);
            }
            return orderedProperties;
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OrderedProperties loadPropertiesFromInputStream(InputStream inputStream) {
        try (BufferedReader confReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            OrderedProperties temp = new OrderedProperties();
            temp.load(confReader);
            OrderedProperties orderedProperties = temp;
            return orderedProperties;
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, (Throwable)e);
        }
    }

    private static void loadAndTrimProperties(@Nonnull InputStream inputStream, @Nonnull OrderedProperties properties) {
        Preconditions.checkNotNull((Object)inputStream);
        Preconditions.checkNotNull((Object)properties);
        try {
            OrderedProperties trimProps = OrderedProperties.copyAndTrim(KylinExternalConfigLoader.loadPropertiesFromInputStream(inputStream));
            properties.putAll(KylinConfigBase.BCC.check(trimProps));
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.UNKNOWN_ERROR_CODE, " loadAndTrimProperties error ", e);
        }
    }

    public String getConfig() {
        StringWriter writer = new StringWriter();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            writer.append(entry.getKey() + "=" + entry.getValue()).append("\n");
        }
        return writer.toString();
    }

    public String getProperty(String key) {
        return Objects.toString(this.properties.get(key), null);
    }

    @Deprecated
    public Properties getProperties() {
        Properties newProperties = new Properties();
        newProperties.putAll(this.properties);
        return newProperties;
    }

    @Override
    public ImmutableMap<Object, Object> getPropertyEntries() {
        return this.propertyEntries;
    }
}

