/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.streaming.merge.MergePolicy;

public class NormalMergePolicy
extends MergePolicy {
    private boolean segSizeMatched = false;

    @Override
    public List<NDataSegment> selectMatchedSegList(List<NDataSegment> segList, int layer, long thresholdOfSegSize, int numberOfSeg) {
        this.matchSegList.clear();
        int idx = this.findStartIndex(segList, thresholdOfSegSize);
        if (idx != -1) {
            long totalThresholdOfSegSize = 0L;
            for (int i = idx; i < segList.size(); ++i) {
                if (segList.get(i).getAdditionalInfo().getOrDefault("file_layer", "0").equals(String.valueOf(layer))) {
                    this.matchSegList.add(segList.get(i));
                    if (this.matchSegList.size() < numberOfSeg && !this.isThresholdOfSegSizeOver(totalThresholdOfSegSize += segList.get(i).getStorageBytesSize(), thresholdOfSegSize)) continue;
                    break;
                }
                if (!this.matchSegList.isEmpty()) break;
            }
            this.segSizeMatched = this.matchSegList.size() >= numberOfSeg;
            return this.matchSegList;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean matchMergeCondition(long thresholdOfSegSize) {
        return this.segSizeMatched || this.matchSegList.size() > 1 && this.isThresholdOfSegSizeOver(this.matchSegList.stream().mapToLong(NDataSegment::getStorageBytesSize).sum(), thresholdOfSegSize);
    }

    @Override
    public void next(AtomicInteger currLayer) {
        currLayer.incrementAndGet();
    }
}

