/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.loader.ParserClassLoaderState;
import org.apache.kylin.metadata.jar.JarInfoManager;
import org.apache.kylin.metadata.jar.JarTypeEnum;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.streaming.DataParserInfo;
import org.apache.kylin.metadata.streaming.DataParserManager;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.rest.KafkaCondition;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.sample.KafkaSourceHandler;
import org.apache.kylin.sample.StreamingSourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component(value="kafkaService")
@Conditional(value={KafkaCondition.class})
public class KafkaService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaService.class);
    @Autowired
    private AclEvaluate aclEvaluate;
    private final StreamingSourceHandler sourceHandler = new KafkaSourceHandler();

    public Map<String, List<String>> getTopics(KafkaConfig kafkaConfig, String project, String fuzzyTopic) {
        if (StringUtils.isEmpty((CharSequence)kafkaConfig.getKafkaBootstrapServers())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_BROKER_DEFINITION, MsgPicker.getMsg().getInvalidBrokerDefinition());
        }
        this.aclEvaluate.checkProjectWritePermission(project);
        this.checkBrokerStatus(kafkaConfig);
        return this.sourceHandler.getTopics(kafkaConfig, fuzzyTopic);
    }

    public void checkBrokerStatus(KafkaConfig kafkaConfig) {
        List brokenBrokers = this.sourceHandler.getBrokenBrokers(kafkaConfig);
        if (CollectionUtils.isEmpty((Collection)brokenBrokers)) {
            return;
        }
        HashMap brokenBrokersMap = Maps.newHashMap();
        brokenBrokersMap.put("failed_servers", brokenBrokers);
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.BROKER_TIMEOUT_MESSAGE, MsgPicker.getMsg().getBrokerTimeoutMessage()).withData((Object)brokenBrokersMap);
    }

    public List<ByteBuffer> getMessages(KafkaConfig kafkaConfig, String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (StringUtils.isEmpty((CharSequence)kafkaConfig.getKafkaBootstrapServers())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_BROKER_DEFINITION, MsgPicker.getMsg().getInvalidBrokerDefinition());
        }
        try {
            return this.sourceHandler.getMessages(kafkaConfig);
        }
        catch (TimeoutException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_TIMEOUT_MESSAGE, MsgPicker.getMsg().getStreamingTimeoutMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> decodeMessage(List<ByteBuffer> messages) {
        List samples = messages.stream().map(buffer -> StandardCharsets.UTF_8.decode((ByteBuffer)buffer).toString()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        HashMap resp = Maps.newHashMap();
        resp.put("message_type", "custom");
        resp.put("message", samples);
        return resp;
    }

    public Map<String, Object> parserMessage(String project, KafkaConfig kafkaConfig, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_STREAMING_MESSAGE, MsgPicker.getMsg().getEmptyStreamingMessage());
        }
        kafkaConfig.setProject(project);
        this.initDefaultParser(project);
        return this.sourceHandler.parserMessage(kafkaConfig, message);
    }

    public List<String> getParsers(String project) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.initDefaultParser(project);
        return ((DataParserManager)this.getManager(DataParserManager.class, project)).listDataParserInfo().stream().map(DataParserInfo::getClassName).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    public String removeParser(String project, String className) {
        this.aclEvaluate.checkProjectWritePermission(project);
        AtomicBoolean noNeedDeleteJar = new AtomicBoolean(true);
        AtomicReference jarPath = new AtomicReference();
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            DataParserManager parserManager = (DataParserManager)this.getManager(DataParserManager.class, project);
            DataParserInfo parser = parserManager.removeParser(className);
            noNeedDeleteJar.set(parserManager.jarHasParser(parser.getJarName()));
            if (!noNeedDeleteJar.get()) {
                jarPath.set(((JarInfoManager)this.getManager(JarInfoManager.class, project)).removeJarInfo(JarTypeEnum.STREAMING_CUSTOM_PARSER, parser.getJarName()).getJarPath());
            }
            return null;
        }, (String)project);
        if (!noNeedDeleteJar.get()) {
            ParserClassLoaderState.getInstance((String)project).unregisterJar((Set)Sets.newHashSet((Object[])new String[]{(String)jarPath.get()}));
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path((String)jarPath.get()));
            log.info("remove jar {} success", jarPath);
        }
        return className;
    }
}

