/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PasswordEncodeFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordEncodeFactory.class);

    public static PasswordEncoder newUserPasswordEncoder() {
        PasswordEncoder passwordEncoder;
        String userPasswordEncode = KylinConfig.getInstanceFromEnv().getUserPasswordEncoder();
        log.debug("using '{}' for user password encode", (Object)userPasswordEncode);
        try {
            passwordEncoder = (PasswordEncoder)Class.forName(userPasswordEncode).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("class '{}' is not found, password init failed", (Object)userPasswordEncode, (Object)e);
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.PASSWORD_INVALID_ENCODER, new Object[0]);
        }
        catch (Exception e) {
            log.error("password encoder init failed", (Throwable)e);
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.PASSWORD_INIT_ENCODER_FAILED, new Object[0]);
        }
        return passwordEncoder;
    }
}

