/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.view.LogicalView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalViewManager {
    private static final Logger logger = LoggerFactory.getLogger(LogicalViewManager.class);
    private KylinConfig config;
    private CachedCrudAssist<LogicalView> crud;

    public static LogicalViewManager getInstance(KylinConfig config) {
        return (LogicalViewManager)config.getManager(LogicalViewManager.class);
    }

    static LogicalViewManager newInstance(KylinConfig config) {
        return new LogicalViewManager(config);
    }

    public LogicalViewManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing LogicalView with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.crud = new CachedCrudAssist<LogicalView>(this.getStore(), MetadataType.LOGICAL_VIEW, null, LogicalView.class){

            @Override
            protected LogicalView initEntityAfterReload(LogicalView view, String resourceName) {
                return view;
            }
        };
    }

    public LogicalView copyForWrite(LogicalView view) {
        return this.crud.copyForWrite(view);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public LogicalView get(String name) {
        return this.crud.get(StringUtils.upperCase((String)name));
    }

    public List<LogicalView> list() {
        return this.crud.listAll();
    }

    public void update(LogicalView view) {
        LogicalView exist = this.get(view.getTableName());
        LogicalView copy = this.copyForWrite(view);
        if (exist != null) {
            copy.setCreatedSql(view.getCreatedSql());
            copy.setLastModified(exist.getLastModified());
            copy.setMvcc(exist.getMvcc());
        }
        this.crud.save(copy);
    }

    public void delete(String tableName) {
        this.crud.delete(StringUtils.upperCase((String)tableName));
    }

    public boolean exists(String tableName) {
        return this.get(tableName) != null;
    }

    public List<LogicalView> findLogicalViewsInModel(String project, String dataflowId) {
        ArrayList viewsInModel = Lists.newArrayList();
        NDataflow df = NDataflowManager.getInstance(this.config, project).getDataflow(dataflowId);
        if (df == null) {
            return viewsInModel;
        }
        String logicalViewDB = KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB();
        NDataModel model = df.getModel();
        model.getAllTableRefs().forEach(tableRef -> {
            if (logicalViewDB.equalsIgnoreCase(tableRef.getTableDesc().getDatabase()) && this.get(tableRef.getTableName()) != null) {
                viewsInModel.add(this.get(tableRef.getTableName()));
            }
        });
        return viewsInModel;
    }

    public LogicalView findLogicalViewInProject(String project, String tableName) {
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance(this.config, project);
        TableDesc table = tblMgr.getTableDesc(tableName);
        if (table == null || !table.isLogicalView()) {
            return null;
        }
        LogicalView logicalView = this.get(table.getName());
        if (logicalView != null && logicalView.getCreatedProject().equalsIgnoreCase(project)) {
            return logicalView;
        }
        return null;
    }
}

