/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.streaming.RowCountDetailByTimeMapper;
import org.apache.kylin.metadata.streaming.StreamingJobStatsManager;
import org.apache.kylin.metadata.streaming.StreamingJobStatsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobStatsStoreUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJobStatsStoreUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String CREATE_STREAMING_JOB_STATS_TABLE = "create.streamingjobstats.store.table";
    private static final String CREATE_STREAMING_JOB_STATS_INDEX1 = "create.streamingjobstats.store.tableindex1";
    private static final String CREATE_STREAMING_JOB_STATS_INDEX2 = "create.streamingjobstats.store.tableindex2";

    private StreamingJobStatsStoreUtil() {
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource, String tableName) {
        return (SqlSessionFactory)Singletons.getInstance((String)"streaming-job-stats-session-factory", SqlSessionFactory.class, clz -> {
            JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
            Environment environment = new Environment("streaming job stats", (TransactionFactory)transactionFactory, dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setUseGeneratedKeys(true);
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.addMapper(StreamingJobStatsMapper.class);
            configuration.addMapper(RowCountDetailByTimeMapper.class);
            StreamingJobStatsStoreUtil.createStreamingJobStatsIfNotExist((BasicDataSource)dataSource, tableName);
            return new SqlSessionFactoryBuilder().build(configuration);
        });
    }

    private static void createStreamingJobStatsIfNotExist(BasicDataSource dataSource, String tableName) throws SQLException, IOException {
        Throwable throwable;
        Connection connection;
        try {
            connection = dataSource.getConnection();
            throwable = null;
            try {
                if (JdbcUtil.isTableExists((Connection)connection, (String)tableName)) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Fail to know if table {} exists", (Object)tableName, (Object)e);
            return;
        }
        connection = dataSource.getConnection();
        throwable = null;
        try {
            Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_STREAMING_JOB_STATS_TABLE), tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_STREAMING_JOB_STATS_INDEX1), tableName, tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, properties.getProperty(CREATE_STREAMING_JOB_STATS_INDEX2), tableName, tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (connection != null) {
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }

    public static void cleanStreamingJobStats() {
        String oldThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("streamingJobStatsCleanWorker");
            StreamingJobStatsManager.getInstance().deleteSJSIfRetainTimeReached();
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }
}

