/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConfigManager.class);
    private KylinConfig config;
    private String project;
    private CachedCrudAssist<KafkaConfig> crud;

    public static KafkaConfigManager getInstance(KylinConfig config, String project) {
        return (KafkaConfigManager)config.getManager(project, KafkaConfigManager.class);
    }

    static KafkaConfigManager newInstance(KylinConfig config, String project) {
        return new KafkaConfigManager(config, project);
    }

    private KafkaConfigManager(KylinConfig config, String project) {
        this.config = config;
        this.project = project;
        this.crud = new CachedCrudAssist<KafkaConfig>(this.getStore(), MetadataType.KAFKA_CONFIG, project, KafkaConfig.class){

            @Override
            protected KafkaConfig initEntityAfterReload(KafkaConfig t, String resourceName) {
                return t;
            }
        };
        this.crud.reloadAll();
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public KafkaConfig getKafkaConfig(String tableIdentity) {
        if (StringUtils.isEmpty((CharSequence)tableIdentity)) {
            return null;
        }
        return this.crud.get(KafkaConfig.generateResourceName(this.project, tableIdentity));
    }

    private KafkaConfig copyForWrite(KafkaConfig kafkaConfig) {
        return this.crud.copyForWrite(kafkaConfig);
    }

    public KafkaConfig createKafkaConfig(KafkaConfig kafkaConfig) {
        if (kafkaConfig == null || StringUtils.isEmpty((CharSequence)kafkaConfig.getName())) {
            throw new IllegalArgumentException();
        }
        KafkaConfig copy = this.copyForWrite(kafkaConfig);
        if (this.crud.contains(copy.resourceName())) {
            throw new IllegalArgumentException("Kafka Config '" + kafkaConfig.getName() + "' already exists");
        }
        copy.updateRandomUuid();
        return this.crud.save(copy);
    }

    public KafkaConfig updateKafkaConfig(KafkaConfig kafkaConfig) {
        KafkaConfig copy = this.copyForWrite(kafkaConfig);
        if (!this.crud.contains(copy.resourceName())) {
            throw new IllegalArgumentException("Kafka Config '" + kafkaConfig.getName() + "' does not exist.");
        }
        kafkaConfig.copyPropertiesTo(copy);
        return this.crud.save(copy);
    }

    public KafkaConfig removeKafkaConfig(String tableIdentity) {
        KafkaConfig kafkaConfig = this.getKafkaConfig(tableIdentity);
        if (kafkaConfig == null) {
            logger.warn("Dropping Kafka Config '{}' does not exist", (Object)tableIdentity);
            return null;
        }
        this.crud.delete(kafkaConfig);
        logger.info("Dropping Kafka Config '{}'", (Object)tableIdentity);
        return kafkaConfig;
    }

    public List<KafkaConfig> listAllKafkaConfigs() {
        return new ArrayList<KafkaConfig>(this.crud.listAll());
    }

    public List<KafkaConfig> getKafkaTablesUsingTable(String table) {
        ArrayList<KafkaConfig> kafkaConfigs = new ArrayList<KafkaConfig>();
        for (KafkaConfig kafkaConfig : this.listAllKafkaConfigs()) {
            if (!kafkaConfig.hasBatchTable() || !kafkaConfig.getBatchTable().equals(table)) continue;
            kafkaConfigs.add(kafkaConfig);
        }
        return kafkaConfigs;
    }

    public void invalidCache(String resourceName) {
        this.crud.invalidateCache(resourceName);
    }
}

