/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.ref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.HashBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.model.AntiFlatChecker;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.candidate.RawRecSelection;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.metadata.recommendation.ref.BrokenRefProxy;
import org.apache.kylin.metadata.recommendation.ref.CCRef;
import org.apache.kylin.metadata.recommendation.ref.DimensionRef;
import org.apache.kylin.metadata.recommendation.ref.LayoutRef;
import org.apache.kylin.metadata.recommendation.ref.MeasureRef;
import org.apache.kylin.metadata.recommendation.ref.ModelColumnRef;
import org.apache.kylin.metadata.recommendation.ref.RecommendationRef;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptRecV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptRecV2.class);
    private static final int CONSTANT = Integer.MAX_VALUE;
    private static final String MEASURE_NAME_PREFIX = "MEASURE_AUTO_";
    private static final String CC_AS_DIMENSION_PREFIX = "DIMENSION_AUTO_";
    private final String uuid;
    private final KylinConfig config;
    private final String project;
    private final Map<String, RawRecItem> uniqueFlagToRecItemMap;
    private final Map<String, RawRecItem> uuidToRecItemMap = new HashMap<String, RawRecItem>();
    private final BiMap<String, Integer> uniqueFlagToId = HashBiMap.create();
    private final List<Integer> rawIds = Lists.newArrayList();
    private final Map<Integer, RecommendationRef> columnRefs = Maps.newHashMap();
    private final Map<Integer, RecommendationRef> ccRefs = Maps.newHashMap();
    private final Map<Integer, RecommendationRef> dimensionRefs = Maps.newHashMap();
    private final Map<Integer, RecommendationRef> measureRefs = Maps.newHashMap();
    private final Map<Integer, LayoutRef> additionalLayoutRefs = Maps.newHashMap();
    private final Map<Integer, LayoutRef> removalLayoutRefs = Maps.newHashMap();
    private final Map<Integer, RawRecItem> rawRecItemMap = Maps.newHashMap();
    private final Set<Integer> brokenRefIds = Sets.newHashSet();
    private final AtomicReference<Object> layouts = new AtomicReference();
    private final AtomicReference<Object> model = new AtomicReference();
    private final AtomicReference<Object> projectCCMap = new AtomicReference();
    private final AntiFlatChecker antiFlatChecker;
    private final ColExcludedChecker excludedChecker;
    private final boolean needLog;

    public OptRecV2(String project, String uuid, boolean needLog) {
        this.needLog = needLog;
        this.config = KylinConfig.getInstanceFromEnv();
        this.uuid = uuid;
        this.project = project;
        this.uniqueFlagToRecItemMap = RawRecManager.getInstance(project).queryNonLayoutRecItems(Sets.newHashSet((Object[])new String[]{uuid}));
        this.uniqueFlagToRecItemMap.forEach((k, recItem) -> {
            this.uniqueFlagToId.put(k, (Object)recItem.getId());
            this.uuidToRecItemMap.put(recItem.getRecEntity().getUuid(), (RawRecItem)recItem);
        });
        this.antiFlatChecker = new AntiFlatChecker(this.getModel().getJoinTables(), this.getModel());
        this.excludedChecker = new ColExcludedChecker(this.config, project, this.getModel());
        if (!this.getModel().isBroken()) {
            this.initModelColumnRefs(this.getModel());
            this.initModelMeasureRefs(this.getModel());
        }
    }

    public void initRecommendation() {
        log.debug("Start to initialize recommendation({}/{}}", (Object)this.project, (Object)this.getUuid());
        NDataModel dataModel = this.getModel();
        if (dataModel.isBroken()) {
            log.warn("Discard all related recommendations for model({}/{}) is broken.", (Object)this.project, (Object)this.uuid);
            RawRecManager.getInstance(this.project).discardRecItemsOfBrokenModel(dataModel.getUuid());
            return;
        }
        this.initLayoutRefs(this.queryBestLayoutRecItems());
        this.initLayoutRefs(this.queryIndexPlannerRecItems());
        this.initLayoutRefs(this.queryImportedRawRecItems());
        this.initRemovalLayoutRefs(this.queryBestRemovalLayoutRecItems());
        this.autoNameForMeasure();
        this.brokenRefIds.addAll(this.collectBrokenRefs());
        log.info("Initialize recommendation({}/{}) successfully.", (Object)this.project, (Object)this.uuid);
    }

    public List<RawRecItem> filterExcludedRecPatterns(List<RawRecItem> rawRecItems) {
        log.debug("Start to initialize recommendation patterns({}/{}}", (Object)this.project, (Object)this.getUuid());
        NDataModel dataModel = this.getModel();
        if (dataModel.isBroken()) {
            log.warn("Discard all related recommendations for model({}/{}) is broken.", (Object)this.project, (Object)this.uuid);
            RawRecManager.getInstance(this.project).discardRecItemsOfBrokenModel(dataModel.getUuid());
            return Lists.newArrayList();
        }
        ArrayList reserved = Lists.newArrayList();
        this.initLayoutRefs(rawRecItems);
        this.brokenRefIds.addAll(this.collectBrokenRefs());
        log.info("Initialize recommendation patterns({}/{}) successfully.", (Object)this.project, (Object)this.uuid);
        return reserved;
    }

    private void autoNameForMeasure() {
        AtomicInteger maxMeasureIndex = new AtomicInteger(this.getBiggestAutoMeasureIndex(this.getModel()));
        List<RecommendationRef> allMeasureRefs = this.getEffectiveRefs(this.measureRefs);
        for (RecommendationRef entry : allMeasureRefs) {
            MeasureRef measureRef = (MeasureRef)entry;
            String measureName = MEASURE_NAME_PREFIX + maxMeasureIndex.incrementAndGet();
            measureRef.getMeasure().setName(measureName);
            measureRef.setName(measureName);
            measureRef.setContent(JsonUtil.writeValueAsStringQuietly((Object)measureRef.getMeasure()));
        }
    }

    public int getBiggestAutoMeasureIndex(NDataModel dataModel) {
        int biggest = 0;
        List allAutoMeasureNames = dataModel.getAllMeasures().stream().map(MeasureDesc::getName).filter(name -> name.startsWith(MEASURE_NAME_PREFIX)).collect(Collectors.toList());
        for (String name2 : allAutoMeasureNames) {
            int idx;
            try {
                String idxStr = name2.substring(MEASURE_NAME_PREFIX.length());
                idx = StringUtils.isEmpty((CharSequence)idxStr) ? -1 : Integer.parseInt(idxStr);
            }
            catch (NumberFormatException e) {
                idx = -1;
            }
            if (idx <= biggest) continue;
            biggest = idx;
        }
        return biggest;
    }

    private void initModelColumnRefs(NDataModel model) {
        List<ComputedColumnDesc> ccList = model.getComputedColumnDescs();
        HashMap ccNameToExpressionMap = Maps.newHashMap();
        ccList.forEach(cc -> ccNameToExpressionMap.put(cc.getFullName(), cc.getExpression()));
        for (NDataModel.NamedColumn column : model.getAllNamedColumns()) {
            if (!column.isExist()) continue;
            int id = column.getId();
            String columnName = column.getAliasDotColumn();
            String content = ccNameToExpressionMap.getOrDefault(columnName, columnName);
            TblColRef tblColRef = (TblColRef)model.getEffectiveCols().get((Object)column.getId());
            ModelColumnRef columnRef = new ModelColumnRef(column, tblColRef.getDatatype(), content);
            if (this.antiFlatChecker.isColOfAntiLookup(tblColRef) || this.excludedChecker.isExcludedCol(tblColRef)) {
                columnRef.setExcluded(true);
            }
            this.columnRefs.put(id, columnRef);
            if (!column.isDimension()) continue;
            this.dimensionRefs.put(id, new DimensionRef(columnRef, id, tblColRef.getDatatype(), true));
        }
    }

    private void initModelMeasureRefs(NDataModel model) {
        for (NDataModel.Measure measure : model.getAllMeasures()) {
            if (measure.isTomb()) continue;
            MeasureRef measureRef = new MeasureRef(measure, measure.getId(), true);
            measure.getFunction().getParameters().stream().filter(ParameterDesc::isColumnType).forEach(p -> {
                int id = model.getColumnIdByColumnName(p.getValue());
                if (this.antiFlatChecker.isColOfAntiLookup(p.getColRef()) || this.excludedChecker.isExcludedCol(p.getColRef())) {
                    measureRef.setExcluded(true);
                }
                measureRef.getDependencies().add(this.columnRefs.get(id));
            });
            this.measureRefs.put(measure.getId(), measureRef);
        }
    }

    private void initLayoutRefs(List<RawRecItem> bestRecItems) {
        bestRecItems.forEach(rawRecItem -> this.rawIds.add(rawRecItem.getId()));
        bestRecItems.forEach(rawRecItem -> this.rawRecItemMap.put(rawRecItem.getId(), (RawRecItem)rawRecItem));
        bestRecItems.forEach(this::initLayoutRef);
    }

    private void initRemovalLayoutRefs(List<RawRecItem> removalLayoutRecItems) {
        removalLayoutRecItems.forEach(rawRecItem -> {
            this.rawIds.add(rawRecItem.getId());
            this.rawRecItemMap.put(rawRecItem.getId(), (RawRecItem)rawRecItem);
            this.logTranslateInfo((RawRecItem)rawRecItem);
            LayoutRef ref = this.convertToLayoutRef((RawRecItem)rawRecItem);
            this.removalLayoutRefs.put(-rawRecItem.getId(), ref);
        });
    }

    private List<RawRecItem> queryBestLayoutRecItems() {
        FavoriteRule favoriteRule = FavoriteRuleManager.getInstance(this.project).getOrDefaultByName("recommendations");
        int topN = Integer.parseInt(((FavoriteRule.Condition)favoriteRule.getConds().get(0)).getRightThreshold());
        return RawRecSelection.getInstance().selectBestLayout(topN, this.uuid, this.project);
    }

    private List<RawRecItem> queryIndexPlannerRecItems() {
        RawRecManager rawRecManager = RawRecManager.getInstance(this.project);
        return rawRecManager.queryIndexPlannerRecItems(this.project, this.uuid);
    }

    private List<RawRecItem> queryImportedRawRecItems() {
        return RawRecManager.getInstance(this.project).queryImportedRawRecItems(this.project, this.uuid);
    }

    private List<RawRecItem> queryBestRemovalLayoutRecItems() {
        Map<String, RawRecItem> recItemMap = RawRecManager.getInstance(this.project).queryNonAppliedLayoutRawRecItems(this.uuid, false);
        ArrayList initialRemovalLayoutRecItems = Lists.newArrayList();
        recItemMap.forEach((key, value) -> {
            if (value.getState() == RawRecItem.RawRecState.INITIAL) {
                initialRemovalLayoutRecItems.add(value);
            }
        });
        return initialRemovalLayoutRecItems;
    }

    private void initLayoutRef(RawRecItem rawRecItem) {
        this.logTranslateInfo(rawRecItem);
        LayoutRef ref = this.convertToLayoutRef(rawRecItem);
        this.additionalLayoutRefs.put(-rawRecItem.getId(), ref);
        if (ref.isBroken()) {
            return;
        }
        this.checkLayoutExists(rawRecItem);
    }

    private void checkLayoutExists(RawRecItem recItem) {
        int negRecItemId = -recItem.getId();
        LayoutRef layoutRef = this.additionalLayoutRefs.get(negRecItemId);
        LayoutEntity layout = (LayoutEntity)JsonUtil.deepCopyQuietly((Object)layoutRef.getLayout(), LayoutEntity.class);
        ArrayList colOrder = Lists.newArrayList();
        ArrayList sortColumns = Lists.newArrayList();
        ArrayList partitionColumns = Lists.newArrayList();
        ArrayList shardColumns = Lists.newArrayList();
        boolean containNotExistsColumn = this.translate(colOrder, (List<Integer>)layout.getColOrder());
        if (!containNotExistsColumn) {
            this.translate(sortColumns, layout.getSortByColumns());
            this.translate(shardColumns, layout.getShardByColumns());
            this.translate(partitionColumns, layout.getPartitionByColumns());
            layout.setColOrder(colOrder);
            layout.setShardByColumns(shardColumns);
            layout.setPartitionByColumns(partitionColumns);
            long layoutId = this.getLayouts().stream().filter(layoutEntity -> layoutEntity.equals(layout)).map(LayoutEntity::getId).findFirst().orElse(-1L);
            if (layoutId > 0L) {
                this.logConflictWithRealEntity(recItem, layoutId);
                layoutRef.setExisted(true);
                return;
            }
        }
        for (RecommendationRef entry : this.getEffectiveRefs(this.additionalLayoutRefs)) {
            if (entry.getId() == negRecItemId || !Objects.equals(entry, layoutRef)) continue;
            this.logDuplicateRawRecItem(recItem, -entry.getId());
            layoutRef.setExisted(true);
            return;
        }
    }

    private boolean translate(List<Integer> toColIds, List<Integer> fromColIds) {
        for (Integer id : fromColIds) {
            RecommendationRef ref;
            RecommendationRef recommendationRef = ref = this.dimensionRefs.containsKey(id) ? this.dimensionRefs.get(id) : this.measureRefs.get(id);
            if (ref == null || !ref.isExisted()) {
                return true;
            }
            toColIds.add(ref.getId());
        }
        return false;
    }

    private LayoutRef convertToLayoutRef(RawRecItem rawRecItem) {
        NIndexPlanManager indexMgr;
        Map<Long, LayoutEntity> allLayoutsMap;
        int negRecItemId = -rawRecItem.getId();
        NDataModel dataModel = this.getModel();
        if (rawRecItem.isOutOfDate(dataModel.getSemanticVersion())) {
            this.logSemanticNotMatch(rawRecItem, dataModel);
            return BrokenRefProxy.getProxy(LayoutRef.class, negRecItemId);
        }
        LayoutEntity layout = RawRecUtil.getLayout(rawRecItem);
        if (RawRecItem.RawRecType.REMOVAL_LAYOUT == rawRecItem.getType() && !(allLayoutsMap = (indexMgr = NIndexPlanManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project)).getIndexPlan(this.uuid).getAllLayoutsMap()).containsKey(layout.getId())) {
            return BrokenRefProxy.getProxy(LayoutRef.class, negRecItemId);
        }
        LayoutRef layoutRef = new LayoutRef(layout, negRecItemId, rawRecItem.isAgg());
        for (int dependId : rawRecItem.getDependIDs()) {
            this.initDependencyRef(dependId, dataModel);
            if (this.dimensionRefs.containsKey(dependId) || this.measureRefs.containsKey(dependId)) {
                RecommendationRef ref;
                RecommendationRef recommendationRef = ref = this.dimensionRefs.containsKey(dependId) ? this.dimensionRefs.get(dependId) : this.measureRefs.get(dependId);
                if (ref.isBroken()) {
                    this.logDependencyLost(rawRecItem, dependId);
                    return BrokenRefProxy.getProxy(LayoutRef.class, layoutRef.getId());
                }
                if (ref.isExcluded()) {
                    layoutRef.setExcluded(true);
                }
                layoutRef.getDependencies().add(ref);
                continue;
            }
            if (dependId <= 0) continue;
            this.logDependencyLost(rawRecItem, dependId);
            return BrokenRefProxy.getProxy(LayoutRef.class, layoutRef.getId());
        }
        return layoutRef;
    }

    private void initDependencyRef(int dependId, NDataModel dataModel) {
        RawRecItem rawRecItem;
        if (dependId >= 0) {
            log.info("DependId({}) is derived from model({}/{})", new Object[]{dependId, this.getProject(), dataModel.getUuid()});
            return;
        }
        int rawRecItemId = -dependId;
        if (this.rawRecItemMap.containsKey(rawRecItemId)) {
            this.logRawRecItemHasBeenInitialized(dataModel, rawRecItemId);
            return;
        }
        String uniqueFlag = (String)this.uniqueFlagToId.inverse().get((Object)rawRecItemId);
        RawRecItem rawRecItem2 = rawRecItem = uniqueFlag == null ? null : this.uniqueFlagToRecItemMap.get(uniqueFlag);
        if (rawRecItem == null) {
            this.logRawRecItemNotFoundError(rawRecItemId);
            this.ccRefs.put(dependId, BrokenRefProxy.getProxy(CCRef.class, dependId));
            this.dimensionRefs.put(dependId, BrokenRefProxy.getProxy(DimensionRef.class, dependId));
            this.measureRefs.put(dependId, BrokenRefProxy.getProxy(MeasureRef.class, dependId));
            this.rawRecItemMap.put(dependId, null);
            return;
        }
        switch (rawRecItem.getType()) {
            case COMPUTED_COLUMN: {
                this.initCCRef(rawRecItem, dataModel);
                break;
            }
            case DIMENSION: {
                this.initDimensionRef(rawRecItem, dataModel);
                break;
            }
            case MEASURE: {
                this.initMeasureRef(rawRecItem, dataModel);
                break;
            }
            default: {
                throw new IllegalStateException("id: " + rawRecItemId + " type is illegal");
            }
        }
        this.rawRecItemMap.put(rawRecItemId, rawRecItem);
    }

    private void initCCRef(RawRecItem rawRecItem, NDataModel dataModel) {
        int[] dependIds;
        this.logTranslateInfo(rawRecItem);
        int negRecItemId = -rawRecItem.getId();
        if (rawRecItem.isOutOfDate(dataModel.getSemanticVersion())) {
            this.logSemanticNotMatch(rawRecItem, dataModel);
            this.ccRefs.put(negRecItemId, BrokenRefProxy.getProxy(CCRef.class, negRecItemId));
            return;
        }
        HashMap ccMapOnModel = Maps.newHashMap();
        dataModel.getComputedColumnDescs().forEach(cc -> ccMapOnModel.put(cc.getInnerExpression(), cc));
        ComputedColumnDesc cc2 = RawRecUtil.getCC(rawRecItem);
        CCRef ccRef = new CCRef(cc2, negRecItemId);
        if (ccMapOnModel.containsKey(cc2.getInnerExpression())) {
            ComputedColumnDesc existCC = (ComputedColumnDesc)ccMapOnModel.get(cc2.getInnerExpression());
            ccRef = new CCRef(existCC, negRecItemId);
            ccRef.setExisted(true);
            ccRef.setCrossModel(false);
            dataModel.getEffectiveCols().forEach((key, tblColRef) -> {
                if (tblColRef.getIdentity().equalsIgnoreCase(existCC.getFullName())) {
                    this.ccRefs.put(negRecItemId, this.columnRefs.get(key));
                }
            });
            return;
        }
        if (this.getProjectCCMap().containsKey(cc2.getInnerExpression())) {
            ComputedColumnDesc existCC = this.getProjectCCMap().get(cc2.getInnerExpression());
            if (existCC.getTableIdentity().equalsIgnoreCase(cc2.getTableIdentity())) {
                ccRef = new CCRef(existCC, negRecItemId);
                ccRef.setExisted(false);
                ccRef.setCrossModel(true);
            } else {
                ccRef = new CCRef(cc2, negRecItemId);
                ccRef.setExisted(false);
                ccRef.setCrossModel(false);
            }
        }
        for (int dependId : dependIds = rawRecItem.getDependIDs()) {
            TranslatedState state = this.initDependencyWithState(dependId, ccRef);
            if (state != TranslatedState.BROKEN) continue;
            this.logDependencyLost(rawRecItem, dependId);
            this.ccRefs.put(negRecItemId, BrokenRefProxy.getProxy(CCRef.class, negRecItemId));
            return;
        }
        CCRecItemV2 recEntity = (CCRecItemV2)rawRecItem.getRecEntity();
        int[] newDependIds = recEntity.genDependIds(dataModel);
        if (!Arrays.equals(newDependIds, rawRecItem.getDependIDs())) {
            this.logIllegalRawRecItem(rawRecItem, rawRecItem.getDependIDs(), newDependIds);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        this.ccRefs.put(negRecItemId, ccRef);
        this.checkCCExist(rawRecItem);
    }

    private void checkCCExist(RawRecItem recItem) {
        int negRecItemId = -recItem.getId();
        RecommendationRef ref = this.ccRefs.get(negRecItemId);
        if (ref.isExisted() || !(ref instanceof CCRef)) {
            return;
        }
        CCRef ccRef = (CCRef)ref;
        for (RecommendationRef entry : this.getEffectiveRefs(this.ccRefs)) {
            CCRef anotherCCRef;
            if (entry.getId() == negRecItemId || !ccRef.isIdentical(anotherCCRef = (CCRef)entry)) continue;
            this.logDuplicateRawRecItem(recItem, -entry.getId());
            ccRef.setExisted(true);
            this.ccRefs.put(negRecItemId, this.ccRefs.get(entry.getId()));
            return;
        }
    }

    private void initDimensionRef(RawRecItem rawRecItem, NDataModel dataModel) {
        this.logTranslateInfo(rawRecItem);
        int negRecItemId = -rawRecItem.getId();
        if (rawRecItem.isOutOfDate(dataModel.getSemanticVersion())) {
            this.logSemanticNotMatch(rawRecItem, dataModel);
            this.dimensionRefs.put(negRecItemId, BrokenRefProxy.getProxy(DimensionRef.class, negRecItemId));
            return;
        }
        DimensionRef dimensionRef = new DimensionRef(negRecItemId);
        int[] dependIDs = rawRecItem.getDependIDs();
        Preconditions.checkArgument((dependIDs.length == 1 ? 1 : 0) != 0);
        int dependID = dependIDs[0];
        TranslatedState state = this.initDependencyWithState(dependID, dimensionRef);
        if (state == TranslatedState.BROKEN) {
            this.logDependencyLost(rawRecItem, dependID);
            this.dimensionRefs.put(negRecItemId, BrokenRefProxy.getProxy(DimensionRef.class, negRecItemId));
            return;
        }
        DimensionRecItemV2 recEntity = (DimensionRecItemV2)rawRecItem.getRecEntity();
        if (recEntity.getUniqueContent() == null) {
            this.logIncompatibleRawRecItem(rawRecItem);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        int[] newDependIds = recEntity.genDependIds(this.uuidToRecItemMap, recEntity.getUniqueContent(), dataModel);
        if (!Arrays.equals(newDependIds, rawRecItem.getDependIDs())) {
            this.logIllegalRawRecItem(rawRecItem, rawRecItem.getDependIDs(), newDependIds);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        dimensionRef.init();
        if (dependID < 0) {
            String dimRefName = dimensionRef.getName();
            dimensionRef.setName(dimRefName.replace("CC_AUTO_", CC_AS_DIMENSION_PREFIX));
        }
        this.dimensionRefs.put(negRecItemId, this.reuseIfAvailable(dimensionRef));
        this.checkDimensionExist(rawRecItem);
    }

    private DimensionRef reuseIfAvailable(DimensionRef dimensionRef) {
        NDataModel.NamedColumn column;
        RecommendationRef recommendationRef = dimensionRef.getDependencies().get(0);
        if (recommendationRef instanceof ModelColumnRef && (column = ((ModelColumnRef)recommendationRef).getColumn()).isDimension()) {
            dimensionRef = (DimensionRef)this.dimensionRefs.get(column.getId());
        }
        return dimensionRef;
    }

    private void checkDimensionExist(RawRecItem recItem) {
        int negRecItemId = -recItem.getId();
        RecommendationRef dimensionRef = this.dimensionRefs.get(negRecItemId);
        for (RecommendationRef entry : this.getEffectiveRefs(this.dimensionRefs)) {
            if (entry.getId() == negRecItemId || !Objects.equals(entry, dimensionRef)) continue;
            this.logDuplicateRawRecItem(recItem, -entry.getId());
            dimensionRef.setExisted(true);
            this.dimensionRefs.put(negRecItemId, this.dimensionRefs.get(entry.getId()));
            return;
        }
    }

    private void initMeasureRef(RawRecItem rawRecItem, NDataModel dataModel) {
        this.logTranslateInfo(rawRecItem);
        int negRecItemId = -rawRecItem.getId();
        if (rawRecItem.isOutOfDate(dataModel.getSemanticVersion())) {
            this.logSemanticNotMatch(rawRecItem, dataModel);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        MeasureRef ref = new MeasureRef(RawRecUtil.getMeasure(rawRecItem), negRecItemId, false);
        for (int value : rawRecItem.getDependIDs()) {
            TranslatedState state = this.initDependencyWithState(value, ref);
            if (state != TranslatedState.BROKEN) continue;
            this.logDependencyLost(rawRecItem, value);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        MeasureRecItemV2 recEntity = (MeasureRecItemV2)rawRecItem.getRecEntity();
        if (recEntity.getUniqueContent() == null) {
            this.logIncompatibleRawRecItem(rawRecItem);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        int[] newDependIds = recEntity.genDependIds(this.uuidToRecItemMap, recEntity.getUniqueContent(), dataModel);
        if (!Arrays.equals(newDependIds, rawRecItem.getDependIDs())) {
            this.logIllegalRawRecItem(rawRecItem, rawRecItem.getDependIDs(), newDependIds);
            this.measureRefs.put(negRecItemId, BrokenRefProxy.getProxy(MeasureRef.class, negRecItemId));
            return;
        }
        this.measureRefs.put(negRecItemId, ref);
        this.checkMeasureExist(rawRecItem);
    }

    private void checkMeasureExist(RawRecItem recItem) {
        int negRecItemId = -recItem.getId();
        MeasureRef measureRef = (MeasureRef)this.measureRefs.get(negRecItemId);
        for (RecommendationRef entry : this.getLegalRefs(this.measureRefs)) {
            if (entry.getId() == negRecItemId || !measureRef.isIdentical(entry)) continue;
            this.logDuplicateRawRecItem(recItem, -entry.getId());
            measureRef.setExisted(true);
            this.measureRefs.put(negRecItemId, this.measureRefs.get(entry.getId()));
            return;
        }
    }

    private TranslatedState initDependencyWithState(int dependId, RecommendationRef ref) {
        if (dependId == Integer.MAX_VALUE) {
            return TranslatedState.CONSTANT;
        }
        NDataModel dataModel = this.getModel();
        this.initDependencyRef(dependId, dataModel);
        if (this.columnRefs.containsKey(dependId)) {
            RecommendationRef e = this.columnRefs.get(dependId);
            if (e.isBroken()) {
                return TranslatedState.BROKEN;
            }
            if (e.isExcluded()) {
                ref.setExcluded(true);
            }
            ref.getDependencies().add(e);
        } else if (this.ccRefs.containsKey(dependId)) {
            RecommendationRef e = this.ccRefs.get(dependId);
            if (e.isBroken()) {
                return TranslatedState.BROKEN;
            }
            if (e.isExcluded()) {
                ref.setExcluded(true);
            }
            ref.getDependencies().add(e);
        } else {
            return TranslatedState.BROKEN;
        }
        return TranslatedState.NORMAL;
    }

    private List<RecommendationRef> getEffectiveRefs(Map<Integer, ? extends RecommendationRef> refMap) {
        ArrayList effectiveRefs = Lists.newArrayList();
        refMap.forEach((key, ref) -> {
            if (ref.isEffective()) {
                effectiveRefs.add(ref);
            }
        });
        effectiveRefs.sort(Comparator.comparingInt(RecommendationRef::getId));
        return effectiveRefs;
    }

    private List<RecommendationRef> getLegalRefs(Map<Integer, ? extends RecommendationRef> refMap) {
        HashSet effectiveRefs = Sets.newHashSet();
        refMap.forEach((key, ref) -> {
            if (ref.isLegal()) {
                effectiveRefs.add(ref);
            }
        });
        ArrayList effectiveRefList = Lists.newArrayList((Iterable)effectiveRefs);
        effectiveRefList.sort(Comparator.comparingInt(RecommendationRef::getId));
        return effectiveRefList;
    }

    private Set<Integer> collectBrokenRefs() {
        HashSet brokenIds = Sets.newHashSet();
        this.additionalLayoutRefs.forEach((id, ref) -> {
            if (ref.isBroken() && id < 0) {
                brokenIds.add(-id.intValue());
            }
        });
        this.removalLayoutRefs.forEach((id, ref) -> {
            if (ref.isBroken() && id < 0) {
                brokenIds.add(-id.intValue());
            }
        });
        this.fillBrokenRef(brokenIds, this.ccRefs);
        this.fillBrokenRef(brokenIds, this.dimensionRefs);
        this.fillBrokenRef(brokenIds, this.measureRefs);
        return brokenIds;
    }

    private void fillBrokenRef(Set<Integer> brokenIds, Map<Integer, RecommendationRef> refs) {
        refs.forEach((id, ref) -> {
            if (ref.isBroken() && id < 0) {
                brokenIds.add(-id.intValue());
            }
        });
    }

    private Map<String, ComputedColumnDesc> initAllCCMap() {
        HashMap ccMap = Maps.newHashMap();
        NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.readSystemKylinConfig(), this.project);
        List<NDataModel> allModels = modelManager.listAllModels();
        allModels.stream().filter(m -> !m.isBroken()).forEach(m -> {
            List<ComputedColumnDesc> ccList = m.getComputedColumnDescs();
            for (ComputedColumnDesc cc : ccList) {
                ccMap.putIfAbsent(cc.getInnerExpression(), cc);
            }
        });
        return ccMap;
    }

    private NDataModel initModel() {
        NDataModelManager modelManager = NDataModelManager.getInstance(Objects.requireNonNull(this.config), this.project);
        NDataModel dataModel = modelManager.getDataModelDesc(this.getUuid());
        return dataModel.isBroken() ? dataModel : modelManager.copyForWrite(dataModel);
    }

    private List<LayoutEntity> getAllLayouts() {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance(Objects.requireNonNull(this.config), this.project);
        return indexPlanManager.getIndexPlan(this.getUuid()).getAllLayouts();
    }

    private void logRawRecItemHasBeenInitialized(NDataModel dataModel, int rawRecItemId) {
        log.info("RawRecItem({}) already initialized for Recommendation({}/{})", new Object[]{rawRecItemId, this.getProject(), dataModel.getUuid()});
    }

    private void logRawRecItemNotFoundError(int rawRecItemId) {
        log.error("RawRecItem({}) is not found in recommendation({}/{})", new Object[]{rawRecItemId, this.project, this.getUuid()});
    }

    private void logTranslateInfo(RawRecItem recItem) {
        String type;
        switch (recItem.getType()) {
            case MEASURE: {
                type = "MeasureRef";
                break;
            }
            case COMPUTED_COLUMN: {
                type = "CCRef";
                break;
            }
            case ADDITIONAL_LAYOUT: 
            case REMOVAL_LAYOUT: {
                type = "LayoutRef";
                break;
            }
            case DIMENSION: {
                type = "DimensionRef";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        log.info("RawRecItem({}) will be translated to {} in Recommendation({}/{})", new Object[]{recItem.getId(), type, this.project, this.getUuid()});
    }

    private void logDependencyLost(RawRecItem rawRecItem, int dependId) {
        log.info("RawRecItem({}) lost dependency of {} in recommendation({}/{})", new Object[]{rawRecItem.getId(), dependId, this.getProject(), this.getUuid()});
    }

    private void logSemanticNotMatch(RawRecItem rawRecItem, NDataModel dataModel) {
        log.info("RawRecItem({}) has an outdated semanticVersion({}) less than {} in recommendation({}/{})", new Object[]{rawRecItem.getId(), rawRecItem.getSemanticVersion(), dataModel.getSemanticVersion(), this.getProject(), this.getUuid()});
    }

    private void logConflictWithRealEntity(RawRecItem recItem, long existingId) {
        log.info("RawRecItem({}) encounters an existing {}({}) in recommendation({}/{})", new Object[]{recItem.getId(), recItem.getType().name(), existingId, this.getProject(), this.getUuid()});
    }

    private void logDuplicateRawRecItem(RawRecItem recItem, int anotherRecItemId) {
        log.info("RawRecItem({}) duplicates with another RawRecItem({}) in recommendation({}/{})", new Object[]{recItem.getId(), anotherRecItemId, this.getProject(), this.getUuid()});
    }

    private void logIllegalRawRecItem(RawRecItem recItem, int[] oldDependIds, int[] newDependIds) {
        log.error("RawRecItem({}) illegal now for dependIds changed, old dependIds({}), new dependIds({})", new Object[]{recItem.getId(), Arrays.toString(oldDependIds), Arrays.toString(newDependIds)});
    }

    private void logIncompatibleRawRecItem(RawRecItem recItem) {
        log.info("RawRecItem({}) incompatible now for uniqueContent missing", (Object)recItem.getId());
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public KylinConfig getConfig() {
        return this.config;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public Map<String, RawRecItem> getUniqueFlagToRecItemMap() {
        return this.uniqueFlagToRecItemMap;
    }

    @Generated
    public Map<String, RawRecItem> getUuidToRecItemMap() {
        return this.uuidToRecItemMap;
    }

    @Generated
    public BiMap<String, Integer> getUniqueFlagToId() {
        return this.uniqueFlagToId;
    }

    @Generated
    public List<Integer> getRawIds() {
        return this.rawIds;
    }

    @Generated
    public Map<Integer, RecommendationRef> getColumnRefs() {
        return this.columnRefs;
    }

    @Generated
    public Map<Integer, RecommendationRef> getCcRefs() {
        return this.ccRefs;
    }

    @Generated
    public Map<Integer, RecommendationRef> getDimensionRefs() {
        return this.dimensionRefs;
    }

    @Generated
    public Map<Integer, RecommendationRef> getMeasureRefs() {
        return this.measureRefs;
    }

    @Generated
    public Map<Integer, LayoutRef> getAdditionalLayoutRefs() {
        return this.additionalLayoutRefs;
    }

    @Generated
    public Map<Integer, LayoutRef> getRemovalLayoutRefs() {
        return this.removalLayoutRefs;
    }

    @Generated
    public Map<Integer, RawRecItem> getRawRecItemMap() {
        return this.rawRecItemMap;
    }

    @Generated
    public Set<Integer> getBrokenRefIds() {
        return this.brokenRefIds;
    }

    @Generated
    public AntiFlatChecker getAntiFlatChecker() {
        return this.antiFlatChecker;
    }

    @Generated
    public ColExcludedChecker getExcludedChecker() {
        return this.excludedChecker;
    }

    @Generated
    public boolean isNeedLog() {
        return this.needLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public List<LayoutEntity> getLayouts() {
        Object value = this.layouts.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.layouts;
            synchronized (atomicReference) {
                value = this.layouts.get();
                if (value == null) {
                    List<LayoutEntity> actualValue = this.getAllLayouts();
                    value = actualValue == null ? this.layouts : actualValue;
                    this.layouts.set(value);
                }
            }
        }
        return (List)(value == this.layouts ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public NDataModel getModel() {
        Object value = this.model.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.model;
            synchronized (atomicReference) {
                value = this.model.get();
                if (value == null) {
                    NDataModel actualValue = this.initModel();
                    value = actualValue == null ? this.model : actualValue;
                    this.model.set(value);
                }
            }
        }
        return (NDataModel)((Object)(value == this.model ? null : value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, ComputedColumnDesc> getProjectCCMap() {
        Object value = this.projectCCMap.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.projectCCMap;
            synchronized (atomicReference) {
                value = this.projectCCMap.get();
                if (value == null) {
                    Map<String, ComputedColumnDesc> actualValue = this.initAllCCMap();
                    value = actualValue == null ? this.projectCCMap : actualValue;
                    this.projectCCMap.set(value);
                }
            }
        }
        return (Map)(value == this.projectCCMap ? null : value);
    }

    private static enum TranslatedState {
        CONSTANT,
        BROKEN,
        NORMAL,
        UNDEFINED;

    }
}

