/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.ref;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import lombok.Generated;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.recommendation.ref.RecommendationRef;

public class DimensionRef
extends RecommendationRef {
    public DimensionRef(int id) {
        this.setId(id);
    }

    public DimensionRef(RecommendationRef columnRef, int id, String dataType, boolean existed) {
        this.setId(id);
        this.setName(columnRef.getName());
        this.setContent(this.buildContent(columnRef.getName(), dataType));
        this.setDataType(dataType);
        this.setExisted(existed);
        this.setEntity(columnRef.getEntity());
        this.setExcluded(columnRef.isExcluded());
    }

    public void init() {
        if (this.getDependencies().isEmpty()) {
            return;
        }
        RecommendationRef dependRef = this.getDependencies().get(0);
        this.setName(dependRef.getName());
        this.setDataType(dependRef.getDataType());
        this.setContent(this.buildContent(this.getName(), this.getDataType()));
        this.setExisted(false);
        this.setEntity(dependRef);
    }

    private String buildContent(String columnName, String dataType) {
        String content;
        HashMap map = Maps.newHashMap();
        map.put("column", columnName);
        map.put("data_type", dataType);
        try {
            content = JsonUtil.writeValueAsString((Object)map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
        return content;
    }

    @Override
    public void rebuild(String newName) {
    }

    @Generated
    public DimensionRef() {
    }
}

