/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.project;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.constant.NonCustomProjectLevelConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.AutoMergeTimeEnum;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.MaintainModelType;
import org.apache.kylin.metadata.model.RetentionRange;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.VolatileRange;
import org.apache.kylin.metadata.project.ProjectStatusEnum;
import org.apache.kylin.metadata.project.RealizationEntry;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ProjectInstance
extends RootPersistentEntity
implements ISourceAware {
    public static final String DEFAULT_PROJECT_NAME = "default";
    public static final String DEFAULT_DATABASE = "DEFAULT";
    public static final String EXPOSE_COMPUTED_COLUMN_CONF = "kylin.query.metadata.expose-computed-column";
    private KylinConfigExt config;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="status")
    private ProjectStatusEnum status;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="default_database")
    private String defaultDatabase;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="principal")
    private String principal;
    @JsonProperty(value="keytab")
    private String keytab;
    @JsonProperty(value="maintain_model_type")
    private MaintainModelType maintainModelType = MaintainModelType.MANUAL_MAINTAIN;
    @JsonProperty(value="override_kylin_properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LinkedHashMap<String, String> overrideKylinProps;
    @JsonProperty(value="segment_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private SegmentConfig segmentConfig = new SegmentConfig(false, Lists.newArrayList((Object[])new AutoMergeTimeEnum[]{AutoMergeTimeEnum.WEEK, AutoMergeTimeEnum.MONTH, AutoMergeTimeEnum.QUARTER, AutoMergeTimeEnum.YEAR}), new VolatileRange(), new RetentionRange(), false);

    public static ProjectInstance create(String name, String owner, String description, LinkedHashMap<String, String> overrideProps) {
        ProjectInstance projectInstance = new ProjectInstance();
        projectInstance.setName(name);
        projectInstance.setOwner(owner);
        projectInstance.setDescription(description);
        projectInstance.setStatus(ProjectStatusEnum.ENABLED);
        projectInstance.setCreateTimeUTC(System.currentTimeMillis());
        projectInstance.setDefaultDatabase(DEFAULT_DATABASE);
        projectInstance.setOverrideKylinProps(overrideProps);
        return projectInstance;
    }

    public void initConfig(KylinConfig config) {
        if (!this.overrideKylinProps.containsKey(EXPOSE_COMPUTED_COLUMN_CONF)) {
            this.overrideKylinProps.put(EXPOSE_COMPUTED_COLUMN_CONF, "true");
        }
        this.config = KylinConfigExt.createInstance((KylinConfig)config, this.filterNonCustomConfigs(this.overrideKylinProps));
    }

    public String resourceName() {
        return this.name;
    }

    public void setResourceName(String resourceName) {
        this.name = resourceName;
    }

    public MetadataType resourceType() {
        return MetadataType.PROJECT;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProjectStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatusEnum status) {
        this.status = status;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSemiAutoMode() {
        return this.getConfig().isSemiAutoMode();
    }

    public boolean isExpertMode() {
        return !this.getConfig().isSemiAutoMode();
    }

    public boolean isProjectKerberosEnabled() {
        return this.config.getKerberosProjectLevelEnable() && StringUtils.isNotBlank((CharSequence)this.principal) && StringUtils.isNotBlank((CharSequence)this.keytab);
    }

    public ImmutableList<RealizationEntry> getRealizationEntries() {
        return ImmutableList.copyOf(this.getRealizationsFromResource(this.name));
    }

    public ImmutableList<String> getModels() {
        return ImmutableList.copyOf(this.getModelsFromResource(this.name));
    }

    public ImmutableSet<String> getTables() {
        return ImmutableSet.copyOf(this.getTableFromResource(this.name));
    }

    public int getRealizationCount(String realizationType) {
        List<RealizationEntry> realizationEntries = this.getRealizationsFromResource(this.name);
        if (realizationType == null) {
            return realizationEntries.size();
        }
        return (int)realizationEntries.stream().filter(input -> input.getType().equals(realizationType)).count();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean containsModel(String modelId) {
        List<String> models = this.getModelsFromResource(this.name);
        return models.contains(modelId);
    }

    public LinkedHashMap<String, String> getOverrideKylinProps() {
        return this.overrideKylinProps;
    }

    public Map<String, String> getLegalOverrideKylinProps() {
        return this.filterNonCustomConfigs(this.overrideKylinProps);
    }

    public void putOverrideKylinProps(String key, String value) {
        this.overrideKylinProps.put(StringUtils.trim((String)key), StringUtils.trim((String)value));
    }

    public void replaceKeyOverrideKylinProps(String originKey, String destKey) {
        String value = this.overrideKylinProps.get(originKey);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.overrideKylinProps.remove(originKey);
            this.putOverrideKylinProps(destKey, value);
        }
    }

    public void setOverrideKylinProps(LinkedHashMap<String, String> overrideKylinProps) {
        this.overrideKylinProps = overrideKylinProps = KylinConfig.trimKVFromMap(overrideKylinProps);
        if (this.config != null) {
            this.config = KylinConfigExt.createInstance((KylinConfig)this.config.base(), this.filterNonCustomConfigs(overrideKylinProps));
        }
    }

    private LinkedHashMap<String, String> filterNonCustomConfigs(LinkedHashMap<String, String> overrideKylinProps) {
        Set nonCustomConfigs = KylinConfig.getInstanceFromEnv().getUserDefinedNonCustomProjectConfigs();
        LinkedHashMap<String, String> filteredOverrideKylinProps = new LinkedHashMap<String, String>();
        overrideKylinProps.entrySet().stream().filter(entry -> !nonCustomConfigs.contains(entry.getKey())).forEach(entry -> {
            String cfr_ignored_0 = (String)filteredOverrideKylinProps.put((String)entry.getKey(), (String)entry.getValue());
        });
        return filteredOverrideKylinProps;
    }

    public KylinConfigExt getConfig() {
        return this.config;
    }

    public void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    public void init(KylinConfig config) {
        this.init(config, false);
    }

    public void init(KylinConfig config, boolean copyOverrides) {
        if (this.name == null) {
            this.name = DEFAULT_PROJECT_NAME;
        }
        if (copyOverrides && config instanceof KylinConfigExt) {
            this.overrideKylinProps = (LinkedHashMap)((KylinConfigExt)config).getExtendedOverrides();
        }
        if (this.overrideKylinProps == null) {
            this.overrideKylinProps = new LinkedHashMap();
        }
        this.initConfig(config);
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalStateException("Project name must not be blank");
        }
    }

    public String toString() {
        return "ProjectDesc [name=" + this.name + "]";
    }

    @Override
    public int getSourceType() {
        return this.getConfig().getDefaultSource();
    }

    private List<String> getModelsFromResource(String projectName) {
        NavigableSet modelResource = this.getStore().listResources(MetadataType.MODEL.name(), RawResourceFilter.equalFilter((String)"project", (String)projectName));
        return this.getNameListFromResource(modelResource);
    }

    private List<RealizationEntry> getRealizationsFromResource(String projectName) {
        NavigableSet realizationResource = this.getStore().listResources(MetadataType.DATAFLOW.name(), RawResourceFilter.equalFilter((String)"project", (String)projectName));
        if (realizationResource == null) {
            return new ArrayList<RealizationEntry>();
        }
        List<String> realizations = this.getNameListFromResource(realizationResource);
        ArrayList<RealizationEntry> realizationEntries = new ArrayList<RealizationEntry>();
        for (String realization : realizations) {
            RealizationEntry entry = RealizationEntry.create("NCUBE", realization);
            realizationEntries.add(entry);
        }
        return realizationEntries;
    }

    private Set<String> getTableFromResource(String projectName) {
        NavigableSet tableResource = this.getStore().listResources(MetadataType.TABLE_INFO.name(), RawResourceFilter.equalFilter((String)"project", (String)projectName));
        if (tableResource == null) {
            return new TreeSet<String>();
        }
        List<String> tables = this.getNameListFromResource(tableResource);
        return tables.stream().map(table -> table.substring(projectName.length() + 1)).collect(Collectors.toCollection(TreeSet::new));
    }

    private List<String> getNameListFromResource(Set<String> modelResource) {
        if (modelResource == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (String resource : modelResource) {
            String[] path = resource.split("/");
            resource = path[path.length - 1];
            resource = StringHelper.dropSuffix((String)resource, (String)".json");
            nameList.add(resource);
        }
        return nameList;
    }

    ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public List<String> getEmailUsers() {
        String users = this.getOverrideKylinProps().get(NonCustomProjectLevelConfig.NOTIFICATION_USER_EMAILS.getValue());
        if (users != null) {
            return Arrays.asList(StringHelper.split((String)users, (String)","));
        }
        return new ArrayList<String>();
    }

    @Generated
    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Generated
    public void setDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public String getKeytab() {
        return this.keytab;
    }

    @Generated
    public void setKeytab(String keytab) {
        this.keytab = keytab;
    }

    @Generated
    public MaintainModelType getMaintainModelType() {
        return this.maintainModelType;
    }

    @Generated
    public SegmentConfig getSegmentConfig() {
        return this.segmentConfig;
    }

    @Generated
    public void setSegmentConfig(SegmentConfig segmentConfig) {
        this.segmentConfig = segmentConfig;
    }
}

