/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.project;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NProjectLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NProjectLoader.class);
    private static final TransmittableThreadLocal<ProjectBundle> cache = new TransmittableThreadLocal();
    private final KylinConfig kylinConfig;

    public static void updateCache(@Nullable String project) {
        NProjectLoader projectLoader;
        ProjectBundle bundle;
        if (StringUtils.isNotEmpty((CharSequence)project) && !project.startsWith("_") && !(bundle = (projectLoader = new NProjectLoader(KylinConfig.getInstanceFromEnv())).load(project)).isEmpty()) {
            log.trace("set project {} cache {}, prev is {}", new Object[]{project, bundle, cache.get()});
            cache.set((Object)bundle);
        }
    }

    public static void removeCache() {
        log.trace("clear cache {}", cache.get());
        cache.remove();
    }

    public NProjectLoader(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public Set<IRealization> listAllRealizations(String project) {
        ProjectBundle prjCache = this.load(project);
        return Collections.unmodifiableSet(prjCache.realizationsByTable.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public Set<IRealization> getRealizationsByTable(String project, String table) {
        Set realizationsByTable = (Set)this.load(project).realizationsByTable.get(table);
        if (realizationsByTable == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(realizationsByTable);
    }

    public List<MeasureDesc> listEffectiveRewriteMeasures(String project, String table) {
        List effectiveRewriteMeasures = (List)this.load(project).tableToMeasuresMap.get(StringUtils.upperCase((String)table));
        return effectiveRewriteMeasures == null ? Collections.emptyList() : Collections.unmodifiableList(effectiveRewriteMeasures);
    }

    private boolean belongToFactTable(String table, NDataModel model) {
        return model.getRootFactTable().getTableIdentity().equals(table);
    }

    private ProjectBundle load(String project) {
        if (cache.get() != null) {
            return (ProjectBundle)cache.get();
        }
        ProjectBundle projectBundle = new ProjectBundle(project);
        ProjectInstance pi = NProjectManager.getInstance(this.kylinConfig).getProject(project);
        if (pi == null) {
            log.debug("Project `{}` doest not exist.", (Object)project);
            return projectBundle;
        }
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance(this.kylinConfig, project);
        Map<String, TableDesc> projectAllTables = tableMgr.getAllTablesMap();
        NDataflowManager dfMgr = NDataflowManager.getInstance(this.kylinConfig, project);
        FusionModelManager fusionModelMgr = FusionModelManager.getInstance(this.kylinConfig, project);
        pi.getRealizationEntries().parallelStream().forEach(entry -> {
            FusionModel fusionModel;
            IRealization realization = dfMgr.getRealization(entry.getRealization());
            if (realization == null) {
                log.warn("Realization '{}' defined under project '{}' is not found or it's broken.", entry, (Object)project);
                return;
            }
            NDataflow dataflow = (NDataflow)realization;
            if (dataflow.getModel().isFusionModel() && dataflow.isStreaming() && (fusionModel = fusionModelMgr.getFusionModel(dataflow.getModel().getFusionId())) != null) {
                NDataModel batchModel = fusionModel.getBatchModel();
                if (batchModel.isBroken()) {
                    log.warn("Realization '{}' defined under project '{}' is not found or it's broken.", entry, (Object)project);
                    return;
                }
                String batchDataflowId = batchModel.getUuid();
                NDataflow batchRealization = dfMgr.getDataflow(batchDataflowId);
                HybridRealization hybridRealization = new HybridRealization(batchRealization, realization, project);
                hybridRealization.setConfig(dataflow.getConfig());
                if (this.sanityCheck(hybridRealization, projectAllTables)) {
                    this.mapTableToRealization(projectBundle, hybridRealization);
                }
            }
            if (this.sanityCheck(realization, projectAllTables)) {
                this.mapTableToRealization(projectBundle, realization);
            }
        });
        this.mapEffectiveRewriteMeasuresByTable(projectBundle, projectAllTables);
        return projectBundle;
    }

    private boolean sanityCheck(IRealization realization, Map<String, TableDesc> projectAllTables) {
        if (realization == null) {
            return false;
        }
        Set<TblColRef> allColumns = realization.getAllColumns();
        if (allColumns.isEmpty() && realization.getMeasures().isEmpty()) {
            return false;
        }
        return allColumns.parallelStream().allMatch(col -> {
            TableDesc table = (TableDesc)projectAllTables.get(col.getTable());
            if (table == null) {
                log.error("Realization '{}' reports column '{}', but related table is not found by MetadataManager.", (Object)realization.getCanonicalName(), (Object)col.getCanonicalName());
                return false;
            }
            if (!col.getColumnDesc().isComputedColumn()) {
                ColumnDesc foundCol = table.findColumnByName(col.getOriginalName());
                if (!col.getColumnDesc().equals(foundCol)) {
                    log.error("Realization '{}' reports column '{}', but found '{}' according to MetadataManager.", new Object[]{realization.getCanonicalName(), col.getCanonicalName(), foundCol});
                    return false;
                }
            }
            return true;
        });
    }

    private void mapTableToRealization(ProjectBundle prjCache, IRealization realization) {
        Set<TableRef> allTables = realization.getModel().getAllTables();
        for (TableRef tbl : allTables) {
            prjCache.realizationsByTable.computeIfAbsent(tbl.getTableIdentity(), value -> ConcurrentHashMap.newKeySet());
            ((Set)prjCache.realizationsByTable.get(tbl.getTableIdentity())).add(realization);
        }
    }

    private void mapEffectiveRewriteMeasuresByTable(ProjectBundle prjCache, Map<String, TableDesc> projectAllTables) {
        Set<String> modelIds = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), prjCache.getProject()).listAllModelIds();
        projectAllTables.forEach((tableKey, tableDesc) -> {
            Set realizations = (Set)prjCache.realizationsByTable.get(tableKey);
            if (realizations == null) {
                return;
            }
            List existingRealizations = realizations.stream().filter(realization -> modelIds.contains(realization.getUuid())).collect(Collectors.toList());
            ArrayList measureDescs = Lists.newArrayList();
            for (IRealization realization2 : existingRealizations) {
                NDataModel model;
                if (!realization2.isOnline() || (model = realization2.getModel()) == null || model.isBroken()) continue;
                for (MeasureDesc measureDesc : realization2.getMeasures()) {
                    FunctionDesc func = measureDesc.getFunction();
                    if (!this.belongToFactTable((String)tableKey, model) || !func.needRewrite()) continue;
                    measureDescs.add(measureDesc);
                }
            }
            prjCache.tableToMeasuresMap.put(tableDesc.getIdentity(), measureDescs);
        });
    }

    private static class ProjectBundle {
        private final String project;
        private final Map<String, Set<IRealization>> realizationsByTable = new ConcurrentHashMap<String, Set<IRealization>>();
        private final Map<String, List<MeasureDesc>> tableToMeasuresMap = new ConcurrentHashMap<String, List<MeasureDesc>>();

        ProjectBundle(String project) {
            this.project = project;
        }

        public boolean isEmpty() {
            return this.realizationsByTable.isEmpty();
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public Map<String, Set<IRealization>> getRealizationsByTable() {
            return this.realizationsByTable;
        }

        @Generated
        public Map<String, List<MeasureDesc>> getTableToMeasuresMap() {
            return this.tableToMeasuresMap;
        }
    }
}

