/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util.scd2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.util.scd2.Scd2Simplifier;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinDesc;

public class SCD2CondChecker {
    public static final SCD2CondChecker INSTANCE = new SCD2CondChecker();
    private static final Set<Set<SqlKind>> SCD_2_JOIN_PAIRS = ImmutableSet.of((Object)Sets.newHashSet((Object[])new SqlKind[]{SqlKind.GREATER_THAN, SqlKind.LESS_THAN_OR_EQUAL}), (Object)Sets.newHashSet((Object[])new SqlKind[]{SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL}), (Object)Sets.newHashSet((Object[])new SqlKind[]{SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN}));

    public boolean checkSCD2EquiJoinCond(String[] fks, String[] pks) {
        return fks.length > 0 && fks.length == pks.length;
    }

    public boolean isScd2Model(NDataModel nDataModel) {
        if (nDataModel.getJoinTables().stream().noneMatch(joinTableDesc -> joinTableDesc.getJoin().isNonEquiJoin())) {
            return false;
        }
        return nDataModel.getJoinTables().stream().filter(joinTableDesc -> joinTableDesc.getJoin().isNonEquiJoin()).allMatch(joinTableDesc -> Scd2Simplifier.INSTANCE.isValidScd2JoinDesc(joinTableDesc.getJoin()));
    }

    public boolean checkFkPkPairUnique(SimplifiedJoinDesc joinDesc) {
        return this.checkFkPkPairUnique(Scd2Simplifier.INSTANCE.buildAndCheckEqualConditions(joinDesc), joinDesc.getSimplifiedNonEquiJoinConditions());
    }

    public boolean checkSCD2NonEquiJoinCondPair(List<NonEquiJoinCondition.SimplifiedJoinCondition> simplified) {
        if (CollectionUtils.isEmpty(simplified)) {
            return false;
        }
        int size = simplified.size();
        if (size % 2 != 0) {
            return false;
        }
        HashMap mapping = Maps.newHashMap();
        for (NonEquiJoinCondition.SimplifiedJoinCondition cond : simplified) {
            if (!this.checkSCD2SqlOp(cond.getOp())) {
                return false;
            }
            mapping.putIfAbsent(cond.getForeignKey(), Lists.newArrayList());
            mapping.putIfAbsent(cond.getPrimaryKey(), Lists.newArrayList());
            ((List)mapping.get(cond.getForeignKey())).add(cond.getOp());
            ((List)mapping.get(cond.getPrimaryKey())).add(SCD2CondChecker.inverse(cond.getOp()));
        }
        mapping.entrySet().removeIf(entry -> ((List)entry.getValue()).size() != 2);
        return mapping.values().stream().allMatch(this::isValidOperatorPair);
    }

    public static SqlKind inverse(SqlKind kind) {
        switch (kind) {
            case GREATER_THAN: {
                return SqlKind.LESS_THAN;
            }
            case LESS_THAN: {
                return SqlKind.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlKind.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlKind.GREATER_THAN_OR_EQUAL;
            }
        }
        return null;
    }

    private boolean isValidOperatorPair(List<SqlKind> ops) {
        if (ops.size() != 2 || ops.get(0) == ops.get(1)) {
            return false;
        }
        return SCD_2_JOIN_PAIRS.contains(Sets.newHashSet(ops));
    }

    boolean checkFkPkPairUnique(List<NonEquiJoinCondition.SimplifiedJoinCondition> equiFkPks, List<NonEquiJoinCondition.SimplifiedJoinCondition> nonEquiFkPks) {
        ArrayList<NonEquiJoinCondition.SimplifiedJoinCondition> allFkPks = new ArrayList<NonEquiJoinCondition.SimplifiedJoinCondition>();
        allFkPks.addAll(equiFkPks);
        allFkPks.addAll(nonEquiFkPks);
        HashSet<String> pairSet = new HashSet<String>();
        for (NonEquiJoinCondition.SimplifiedJoinCondition allFkPk : allFkPks) {
            Object[] joinKeys = new String[]{allFkPk.getPrimaryKey(), allFkPk.getForeignKey()};
            Arrays.sort(joinKeys);
            String key = String.join((CharSequence)",", (CharSequence[])joinKeys);
            if (pairSet.contains(key)) {
                return false;
            }
            pairSet.add(key);
        }
        return true;
    }

    private boolean checkSCD2SqlOp(SqlKind op) {
        if (Objects.isNull(op)) {
            return false;
        }
        switch (op) {
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN_OR_EQUAL: {
                return true;
            }
        }
        return false;
    }
}

