/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ExpModifier;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ParseException;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.NProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalciteParser.class);
    public static final HiveSqlDialect HIVE_SQL_DIALECT = new HiveSqlDialect(SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withNullCollation(NullCollation.LOW).withIdentifierQuoteString(Quoting.BACK_TICK.string));
    private static final String SQL_PREFIX = "select ";
    private static final String SQL_SUFFIX = " from t";
    private static final String QUOTE = Quoting.DOUBLE_QUOTE.string;
    private static final ImmutableSet<String> LATENT_NILADIC_SET = ImmutableSet.of((Object)"current_", (Object)"pi");
    private static final Cache<String, SqlNode> expCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    private CalciteParser() {
    }

    public static SqlNode parse(String sql) throws SqlParseException {
        return CalciteParser.parse(sql, null);
    }

    public static SqlNode parse(String sql, String project) throws SqlParseException {
        KylinConfig kylinConfig = StringUtils.isNotEmpty((CharSequence)project) ? NProjectManager.getProjectConfig(project) : KylinConfig.getInstanceFromEnv();
        SqlParser.ConfigBuilder parserBuilder = SqlParser.configBuilder().setIdentifierMaxLength(kylinConfig.getMaxModelDimensionMeasureNameLength());
        if (kylinConfig.getSourceNameCaseSensitiveEnabled()) {
            parserBuilder.setCaseSensitive(false).setUnquotedCasing(Casing.UNCHANGED);
        }
        try {
            SqlParser sqlParser = SqlParser.create((String)sql, (SqlParser.Config)parserBuilder.setQuoting(Quoting.DOUBLE_QUOTE).build());
            return sqlParser.parseQuery();
        }
        catch (Exception e) {
            log.info("The SqlIdentifier is not DOUBLE_QUOTE, try with BACK_TICK");
            SqlParser sqlParser = SqlParser.create((String)sql, (SqlParser.Config)parserBuilder.setQuoting(Quoting.BACK_TICK).build());
            return sqlParser.parseQuery();
        }
    }

    public static SqlNode getSelectNode(String sql) {
        try {
            String normalizedSql = CalciteParser.normalize(sql);
            return ((SqlSelect)CalciteParser.parse(normalizedSql)).getSelectList();
        }
        catch (SqlParseException e) {
            throw new IllegalStateException("Failed to parse expression '" + sql + "', please make sure the expression is valid", e);
        }
    }

    public static SqlNode getOnlySelectNode(String sql) {
        SqlNodeList selectList = (SqlNodeList)CalciteParser.getSelectNode(sql);
        Preconditions.checkArgument((selectList.size() == 1 ? 1 : 0) != 0, (Object)"Expression is invalid because size of select list exceeds one");
        return selectList.get(0);
    }

    public static SqlNode getReadonlyExpNode(String expr) {
        SqlNode sqlNode = (SqlNode)expCache.getIfPresent((Object)expr);
        if (sqlNode == null) {
            String preHandledExp = CalciteParser.normalize(expr);
            preHandledExp = StringHelper.backtickToDoubleQuote((String)preHandledExp);
            sqlNode = CalciteParser.getExpNode(preHandledExp);
            expCache.put((Object)expr, (Object)sqlNode);
        }
        return sqlNode;
    }

    private static boolean needNormalize(String expr) {
        for (String fun : LATENT_NILADIC_SET) {
            if (!StringUtils.containsIgnoreCase((CharSequence)expr, (CharSequence)fun)) continue;
            return true;
        }
        return false;
    }

    public static String normalize(String expression) {
        if (!CalciteParser.needNormalize(expression)) {
            return expression;
        }
        String transformedExp = expression;
        try {
            transformedExp = new ExpModifier(expression).transform();
        }
        catch (ParseException e) {
            log.warn("Origin expression returned for handling exception: {}", (Object)expression, (Object)e);
        }
        return transformedExp;
    }

    public static SqlNode getExpNode(String expr) {
        return CalciteParser.getOnlySelectNode(SQL_PREFIX + expr + SQL_SUFFIX);
    }

    public static String getLastNthName(SqlIdentifier id, int n) {
        return ((String)id.names.get(id.names.size() - n)).replace("\"", "").toUpperCase(Locale.ROOT);
    }

    public static String insertAliasInExpr(String expr, String alias) {
        String sql = SQL_PREFIX + expr + SQL_SUFFIX;
        SqlNode sqlNode = CalciteParser.getOnlySelectNode(sql);
        final HashSet identifiers = Sets.newHashSet();
        SqlBasicVisitor<Object> sqlVisitor = new SqlBasicVisitor<Object>(){

            public Object visit(SqlIdentifier id) {
                Preconditions.checkArgument((id.names.size() == 1 ? 1 : 0) != 0, (String)"SqlIdentifier %s contains DB/Table name", (Object)id);
                identifiers.add(id);
                return null;
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
        ArrayList sqlIdentifiers = Lists.newArrayList((Iterable)identifiers);
        CalciteParser.descSortByPosition(sqlIdentifiers);
        for (SqlIdentifier sqlIdentifier : sqlIdentifiers) {
            Pair<Integer, Integer> replacePos = CalciteParser.getReplacePos((SqlNode)sqlIdentifier, sql);
            int start = (Integer)replacePos.getFirst();
            sql = sql.substring(0, start) + alias + "." + sql.substring(start);
        }
        return sql.substring(SQL_PREFIX.length(), sql.length() - SQL_SUFFIX.length());
    }

    public static void descSortByPosition(List<? extends SqlNode> sqlNodes) {
        sqlNodes.sort((o1, o2) -> {
            int linegap = o2.getParserPosition().getLineNum() - o1.getParserPosition().getLineNum();
            if (linegap != 0) {
                return linegap;
            }
            return o2.getParserPosition().getColumnNum() - o1.getParserPosition().getColumnNum();
        });
    }

    public static Pair<Integer, Integer> getReplacePos(SqlNode node, String inputSql) {
        int i;
        if (inputSql == null) {
            return Pair.newPair((Object)0, (Object)0);
        }
        String[] lines = inputSql.split("\n");
        SqlParserPos pos = node.getParserPosition();
        int lineStart = pos.getLineNum();
        int lineEnd = pos.getEndLineNum();
        int columnStart = pos.getColumnNum() - 1;
        int columnEnd = pos.getEndColumnNum();
        for (i = 0; i < lineStart - 1; ++i) {
            columnStart += lines[i].length() + 1;
        }
        for (i = 0; i < lineEnd - 1; ++i) {
            columnEnd += lines[i].length() + 1;
        }
        return CalciteParser.getPosWithBracketsCompletion(inputSql, columnStart, columnEnd);
    }

    private static Pair<Integer, Integer> getPosWithBracketsCompletion(String inputSql, int left, int right) {
        int leftBracketNum = 0;
        int rightBracketNum = 0;
        boolean constantFlag = false;
        boolean inQuotes = false;
        String substring = inputSql.substring(left, right);
        for (int i = 0; i < substring.length(); ++i) {
            char temp = substring.charAt(i);
            if (temp == '\"' && !constantFlag) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (temp == '\'') {
                boolean bl = constantFlag = !constantFlag;
            }
            if (inQuotes || constantFlag) continue;
            if (temp == '(') {
                ++leftBracketNum;
            }
            if (temp != ')' || leftBracketNum >= ++rightBracketNum) continue;
            left = CalciteParser.moveLeft(inputSql, left);
            ++leftBracketNum;
        }
        while (rightBracketNum < leftBracketNum) {
            right = CalciteParser.moveRight(inputSql, right);
            ++rightBracketNum;
        }
        return Pair.newPair((Object)left, (Object)right);
    }

    private static int moveRight(String inputSql, int right) {
        while (')' != inputSql.charAt(right)) {
            ++right;
        }
        return ++right;
    }

    private static int moveLeft(String inputSql, int left) {
        while ('(' != inputSql.charAt(left - 1)) {
            --left;
        }
        return --left;
    }

    public static String replaceAliasInExpr(String expr, Map<String, String> renaming) {
        String sql = SQL_PREFIX + expr + SQL_SUFFIX;
        SqlNode sqlNode = CalciteParser.getOnlySelectNode(sql);
        final HashSet s = Sets.newHashSet();
        SqlBasicVisitor<Object> sqlVisitor = new SqlBasicVisitor<Object>(){

            public Object visit(SqlIdentifier id) {
                Preconditions.checkState((id.names.size() == 2 ? 1 : 0) != 0);
                s.add(id);
                return null;
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
        ArrayList sqlIdentifiers = Lists.newArrayList((Iterable)s);
        CalciteParser.descSortByPosition(sqlIdentifiers);
        for (SqlIdentifier sqlIdentifier : sqlIdentifiers) {
            Pair<Integer, Integer> replacePos = CalciteParser.getReplacePos((SqlNode)sqlIdentifier, sql);
            int start = (Integer)replacePos.getFirst();
            int end = (Integer)replacePos.getSecond();
            String aliasInExpr = (String)sqlIdentifier.names.get(0);
            String col = (String)sqlIdentifier.names.get(1);
            String renamedAlias = renaming.get(aliasInExpr);
            Preconditions.checkNotNull((Object)renamedAlias, (String)"rename for alias {} in expr ({}) is not found", (Object)aliasInExpr, (Object)expr);
            sql = sql.substring(0, start) + CalciteParser.normedIdentifier((Pair<String, String>)new Pair((Object)renamedAlias, (Object)col)) + sql.substring(end);
        }
        return sql.substring(SQL_PREFIX.length(), sql.length() - SQL_SUFFIX.length());
    }

    private static String normedIdentifier(Pair<String, String> pair) {
        return QUOTE + (String)pair.getKey() + QUOTE + "." + QUOTE + (String)pair.getValue() + QUOTE;
    }

    public static String transformDoubleQuote(String expr) throws SqlParseException {
        SqlParser.ConfigBuilder parserBuilder = SqlParser.configBuilder().setQuoting(Quoting.BACK_TICK);
        SqlParser sqlParser = SqlParser.create((String)(SQL_PREFIX + expr), (SqlParser.Config)parserBuilder.build());
        SqlSelect select = (SqlSelect)sqlParser.parseQuery();
        return ((SqlNode)select.getSelectList().getList().get(0)).toSqlString(new SqlDialect(SqlDialect.EMPTY_CONTEXT.withIdentifierQuoteString(QUOTE))).toString();
    }

    public static Set<String> getUsedAliasSet(String expr) {
        if (expr == null) {
            return Sets.newHashSet();
        }
        SqlNode sqlNode = CalciteParser.getReadonlyExpNode(expr);
        final HashSet s = Sets.newHashSet();
        SqlBasicVisitor<Object> sqlVisitor = new SqlBasicVisitor<Object>(){

            public Object visit(SqlIdentifier id) {
                Preconditions.checkState((id.names.size() == 2 ? 1 : 0) != 0);
                s.add(id.names.get(0));
                return null;
            }
        };
        sqlNode.accept((SqlVisitor)sqlVisitor);
        return s;
    }
}

