/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.UnOverWritableStrategy;
import org.apache.kylin.metadata.model.util.MultiPartitionUtil;

public class MultiplePartitionStrategy
extends UnOverWritableStrategy {
    @Override
    public List<SchemaNodeType> supportedSchemaNodeTypes() {
        return Collections.singletonList(SchemaNodeType.MODEL_MULTIPLE_PARTITION);
    }

    @Override
    public List<SchemaChangeCheckResult.UpdatedItem> updateItemFunction(SchemaUtil.SchemaDifference difference, MapDifference.ValueDifference<SchemaNode> diff, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = ((SchemaNode)diff.rightValue()).getSubject();
        boolean overwritable = this.overwritable(diff);
        if (overwritable) {
            List<String[]> duplicateValues;
            List rightPartitions = (List)((SchemaNode)diff.rightValue()).getAttributes().get("partitions");
            if (rightPartitions.isEmpty()) {
                return Collections.emptyList();
            }
            List leftPartitions = (List)((SchemaNode)diff.leftValue()).getAttributes().get("partitions");
            if (leftPartitions.size() == rightPartitions.size() && (duplicateValues = MultiPartitionUtil.findDuplicateValues(leftPartitions.stream().map(item -> item.toArray(new String[0])).collect(Collectors.toList()), rightPartitions.stream().map(item -> item.toArray(new String[0])).collect(Collectors.toList()))).size() == rightPartitions.size()) {
                return Collections.emptyList();
            }
        }
        SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels), true, true, overwritable);
        return Collections.singletonList(SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, parameter));
    }

    public boolean overwritable(MapDifference.ValueDifference<SchemaNode> diff) {
        return Objects.equals(((SchemaNode)diff.leftValue()).getAttributes().get("columns"), ((SchemaNode)diff.rightValue()).getAttributes().get("columns"));
    }
}

