/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.schema.AffectedModelContext;

public class ReloadTableContext {
    private Map<String, AffectedModelContext> removeAffectedModels = Maps.newHashMap();
    private Map<String, AffectedModelContext> changeTypeAffectedModels = Maps.newHashMap();
    private Set<String> favoriteQueries = Sets.newHashSet();
    private Set<String> changedColumns = Sets.newHashSet();
    private Set<String> addColumns = Sets.newHashSet();
    private Set<String> removeColumns = Sets.newHashSet();
    private Set<String> changeTypeColumns = Sets.newHashSet();
    private Set<String> duplicatedColumns = Sets.newHashSet();
    private Set<String> effectedJobs = Sets.newHashSet();
    private boolean isTableCommentChanged = false;
    private TableDesc tableDesc;
    private TableExtDesc tableExtDesc;
    private final AtomicReference<Object> removeColumnFullnames = new AtomicReference();

    public AffectedModelContext getRemoveAffectedModel(String project, String modelId) {
        return this.removeAffectedModels.getOrDefault(modelId, new AffectedModelContext(project, modelId, Sets.newHashSet(), true));
    }

    public AffectedModelContext getChangeTypeAffectedModel(String project, String modelId) {
        return this.changeTypeAffectedModels.getOrDefault(modelId, new AffectedModelContext(project, modelId, Sets.newHashSet(), false));
    }

    private Set<String> initRemoveColumnFullNames() {
        return this.removeColumns.stream().map(col -> {
            assert (this.tableDesc != null);
            return this.tableDesc.getName() + "." + col;
        }).collect(Collectors.toSet());
    }

    public boolean isChanged(TableDesc originTableDesc) {
        if (this.tableDesc.getColumns().length != originTableDesc.getColumns().length) {
            return true;
        }
        for (int i = 0; i < this.tableDesc.getColumns().length; ++i) {
            ColumnDesc newCol = this.tableDesc.getColumns()[i];
            ColumnDesc originCol = originTableDesc.getColumns()[i];
            if (Objects.equals(newCol.getName(), originCol.getName()) && Objects.equals(newCol.getDatatype(), originCol.getDatatype())) continue;
            return true;
        }
        return false;
    }

    public boolean isOnlyAddCols() {
        return this.removeColumns.isEmpty() && this.changedColumns.isEmpty();
    }

    public boolean isNeedProcess() {
        return CollectionUtils.isNotEmpty(this.addColumns) || CollectionUtils.isNotEmpty(this.removeColumns) || CollectionUtils.isNotEmpty(this.changedColumns) || this.isTableCommentChanged;
    }

    @Generated
    public ReloadTableContext() {
    }

    @Generated
    public Map<String, AffectedModelContext> getRemoveAffectedModels() {
        return this.removeAffectedModels;
    }

    @Generated
    public Map<String, AffectedModelContext> getChangeTypeAffectedModels() {
        return this.changeTypeAffectedModels;
    }

    @Generated
    public Set<String> getFavoriteQueries() {
        return this.favoriteQueries;
    }

    @Generated
    public Set<String> getChangedColumns() {
        return this.changedColumns;
    }

    @Generated
    public Set<String> getAddColumns() {
        return this.addColumns;
    }

    @Generated
    public Set<String> getRemoveColumns() {
        return this.removeColumns;
    }

    @Generated
    public Set<String> getChangeTypeColumns() {
        return this.changeTypeColumns;
    }

    @Generated
    public Set<String> getDuplicatedColumns() {
        return this.duplicatedColumns;
    }

    @Generated
    public Set<String> getEffectedJobs() {
        return this.effectedJobs;
    }

    @Generated
    public boolean isTableCommentChanged() {
        return this.isTableCommentChanged;
    }

    @Generated
    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    @Generated
    public TableExtDesc getTableExtDesc() {
        return this.tableExtDesc;
    }

    @Generated
    public void setRemoveAffectedModels(Map<String, AffectedModelContext> removeAffectedModels) {
        this.removeAffectedModels = removeAffectedModels;
    }

    @Generated
    public void setChangeTypeAffectedModels(Map<String, AffectedModelContext> changeTypeAffectedModels) {
        this.changeTypeAffectedModels = changeTypeAffectedModels;
    }

    @Generated
    public void setFavoriteQueries(Set<String> favoriteQueries) {
        this.favoriteQueries = favoriteQueries;
    }

    @Generated
    public void setChangedColumns(Set<String> changedColumns) {
        this.changedColumns = changedColumns;
    }

    @Generated
    public void setAddColumns(Set<String> addColumns) {
        this.addColumns = addColumns;
    }

    @Generated
    public void setRemoveColumns(Set<String> removeColumns) {
        this.removeColumns = removeColumns;
    }

    @Generated
    public void setChangeTypeColumns(Set<String> changeTypeColumns) {
        this.changeTypeColumns = changeTypeColumns;
    }

    @Generated
    public void setDuplicatedColumns(Set<String> duplicatedColumns) {
        this.duplicatedColumns = duplicatedColumns;
    }

    @Generated
    public void setEffectedJobs(Set<String> effectedJobs) {
        this.effectedJobs = effectedJobs;
    }

    @Generated
    public void setTableCommentChanged(boolean isTableCommentChanged) {
        this.isTableCommentChanged = isTableCommentChanged;
    }

    @Generated
    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Generated
    public void setTableExtDesc(TableExtDesc tableExtDesc) {
        this.tableExtDesc = tableExtDesc;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReloadTableContext)) {
            return false;
        }
        ReloadTableContext other = (ReloadTableContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, AffectedModelContext> this$removeAffectedModels = this.getRemoveAffectedModels();
        Map<String, AffectedModelContext> other$removeAffectedModels = other.getRemoveAffectedModels();
        if (this$removeAffectedModels == null ? other$removeAffectedModels != null : !((Object)this$removeAffectedModels).equals(other$removeAffectedModels)) {
            return false;
        }
        Map<String, AffectedModelContext> this$changeTypeAffectedModels = this.getChangeTypeAffectedModels();
        Map<String, AffectedModelContext> other$changeTypeAffectedModels = other.getChangeTypeAffectedModels();
        if (this$changeTypeAffectedModels == null ? other$changeTypeAffectedModels != null : !((Object)this$changeTypeAffectedModels).equals(other$changeTypeAffectedModels)) {
            return false;
        }
        Set<String> this$favoriteQueries = this.getFavoriteQueries();
        Set<String> other$favoriteQueries = other.getFavoriteQueries();
        if (this$favoriteQueries == null ? other$favoriteQueries != null : !((Object)this$favoriteQueries).equals(other$favoriteQueries)) {
            return false;
        }
        Set<String> this$changedColumns = this.getChangedColumns();
        Set<String> other$changedColumns = other.getChangedColumns();
        if (this$changedColumns == null ? other$changedColumns != null : !((Object)this$changedColumns).equals(other$changedColumns)) {
            return false;
        }
        Set<String> this$addColumns = this.getAddColumns();
        Set<String> other$addColumns = other.getAddColumns();
        if (this$addColumns == null ? other$addColumns != null : !((Object)this$addColumns).equals(other$addColumns)) {
            return false;
        }
        Set<String> this$removeColumns = this.getRemoveColumns();
        Set<String> other$removeColumns = other.getRemoveColumns();
        if (this$removeColumns == null ? other$removeColumns != null : !((Object)this$removeColumns).equals(other$removeColumns)) {
            return false;
        }
        Set<String> this$changeTypeColumns = this.getChangeTypeColumns();
        Set<String> other$changeTypeColumns = other.getChangeTypeColumns();
        if (this$changeTypeColumns == null ? other$changeTypeColumns != null : !((Object)this$changeTypeColumns).equals(other$changeTypeColumns)) {
            return false;
        }
        Set<String> this$duplicatedColumns = this.getDuplicatedColumns();
        Set<String> other$duplicatedColumns = other.getDuplicatedColumns();
        if (this$duplicatedColumns == null ? other$duplicatedColumns != null : !((Object)this$duplicatedColumns).equals(other$duplicatedColumns)) {
            return false;
        }
        Set<String> this$effectedJobs = this.getEffectedJobs();
        Set<String> other$effectedJobs = other.getEffectedJobs();
        if (this$effectedJobs == null ? other$effectedJobs != null : !((Object)this$effectedJobs).equals(other$effectedJobs)) {
            return false;
        }
        if (this.isTableCommentChanged() != other.isTableCommentChanged()) {
            return false;
        }
        TableDesc this$tableDesc = this.getTableDesc();
        TableDesc other$tableDesc = other.getTableDesc();
        if (this$tableDesc == null ? other$tableDesc != null : !((Object)this$tableDesc).equals(other$tableDesc)) {
            return false;
        }
        TableExtDesc this$tableExtDesc = this.getTableExtDesc();
        TableExtDesc other$tableExtDesc = other.getTableExtDesc();
        if (this$tableExtDesc == null ? other$tableExtDesc != null : !((Object)this$tableExtDesc).equals(other$tableExtDesc)) {
            return false;
        }
        Set<String> this$removeColumnFullnames = this.getRemoveColumnFullnames();
        Set<String> other$removeColumnFullnames = other.getRemoveColumnFullnames();
        return !(this$removeColumnFullnames == null ? other$removeColumnFullnames != null : !((Object)this$removeColumnFullnames).equals(other$removeColumnFullnames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReloadTableContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, AffectedModelContext> $removeAffectedModels = this.getRemoveAffectedModels();
        result = result * 59 + ($removeAffectedModels == null ? 43 : ((Object)$removeAffectedModels).hashCode());
        Map<String, AffectedModelContext> $changeTypeAffectedModels = this.getChangeTypeAffectedModels();
        result = result * 59 + ($changeTypeAffectedModels == null ? 43 : ((Object)$changeTypeAffectedModels).hashCode());
        Set<String> $favoriteQueries = this.getFavoriteQueries();
        result = result * 59 + ($favoriteQueries == null ? 43 : ((Object)$favoriteQueries).hashCode());
        Set<String> $changedColumns = this.getChangedColumns();
        result = result * 59 + ($changedColumns == null ? 43 : ((Object)$changedColumns).hashCode());
        Set<String> $addColumns = this.getAddColumns();
        result = result * 59 + ($addColumns == null ? 43 : ((Object)$addColumns).hashCode());
        Set<String> $removeColumns = this.getRemoveColumns();
        result = result * 59 + ($removeColumns == null ? 43 : ((Object)$removeColumns).hashCode());
        Set<String> $changeTypeColumns = this.getChangeTypeColumns();
        result = result * 59 + ($changeTypeColumns == null ? 43 : ((Object)$changeTypeColumns).hashCode());
        Set<String> $duplicatedColumns = this.getDuplicatedColumns();
        result = result * 59 + ($duplicatedColumns == null ? 43 : ((Object)$duplicatedColumns).hashCode());
        Set<String> $effectedJobs = this.getEffectedJobs();
        result = result * 59 + ($effectedJobs == null ? 43 : ((Object)$effectedJobs).hashCode());
        result = result * 59 + (this.isTableCommentChanged() ? 79 : 97);
        TableDesc $tableDesc = this.getTableDesc();
        result = result * 59 + ($tableDesc == null ? 43 : ((Object)$tableDesc).hashCode());
        TableExtDesc $tableExtDesc = this.getTableExtDesc();
        result = result * 59 + ($tableExtDesc == null ? 43 : ((Object)$tableExtDesc).hashCode());
        Set<String> $removeColumnFullnames = this.getRemoveColumnFullnames();
        result = result * 59 + ($removeColumnFullnames == null ? 43 : ((Object)$removeColumnFullnames).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReloadTableContext(removeAffectedModels=" + this.getRemoveAffectedModels() + ", changeTypeAffectedModels=" + this.getChangeTypeAffectedModels() + ", favoriteQueries=" + this.getFavoriteQueries() + ", changedColumns=" + this.getChangedColumns() + ", addColumns=" + this.getAddColumns() + ", removeColumns=" + this.getRemoveColumns() + ", changeTypeColumns=" + this.getChangeTypeColumns() + ", duplicatedColumns=" + this.getDuplicatedColumns() + ", effectedJobs=" + this.getEffectedJobs() + ", isTableCommentChanged=" + this.isTableCommentChanged() + ", tableDesc=" + this.getTableDesc() + ", tableExtDesc=" + this.getTableExtDesc() + ", removeColumnFullnames=" + this.getRemoveColumnFullnames() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Set<String> getRemoveColumnFullnames() {
        Object value = this.removeColumnFullnames.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.removeColumnFullnames;
            synchronized (atomicReference) {
                value = this.removeColumnFullnames.get();
                if (value == null) {
                    Set<String> actualValue = this.initRemoveColumnFullNames();
                    value = actualValue == null ? this.removeColumnFullnames : actualValue;
                    this.removeColumnFullnames.set(value);
                }
            }
        }
        return (Set)(value == this.removeColumnFullnames ? null : value);
    }
}

