/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.JobErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PartitionDesc
implements Serializable {
    private static final String SPACE_AND_SPACE = " AND ";
    @JsonProperty(value="partition_date_column")
    private String partitionDateColumn;
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_format")
    private String partitionDateFormat;
    @JsonProperty(value="partition_type")
    private PartitionType partitionType = PartitionType.APPEND;
    @JsonProperty(value="partition_condition_builder")
    private String partitionConditionBuilderClz = DefaultPartitionConditionBuilder.class.getName();
    private TblColRef partitionDateColumnRef;
    private IPartitionConditionBuilder partitionConditionBuilder;

    public void init(NDataModel model) {
        if (!StringUtils.isEmpty((CharSequence)this.partitionDateColumn)) {
            this.partitionDateColumnRef = model.findColumn(this.partitionDateColumn);
            this.partitionDateColumn = this.partitionDateColumnRef.getIdentity();
        }
        if (!StringUtils.isEmpty((CharSequence)this.partitionConditionBuilderClz)) {
            this.partitionConditionBuilder = (IPartitionConditionBuilder)ClassUtil.newInstance((String)this.partitionConditionBuilderClz);
        }
    }

    public boolean partitionColumnIsYmdInt() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return (type.isInt() || type.isBigInt()) && DateFormat.isDatePattern((String)this.partitionDateFormat);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.partitionDateColumn);
    }

    public boolean checkIntTypeDateFormat() {
        DataType type = this.partitionDateColumnRef.getType();
        if (type.isInt() || type.isBigInt()) {
            return "yyyyMM".equals(this.partitionDateFormat) || "yyyyMMdd".equals(this.partitionDateFormat);
        }
        return true;
    }

    public boolean partitionColumnIsTimeMillis() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return type.isBigInt() && !DateFormat.isDatePattern((String)this.partitionDateFormat);
    }

    public boolean partitionColumnIsTimestamp() {
        return this.getTimestampType() != null;
    }

    public TimestampType getTimestampType() {
        for (TimestampType timestampType : TimestampType.values()) {
            if (!timestampType.name.equals(this.partitionDateFormat)) continue;
            return timestampType;
        }
        return null;
    }

    public boolean partitionColumnIsDate() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return type.isDate() && DateFormat.isDatePattern((String)this.partitionDateFormat);
    }

    public boolean isPartitioned() {
        return this.partitionDateColumnRef != null;
    }

    public String getPartitionDateColumn() {
        return this.partitionDateColumn;
    }

    public String getBackTickPartitionDateColumn() {
        return this.partitionDateColumnRef.getBackTickIdentity();
    }

    public void setPartitionDateColumn(String partitionDateColumn) {
        this.partitionDateColumn = partitionDateColumn;
    }

    public void setPartitionDateColumnRef(TblColRef partitionDateColumnRef) {
        this.partitionDateColumnRef = partitionDateColumnRef;
    }

    @Deprecated
    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    @Deprecated
    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public String getPartitionDateFormat() {
        return this.partitionDateFormat;
    }

    public void setPartitionDateFormat(String partitionDateFormat) {
        this.partitionDateFormat = partitionDateFormat;
    }

    public PartitionType getCubePartitionType() {
        return this.partitionType;
    }

    public void setCubePartitionType(PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public String getPartitionConditionBuilderClz() {
        return this.partitionConditionBuilderClz;
    }

    public void setPartitionConditionBuilderClz(String partitionConditionBuilderClz) {
        this.partitionConditionBuilderClz = partitionConditionBuilderClz;
    }

    public IPartitionConditionBuilder getPartitionConditionBuilder() {
        return this.partitionConditionBuilder;
    }

    public TblColRef getPartitionDateColumnRef() {
        return this.partitionDateColumnRef;
    }

    public void changeTableAlias(String oldAlias, String newAlias) {
        String table = this.partitionDateColumn.split("\\.")[0];
        String column = this.partitionDateColumn.split("\\.")[1];
        if (table.equalsIgnoreCase(oldAlias)) {
            this.partitionDateColumn = newAlias + "." + column;
        }
    }

    public static boolean isEmptyPartitionDesc(PartitionDesc partitionDesc) {
        return partitionDesc == null || partitionDesc.isEmpty();
    }

    public static PartitionDesc getCopyOf(PartitionDesc orig) {
        PartitionDesc ret = new PartitionDesc();
        ret.partitionDateColumn = orig.partitionDateColumn;
        ret.partitionDateStart = orig.partitionDateStart;
        ret.partitionDateFormat = orig.partitionDateFormat;
        ret.partitionType = orig.partitionType;
        ret.partitionConditionBuilderClz = orig.partitionConditionBuilderClz;
        ret.partitionConditionBuilder = orig.partitionConditionBuilder;
        return ret;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionDesc)) {
            return false;
        }
        PartitionDesc other = (PartitionDesc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$partitionDateColumn = this.getPartitionDateColumn();
        String other$partitionDateColumn = other.getPartitionDateColumn();
        if (this$partitionDateColumn == null ? other$partitionDateColumn != null : !this$partitionDateColumn.equals(other$partitionDateColumn)) {
            return false;
        }
        if (this.getPartitionDateStart() != other.getPartitionDateStart()) {
            return false;
        }
        String this$partitionDateFormat = this.getPartitionDateFormat();
        String other$partitionDateFormat = other.getPartitionDateFormat();
        if (this$partitionDateFormat == null ? other$partitionDateFormat != null : !this$partitionDateFormat.equals(other$partitionDateFormat)) {
            return false;
        }
        PartitionType this$partitionType = this.partitionType;
        PartitionType other$partitionType = other.partitionType;
        if (this$partitionType == null ? other$partitionType != null : !this$partitionType.equals(other$partitionType)) {
            return false;
        }
        String this$partitionConditionBuilderClz = this.getPartitionConditionBuilderClz();
        String other$partitionConditionBuilderClz = other.getPartitionConditionBuilderClz();
        return !(this$partitionConditionBuilderClz == null ? other$partitionConditionBuilderClz != null : !this$partitionConditionBuilderClz.equals(other$partitionConditionBuilderClz));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartitionDesc;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $partitionDateColumn = this.getPartitionDateColumn();
        result = result * 59 + ($partitionDateColumn == null ? 43 : $partitionDateColumn.hashCode());
        long $partitionDateStart = this.getPartitionDateStart();
        result = result * 59 + (int)($partitionDateStart >>> 32 ^ $partitionDateStart);
        String $partitionDateFormat = this.getPartitionDateFormat();
        result = result * 59 + ($partitionDateFormat == null ? 43 : $partitionDateFormat.hashCode());
        PartitionType $partitionType = this.partitionType;
        result = result * 59 + ($partitionType == null ? 43 : $partitionType.hashCode());
        String $partitionConditionBuilderClz = this.getPartitionConditionBuilderClz();
        result = result * 59 + ($partitionConditionBuilderClz == null ? 43 : $partitionConditionBuilderClz.hashCode());
        return result;
    }

    public static class DefaultPartitionConditionBuilder
    implements IPartitionConditionBuilder,
    Serializable {
        boolean useBigintAsTimestamp = KylinConfig.getInstanceFromEnv().isUseBigIntAsTimestampForPartitionColumn();

        public void setUseBigintAsTimestamp(boolean useBigintAsTimestamp) {
            this.useBigintAsTimestamp = useBigintAsTimestamp;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange) {
            Preconditions.checkState((boolean)(segRange instanceof SegmentRange.TimePartitionedSegmentRange));
            SegmentRange.TimePartitionedSegmentRange tsr = (SegmentRange.TimePartitionedSegmentRange)segRange;
            long startInclusive = tsr.getStart();
            long endExclusive = tsr.getEnd();
            TblColRef partitionDateColumn = partDesc.getPartitionDateColumnRef();
            StringBuilder builder = new StringBuilder();
            boolean dataTypeIsIntOrBigInt = false;
            if (partDesc.partitionDateColumnRef != null) {
                DataType type = partDesc.partitionDateColumnRef.getType();
                boolean bl = dataTypeIsIntOrBigInt = type.isInt() || type.isBigInt();
            }
            if (partDesc.partitionColumnIsTimestamp()) {
                TimestampType timestampType = partDesc.getTimestampType();
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsTimestamp(builder, partitionDateColumn, startInclusive /= timestampType.millisecondRatio, endExclusive /= timestampType.millisecondRatio);
                return builder.toString();
            } else if (partDesc.partitionColumnIsDate()) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsDate(builder, partitionDateColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat());
                return builder.toString();
            } else if (dataTypeIsIntOrBigInt) {
                if (!this.useBigintAsTimestamp) {
                    if ("yyyyMM".equals(partDesc.partitionDateFormat)) {
                        DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsYmInt(builder, partitionDateColumn, startInclusive, endExclusive);
                        return builder.toString();
                    } else {
                        if (!"yyyyMMdd".equals(partDesc.partitionDateFormat)) throw new KylinException((ErrorCodeSupplier)JobErrorCode.JOB_INT_DATE_FORMAT_NOT_MATCH_ERROR, "int/bigint data type only support yyyymm/yyyymmdd format");
                        DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsYmdInt(builder, partitionDateColumn, startInclusive, endExclusive);
                    }
                    return builder.toString();
                } else if (partDesc.partitionColumnIsYmdInt()) {
                    DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsYmdInt(builder, partitionDateColumn, startInclusive, endExclusive);
                    return builder.toString();
                } else {
                    if (!partDesc.partitionColumnIsTimeMillis()) return builder.toString();
                    DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsTimestamp(builder, partitionDateColumn, startInclusive, endExclusive);
                }
                return builder.toString();
            } else {
                if (partitionDateColumn == null) return builder.toString();
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionDateColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat());
            }
            return builder.toString();
        }

        @Override
        public String buildMultiPartitionCondition(PartitionDesc partDesc, MultiPartitionDesc multiPartDesc, LinkedList<Long> partitionIds, ISegment seg, SegmentRange segRange) {
            return "";
        }

        private static void buildSingleColumnRangeCondAsDate(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat) {
            String partitionColumnName = partitionColumn.getBackTickExp();
            builder.append(partitionColumnName).append(" >= ").append(String.format(Locale.ROOT, "to_date('%s', '%s')", DateFormat.formatToDateStr((long)startInclusive, (String)partitionColumnDateFormat), partitionColumnDateFormat));
            builder.append(PartitionDesc.SPACE_AND_SPACE);
            builder.append(partitionColumnName).append(" < ").append(String.format(Locale.ROOT, "to_date('%s', '%s')", DateFormat.formatToDateStr((long)endExclusive, (String)partitionColumnDateFormat), partitionColumnDateFormat));
        }

        private static void buildSingleColumnRangeCondAsTimestamp(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive) {
            String partitionColumnName = partitionColumn.getBackTickExp();
            builder.append(partitionColumnName).append(" >= ").append(startInclusive);
            builder.append(PartitionDesc.SPACE_AND_SPACE);
            builder.append(partitionColumnName).append(" < ").append(endExclusive);
        }

        private static void buildSingleColumnRangeCondAsYmInt(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive) {
            String partitionColumnName = partitionColumn.getBackTickExp();
            builder.append(partitionColumnName).append(" >= ").append(DateFormat.formatToDateStr((long)startInclusive, (String)"yyyyMM"));
            builder.append(PartitionDesc.SPACE_AND_SPACE);
            builder.append(partitionColumnName).append(" < ").append(DateFormat.formatToDateStr((long)endExclusive, (String)"yyyyMM"));
        }

        private static void buildSingleColumnRangeCondAsYmdInt(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive) {
            String partitionColumnName = partitionColumn.getBackTickExp();
            builder.append(partitionColumnName).append(" >= ").append(DateFormat.formatToDateStr((long)startInclusive, (String)"yyyyMMdd"));
            builder.append(PartitionDesc.SPACE_AND_SPACE);
            builder.append(partitionColumnName).append(" < ").append(DateFormat.formatToDateStr((long)endExclusive, (String)"yyyyMMdd"));
        }

        private static void buildSingleColumnRangeCondition(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat) {
            String endInc;
            String startInc;
            String partitionColumnName = partitionColumn.getBackTickExp();
            if (endExclusive <= startInclusive) {
                builder.append("1=1");
                return;
            }
            if (StringUtils.isBlank((CharSequence)partitionColumnDateFormat)) {
                startInc = String.valueOf(startInclusive);
                endInc = String.valueOf(endExclusive);
            } else {
                startInc = DateFormat.formatToDateStr((long)startInclusive, (String)partitionColumnDateFormat);
                endInc = DateFormat.formatToDateStr((long)endExclusive, (String)partitionColumnDateFormat);
            }
            builder.append(partitionColumnName).append(" >= '").append(startInc).append("'");
            builder.append(PartitionDesc.SPACE_AND_SPACE);
            builder.append(partitionColumnName).append(" < '").append(endInc).append("'");
        }
    }

    public static interface IPartitionConditionBuilder {
        public String buildDateRangeCondition(PartitionDesc var1, ISegment var2, SegmentRange var3);

        public String buildMultiPartitionCondition(PartitionDesc var1, MultiPartitionDesc var2, LinkedList<Long> var3, ISegment var4, SegmentRange var5);
    }

    public static enum TimestampType implements Serializable
    {
        MILLISECOND("TIMESTAMP MILLISECOND", 1L, "yyyy-MM-dd HH:mm:ss.SSS"),
        SECOND("TIMESTAMP SECOND", 1000L, "yyyy-MM-dd HH:mm:ss");

        public final String name;
        public final long millisecondRatio;
        public final String format;

        private TimestampType(String name, long millisecondRatio, String format) {
            this.name = name;
            this.millisecondRatio = millisecondRatio;
            this.format = format;
        }
    }

    public static enum PartitionType implements Serializable
    {
        FILE,
        APPEND,
        UPDATE_INSERT;

    }
}

