/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.MultiPartitionKeyMapping;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class MultiPartitionKeyMappingImpl
extends MultiPartitionKeyMapping {
    private transient List<TblColRef> aliasColumnRefs;
    private transient ImmutableMultimap<List<String>, List<String>> immutableValueMapping;

    public MultiPartitionKeyMappingImpl(List<String> multiPartitionCols, List<String> aliasCols, List<Pair<List<String>, List<String>>> valueMapping) {
        this.setAliasCols(aliasCols);
        this.setMultiPartitionCols(multiPartitionCols);
        this.setValueMapping(valueMapping);
    }

    public void init(NDataModel model) {
        if (CollectionUtils.isEmpty(this.getAliasCols()) || CollectionUtils.isEmpty(this.getMultiPartitionCols())) {
            return;
        }
        this.aliasColumnRefs = Lists.newArrayList();
        for (String columnName : this.getAliasCols()) {
            this.aliasColumnRefs.add(model.findColumn(columnName));
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.getValueMapping().forEach(pair -> {
            List partitionValue = (List)pair.getFirst();
            List aliasValue = (List)pair.getSecond();
            builder.put((Object)partitionValue, (Object)aliasValue);
        });
        this.immutableValueMapping = builder.build();
    }

    @Override
    public List<TblColRef> getAliasColumns() {
        return this.aliasColumnRefs;
    }

    @Override
    public Collection<List<String>> getAliasValue(List<String> partitionValues) {
        return this.immutableValueMapping.get(partitionValues);
    }

    @Generated
    public List<TblColRef> getAliasColumnRefs() {
        return this.aliasColumnRefs;
    }

    @Generated
    public ImmutableMultimap<List<String>, List<String>> getImmutableValueMapping() {
        return this.immutableValueMapping;
    }

    @Generated
    public MultiPartitionKeyMappingImpl() {
    }
}

