/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.jar;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.jar.JarTypeEnum;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JarInfo
extends RootPersistentEntity
implements Serializable {
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="jar_name")
    private String jarName;
    @JsonProperty(value="jar_path")
    private String jarPath;
    @JsonProperty(value="jar_type")
    private JarTypeEnum jarType;

    public JarInfo() {
    }

    public JarInfo(String project, String jarName, String jarPath, JarTypeEnum jarType) {
        this.project = project;
        this.jarName = jarName;
        this.jarPath = jarPath;
        this.jarType = jarType;
    }

    public String resourceName() {
        if (this.jarType == null || this.jarName == null) {
            return null;
        }
        return JarInfo.concatResourceName(this.project, this.jarType, this.jarName);
    }

    public MetadataType resourceType() {
        return MetadataType.JAR_INFO;
    }

    public static String concatResourceName(String project, JarTypeEnum jarType, String jarName) {
        return String.format(Locale.ROOT, "%s.%s_%s", new Object[]{project, jarType, jarName});
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getJarName() {
        return this.jarName;
    }

    @Generated
    public String getJarPath() {
        return this.jarPath;
    }

    @Generated
    public JarTypeEnum getJarType() {
        return this.jarType;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    @Generated
    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    @Generated
    public void setJarType(JarTypeEnum jarType) {
        this.jarType = jarType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JarInfo)) {
            return false;
        }
        JarInfo other = (JarInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$jarName = this.getJarName();
        String other$jarName = other.getJarName();
        if (this$jarName == null ? other$jarName != null : !this$jarName.equals(other$jarName)) {
            return false;
        }
        String this$jarPath = this.getJarPath();
        String other$jarPath = other.getJarPath();
        if (this$jarPath == null ? other$jarPath != null : !this$jarPath.equals(other$jarPath)) {
            return false;
        }
        JarTypeEnum this$jarType = this.getJarType();
        JarTypeEnum other$jarType = other.getJarType();
        return !(this$jarType == null ? other$jarType != null : !((Object)((Object)this$jarType)).equals((Object)other$jarType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JarInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $jarName = this.getJarName();
        result = result * 59 + ($jarName == null ? 43 : $jarName.hashCode());
        String $jarPath = this.getJarPath();
        result = result * 59 + ($jarPath == null ? 43 : $jarPath.hashCode());
        JarTypeEnum $jarType = this.getJarType();
        result = result * 59 + ($jarType == null ? 43 : ((Object)((Object)$jarType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JarInfo(project=" + this.getProject() + ", jarName=" + this.getJarName() + ", jarPath=" + this.getJarPath() + ", jarType=" + (Object)((Object)this.getJarType()) + ")";
    }
}

