/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.SerializationException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;

public class AsyncTaskTable
extends SqlTable {
    public final SqlColumn<Integer> id = this.column("id", JDBCType.INTEGER);
    public final SqlColumn<String> project = this.column("project", JDBCType.VARCHAR);
    public final SqlColumn<AbstractAsyncTask.TaskAttributes> taskAttributes = this.column("task_attributes", JDBCType.VARCHAR, TaskHandler.class.getName());
    public final SqlColumn<String> taskType = this.column("task_type", JDBCType.VARCHAR);
    public final SqlColumn<String> taskKey = this.column("task_key", JDBCType.VARCHAR);
    public final SqlColumn<Long> updateTime = this.column("update_time", JDBCType.BIGINT);
    public final SqlColumn<Long> createTime = this.column("create_time", JDBCType.BIGINT);
    public final SqlColumn<Long> mvcc = this.column("mvcc", JDBCType.BIGINT);

    protected AsyncTaskTable(String tableName) {
        super(tableName);
    }

    public static class TaskHandler
    implements TypeHandler<AbstractAsyncTask.TaskAttributes> {
        public void setParameter(PreparedStatement ps, int i, AbstractAsyncTask.TaskAttributes parameter, JdbcType jdbcType) throws SQLException {
            Preconditions.checkArgument((parameter != null ? 1 : 0) != 0, (Object)"task attributes cannot be null");
            try {
                ps.setString(i, JsonUtil.writeValueAsString((Object)parameter));
            }
            catch (JsonProcessingException e) {
                throw new SerializationException("cannot serialize task attributes", (Throwable)e);
            }
        }

        public AbstractAsyncTask.TaskAttributes getResult(ResultSet rs, String columnName) throws SQLException {
            return this.toTaskAttributes(rs.getString(columnName));
        }

        public AbstractAsyncTask.TaskAttributes getResult(ResultSet rs, int columnIndex) throws SQLException {
            return this.toTaskAttributes(rs.getString(columnIndex));
        }

        public AbstractAsyncTask.TaskAttributes getResult(CallableStatement cs, int columnIndex) throws SQLException {
            return this.toTaskAttributes(cs.getString(columnIndex));
        }

        AbstractAsyncTask.TaskAttributes toTaskAttributes(String jsonString) {
            try {
                return (AbstractAsyncTask.TaskAttributes)JsonUtil.readValue((String)jsonString, AbstractAsyncTask.TaskAttributes.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot deserialize task correctly", e);
            }
        }
    }
}

