/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class LongSerializer
extends DataTypeSerializer<Long> {
    public LongSerializer(DataType type) {
    }

    public void serialize(Long value, ByteBuffer out) {
        BytesUtil.writeVLong((long)value, (ByteBuffer)out);
    }

    public Long deserialize(ByteBuffer in) {
        return BytesUtil.readVLong((ByteBuffer)in);
    }

    @Override
    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        BytesUtil.readVLong((ByteBuffer)in);
        int len = in.position() - mark;
        in.position(mark);
        return len;
    }

    @Override
    public int maxLength() {
        return 9;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 5;
    }

    @Override
    public Long valueOf(String str) {
        return Long.parseLong(str);
    }
}

