/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.TblColRef;

public class DataType
implements Serializable {
    private static final LinkedHashSet<String> VALID_TYPES = new LinkedHashSet();
    private static final LinkedHashSet<String> COMPLEX_TYPES = new LinkedHashSet();
    private static Pattern TYPE_PATTERN = null;
    private static Pattern COMPLEX_TYPE_PATTERN = null;
    private static final String TYPE_PATTEN_TAIL = "\\s*(?:[(]([\\d\\s,]+)[)])?";
    public static final String VARCHAR = "varchar";
    public static final String CHAR = "char";
    public static final String INTEGER = "integer";
    public static final String TINY_INT = "tinyint";
    public static final String SMALL_INT = "smallint";
    public static final String BIGINT = "bigint";
    public static final String FLOAT = "float";
    public static final String DECIMAL = "decimal";
    public static final String DOUBLE = "double";
    public static final String NUMERIC = "numeric";
    public static final String TIMESTAMP = "timestamp";
    public static final String DATETIME = "datetime";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String REAL = "real";
    public static final String ANY_STR = "any";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String BYTE = "byte";
    public static final String BINARY = "binary";
    public static final String INT = "int";
    public static final String SHORT = "short";
    public static final String LONG = "long";
    public static final String INT4 = "int4";
    public static final String LONG8 = "long8";
    public static final String ARRAY = "array";
    public static final Set<String> INTEGER_FAMILY;
    public static final Set<String> NUMBER_FAMILY;
    public static final Set<String> DATETIME_FAMILY;
    public static final Set<String> STRING_FAMILY;
    public static final Set<String> BOOLEAN_FAMILY;
    private static final Map<String, String> LEGACY_TYPE_MAP;
    private static final ConcurrentMap<DataType, DataType> CACHE;
    public static final DataType ANY;
    public static final int DECIMAL_MAX_PRECISION = 38;
    public static final int DECIMAL_MAX_SCALE = 38;
    private String name;
    private int precision;
    private int scale;
    public static final BytesSerializer<DataType> serializer;

    public static synchronized void register(String ... typeNames) {
        VALID_TYPES.addAll(Arrays.asList(typeNames));
        TYPE_PATTERN = Pattern.compile("(" + StringUtils.join(VALID_TYPES, (String)"|") + ")" + TYPE_PATTEN_TAIL, 2);
    }

    public static synchronized void registerComplex(String ... typeNames) {
        COMPLEX_TYPES.addAll(Arrays.asList(typeNames));
        COMPLEX_TYPE_PATTERN = Pattern.compile("(" + StringUtils.join(COMPLEX_TYPES, (String)"|") + ")" + TYPE_PATTEN_TAIL, 2);
    }

    public static boolean isComplexType(DataType type) {
        Matcher m = COMPLEX_TYPE_PATTERN.matcher(type.getName());
        return m.matches();
    }

    public static DataType getType(String type) {
        if (type == null) {
            return null;
        }
        DataType dataType = new DataType(type);
        DataType cached = (DataType)CACHE.get(dataType);
        if (cached == null) {
            CACHE.put(dataType, dataType);
            cached = dataType;
        }
        return cached;
    }

    public DataType(String name, int precision, int scale) {
        this.name = name;
        this.precision = precision;
        this.scale = scale;
    }

    private DataType(String datatype) {
        datatype = datatype.trim().toLowerCase(Locale.ROOT);
        datatype = this.replaceLegacy(datatype);
        Pattern pattern = TYPE_PATTERN;
        Pattern complexPattern = COMPLEX_TYPE_PATTERN;
        Matcher m = pattern.matcher(datatype);
        Matcher m2 = complexPattern.matcher(datatype);
        if (!m.matches() && !m2.matches()) {
            throw this.newBadDataTypeError(datatype, "does not match " + pattern);
        }
        if (m2.matches()) {
            m = m2;
        }
        this.name = this.replaceLegacy(m.group(1));
        this.precision = -1;
        this.scale = -1;
        String leftover = m.group(2);
        if (leftover != null) {
            String[] parts = leftover.split("\\s*,\\s*");
            for (int i = 0; i < parts.length; ++i) {
                int n;
                try {
                    n = Integer.parseInt(parts[i]);
                }
                catch (NumberFormatException e) {
                    throw this.newBadDataTypeError(datatype, "precision/scale not numeric");
                }
                if (i == 0) {
                    this.precision = n;
                    continue;
                }
                if (i == 1) {
                    this.scale = n;
                    continue;
                }
                throw this.newBadDataTypeError(datatype, "too many precision/scale parts");
            }
        }
        if (this.precision == -1) {
            if (this.name.equals(CHAR)) {
                this.precision = KylinConfig.getInstanceFromEnv().getDefaultCharPrecision();
            } else if (this.name.equals(VARCHAR)) {
                this.precision = KylinConfig.getInstanceFromEnv().getDefaultVarcharPrecision();
            } else if (this.name.equals(DECIMAL) || this.name.equals(NUMERIC)) {
                this.precision = KylinConfig.getInstanceFromEnv().getDefaultDecimalPrecision();
                this.scale = KylinConfig.getInstanceFromEnv().getDefaultDecimalScale();
            }
        }
    }

    public int compare(String value1, String value2) {
        if (this.isDateTimeFamily()) {
            Long millis1 = DateFormat.stringToMillis((String)value1);
            Long millis2 = DateFormat.stringToMillis((String)value2);
            return millis1.compareTo(millis2);
        }
        if (this.isIntegerFamily()) {
            Long l1 = new Long(value1);
            Long l2 = new Long(value2);
            return l1.compareTo(l2);
        }
        if (this.isNumberFamily()) {
            BigDecimal bigDecimal1 = new BigDecimal(value1);
            BigDecimal bigDecimal2 = new BigDecimal(value2);
            return bigDecimal1.compareTo(bigDecimal2);
        }
        return value1.compareTo(value2);
    }

    public Object parseValue(String value) {
        if (this.isDateTimeFamily()) {
            return DateFormat.stringToMillis((String)value);
        }
        if (this.isIntegerFamily()) {
            return Long.parseLong(value);
        }
        if (this.isNumberFamily()) {
            return new BigDecimal(value);
        }
        if (this.isBoolean()) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    private String replaceLegacy(String str) {
        String replace = LEGACY_TYPE_MAP.get(str);
        return replace == null ? str : replace;
    }

    public int getStorageBytesEstimate() {
        return DataTypeSerializer.create(this).getStorageBytesEstimate();
    }

    public double getStorageBytesEstimate(double count) {
        return DataTypeSerializer.create(this).getStorageBytesEstimate(count);
    }

    public boolean isLegalPartitionColumnType() {
        return this.isStringFamily() || this.isDateTimeFamily() || this.isIntegerFamily();
    }

    public boolean isStringFamily() {
        return STRING_FAMILY.contains(this.name);
    }

    public boolean isIntegerFamily() {
        return INTEGER_FAMILY.contains(this.name);
    }

    public boolean isNumberFamily() {
        return NUMBER_FAMILY.contains(this.name);
    }

    public boolean isDateTimeFamily() {
        return DATETIME_FAMILY.contains(this.name);
    }

    public boolean isTimeFamily() {
        return DATETIME_FAMILY.contains(this.name) && !this.isDate();
    }

    public boolean isDate() {
        return this.name.equals(DATE);
    }

    public boolean isTime() {
        return this.name.equals(TIME);
    }

    public boolean isTimestamp() {
        return this.name.equals(TIMESTAMP);
    }

    public boolean isDatetime() {
        return this.name.equals(DATETIME);
    }

    public boolean isTinyInt() {
        return this.name.equals(TINY_INT);
    }

    public boolean isSmallInt() {
        return this.name.equals(SMALL_INT);
    }

    public boolean isInt() {
        return this.name.equals(INTEGER);
    }

    public boolean isBigInt() {
        return this.name.equals(BIGINT);
    }

    public boolean isFloat() {
        return this.name.equals(FLOAT);
    }

    public boolean isDouble() {
        return this.name.equals(DOUBLE);
    }

    public boolean isDecimal() {
        return this.name.equals(DECIMAL);
    }

    public boolean isBoolean() {
        return this.name.equals(BOOLEAN);
    }

    public String getName() {
        return this.name;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.precision != other.precision) {
            return false;
        }
        return this.scale == other.scale;
    }

    public String toString() {
        if (this.precision < 0 && this.scale < 0) {
            return this.name;
        }
        if (this.scale < 0) {
            return this.name + "(" + this.precision + ")";
        }
        return this.name + "(" + this.precision + "," + this.scale + ")";
    }

    public static int decimalBoundedPrecision(int precision) {
        return Math.min(precision, 38);
    }

    public static int decimalBoundedScale(int scale) {
        return Math.min(scale, 38);
    }

    private IllegalArgumentException newBadDataTypeError(String datatype, String reason) {
        return new IllegalArgumentException("bad data type -- " + datatype + ", " + reason);
    }

    static {
        DataType.register(ANY_STR, CHAR, VARCHAR, STRING, BOOLEAN, BYTE, BINARY, INT, SHORT, LONG, INTEGER, TINY_INT, SMALL_INT, BIGINT, INT4, LONG8, FLOAT, REAL, DOUBLE, DECIMAL, NUMERIC, DATE, TIME, DATETIME, TIMESTAMP, ARRAY, TblColRef.InnerDataTypeEnum.LITERAL.getDataType(), TblColRef.InnerDataTypeEnum.DERIVED.getDataType(), TblColRef.InnerDataTypeEnum.AGGREGATION_TYPE.getDataType(), "_dynamic_type");
        DataType.registerComplex("array\\<.*\\>");
        INTEGER_FAMILY = new HashSet<String>();
        NUMBER_FAMILY = new HashSet<String>();
        DATETIME_FAMILY = new HashSet<String>();
        STRING_FAMILY = new HashSet<String>();
        BOOLEAN_FAMILY = new HashSet<String>();
        LEGACY_TYPE_MAP = new HashMap<String, String>();
        INTEGER_FAMILY.add(TINY_INT);
        INTEGER_FAMILY.add(SMALL_INT);
        INTEGER_FAMILY.add(INTEGER);
        INTEGER_FAMILY.add(BIGINT);
        INTEGER_FAMILY.add(INT4);
        INTEGER_FAMILY.add(LONG8);
        NUMBER_FAMILY.addAll(INTEGER_FAMILY);
        NUMBER_FAMILY.add(FLOAT);
        NUMBER_FAMILY.add(DOUBLE);
        NUMBER_FAMILY.add(DECIMAL);
        NUMBER_FAMILY.add(REAL);
        NUMBER_FAMILY.add(NUMERIC);
        DATETIME_FAMILY.add(DATE);
        DATETIME_FAMILY.add(TIME);
        DATETIME_FAMILY.add(DATETIME);
        DATETIME_FAMILY.add(TIMESTAMP);
        STRING_FAMILY.add(VARCHAR);
        STRING_FAMILY.add(CHAR);
        BOOLEAN_FAMILY.add(BOOLEAN);
        LEGACY_TYPE_MAP.put(BYTE, TINY_INT);
        LEGACY_TYPE_MAP.put(INT, INTEGER);
        LEGACY_TYPE_MAP.put(SHORT, SMALL_INT);
        LEGACY_TYPE_MAP.put(LONG, BIGINT);
        LEGACY_TYPE_MAP.put(STRING, VARCHAR);
        LEGACY_TYPE_MAP.put("hllc10", "hllc(10)");
        LEGACY_TYPE_MAP.put("hllc12", "hllc(12)");
        LEGACY_TYPE_MAP.put("hllc14", "hllc(14)");
        LEGACY_TYPE_MAP.put("hllc15", "hllc(15)");
        LEGACY_TYPE_MAP.put("hllc16", "hllc(16)");
        CACHE = new ConcurrentHashMap<DataType, DataType>();
        ANY = DataType.getType(ANY_STR);
        MeasureTypeFactory.getUDAFs();
        serializer = new BytesSerializer<DataType>(){

            public void serialize(DataType value, ByteBuffer out) {
                this.serializeDataType(value, out);
            }

            private void serializeDataType(DataType value, ByteBuffer out) {
                BytesUtil.writeUTFString((String)value.name, (ByteBuffer)out);
                BytesUtil.writeVInt((int)value.precision, (ByteBuffer)out);
                BytesUtil.writeVInt((int)value.scale, (ByteBuffer)out);
            }

            public DataType deserialize(ByteBuffer in) {
                String name = BytesUtil.readUTFString((ByteBuffer)in);
                int precision = BytesUtil.readVInt((ByteBuffer)in);
                int scale = BytesUtil.readVInt((ByteBuffer)in);
                return new DataType(name, precision, scale);
            }
        };
    }
}

