/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm.genetic;

import java.util.List;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.StoppingCondition;
import org.apache.kylin.metadata.cube.planner.algorithm.genetic.GeneticAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedStoppingCondition
implements StoppingCondition {
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    private List<StoppingCondition> conditions;

    public CombinedStoppingCondition(List<StoppingCondition> conditions) {
        this.conditions = conditions;
    }

    public boolean isSatisfied(Population population) {
        for (StoppingCondition condition : this.conditions) {
            if (!condition.isSatisfied(population)) continue;
            logger.info("Stopping condition {} is satisfied", (Object)condition);
            return true;
        }
        return false;
    }
}

