/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kylin.metadata.cube.planner.algorithm.BenefitPolicy;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidRecommendAlgorithm;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecommendAlgorithm
implements CuboidRecommendAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecommendAlgorithm.class);
    protected final CuboidStats cuboidStats;
    protected final BenefitPolicy benefitPolicy;
    private AtomicBoolean cancelRequested = new AtomicBoolean(false);
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private long timeoutMillis;

    public AbstractRecommendAlgorithm(long timeout, BenefitPolicy benefitPolicy, CuboidStats cuboidStats) {
        this.timeoutMillis = timeout <= 0L ? Long.MAX_VALUE : timeout;
        this.cuboidStats = cuboidStats;
        this.benefitPolicy = benefitPolicy;
    }

    @Override
    public List<BigInteger> recommend(double expansionRate) {
        double spaceLimit = this.cuboidStats.getBaseCuboidSize() * expansionRate;
        logger.info("space limit for the algorithm is {} with expansion rate {}", (Object)spaceLimit, (Object)expansionRate);
        return this.start(spaceLimit);
    }

    @Override
    public void cancel() {
        this.cancelRequested.set(true);
    }

    protected boolean shouldCancel() {
        if (this.canceled.get()) {
            return true;
        }
        if (this.cancelRequested.get()) {
            this.canceled.set(true);
            this.cancelRequested.set(false);
            logger.warn("Algorithm is canceled.");
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > this.timeoutMillis) {
            this.canceled.set(true);
            logger.warn("Algorithm exceeds time limit.");
            return true;
        }
        return false;
    }
}

