/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.AbstractOptStrategy;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.cube.utils.IndexPlanReduceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarLayoutOptStrategy
extends AbstractOptStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimilarLayoutOptStrategy.class);

    public SimilarLayoutOptStrategy() {
        this.setType(GarbageLayoutType.SIMILAR);
    }

    @Override
    protected Set<Long> doCollect(List<LayoutEntity> inputLayouts, NDataflow dataflow, boolean needLog) {
        NDataSegment latestReadySegment = dataflow.getLatestReadySegment();
        if (latestReadySegment == null) {
            return Sets.newHashSet();
        }
        Map<Long, NDataLayout> dataLayoutMap = latestReadySegment.getLayoutsMap();
        HashSet garbageLayouts = Sets.newHashSet();
        Set<Pair<LayoutEntity, LayoutEntity>> sonToFatherLineageMap = this.buildLineage(inputLayouts);
        List<Pair<LayoutEntity, LayoutEntity>> similarList = this.retainSimilarLineage(sonToFatherLineageMap, dataLayoutMap);
        similarList.forEach(pair -> garbageLayouts.add(((LayoutEntity)pair.getFirst()).getId()));
        this.shiftLayoutHitCount(similarList, dataflow);
        if (needLog) {
            log.info("In dataflow({}), SimilarLayoutGcStrategy found garbage laoyouts: {}", (Object)dataflow.getId(), similarList);
        }
        return garbageLayouts;
    }

    @Override
    protected void skipOptimizeIndex(List<LayoutEntity> inputLayouts) {
        inputLayouts.removeIf(layout -> IndexEntity.isTableIndex(layout.getId()));
    }

    private void shiftLayoutHitCount(List<Pair<LayoutEntity, LayoutEntity>> pairs, NDataflow dataflow) {
        HashMap ancestorToChildren = Maps.newHashMap();
        pairs.forEach(pair -> {
            Long ancestor = ((LayoutEntity)pair.getSecond()).getId();
            Long descendant = ((LayoutEntity)pair.getFirst()).getId();
            ancestorToChildren.putIfAbsent(ancestor, Sets.newHashSet());
            ((Set)ancestorToChildren.get(ancestor)).add(descendant);
        });
        Map<Long, FrequencyMap> layoutHitCount = dataflow.getLayoutHitCount();
        HashMap ancestorFreqFromChildren = Maps.newHashMap();
        ancestorToChildren.forEach((ancestorId, children) -> {
            ancestorFreqFromChildren.putIfAbsent(ancestorId, new FrequencyMap());
            FrequencyMap ancestorFreqMap = (FrequencyMap)ancestorFreqFromChildren.get(ancestorId);
            children.forEach(child -> {
                FrequencyMap frequencyMap = (FrequencyMap)layoutHitCount.get(child);
                if (frequencyMap != null) {
                    NavigableMap<Long, Integer> tmp = frequencyMap.getDateFrequency();
                    tmp.forEach((date, cnt) -> ancestorFreqMap.getDateFrequency().merge((Long)date, (Integer)cnt, Integer::sum));
                }
            });
        });
        ancestorToChildren.forEach((ancestorId, children) -> {
            layoutHitCount.putIfAbsent((Long)ancestorId, new FrequencyMap());
            FrequencyMap frequencyMap = (FrequencyMap)layoutHitCount.get(ancestorId);
            ((FrequencyMap)ancestorFreqFromChildren.get(ancestorId)).getDateFrequency().forEach((date, cnt) -> frequencyMap.getDateFrequency().merge((Long)date, (Integer)cnt, Integer::sum));
        });
        dataflow.setLayoutHitCount(layoutHitCount);
    }

    private List<Pair<LayoutEntity, LayoutEntity>> retainSimilarLineage(Set<Pair<LayoutEntity, LayoutEntity>> sonToFatherLineageSet, Map<Long, NDataLayout> dataLayoutMap) {
        double relativeSimilarity = KylinConfig.getInstanceFromEnv().getLayoutSimilarityThreshold();
        double rejectSimilarThreshold = KylinConfig.getInstanceFromEnv().getSimilarityStrategyRejectThreshold();
        ArrayList retainedMap = Lists.newArrayList();
        sonToFatherLineageSet.forEach(pair -> {
            LayoutEntity son = (LayoutEntity)pair.getFirst();
            LayoutEntity father = (LayoutEntity)pair.getSecond();
            if (!dataLayoutMap.containsKey(son.getId()) || !dataLayoutMap.containsKey(father.getId())) {
                return;
            }
            NDataLayout sonData = (NDataLayout)dataLayoutMap.get(son.getId());
            NDataLayout fatherData = (NDataLayout)dataLayoutMap.get(father.getId());
            if (IndexEntity.isTableIndex(son.getId())) {
                retainedMap.add(new Pair((Object)son, (Object)father));
                return;
            }
            if (this.isSimilar(sonData, fatherData, relativeSimilarity, rejectSimilarThreshold)) {
                retainedMap.add(new Pair((Object)son, (Object)father));
            }
        });
        return retainedMap;
    }

    private boolean isSimilar(NDataLayout son, NDataLayout father, double similarityThreshold, double rejectSimilar) {
        if ((double)(father.getRows() - son.getRows()) > rejectSimilar) {
            return false;
        }
        double similarity = 1.0 * (double)son.getRows() / (double)father.getRows();
        return similarity >= similarityThreshold;
    }

    private Set<Pair<LayoutEntity, LayoutEntity>> buildLineage(List<LayoutEntity> inputLayouts) {
        HashSet lineageSet = Sets.newHashSet();
        HashMap layoutsGroupByMeasures = Maps.newHashMap();
        inputLayouts.forEach(layout -> {
            HashSet dimGroup = IndexEntity.isTableIndex(layout.getId()) ? Sets.newHashSet() : layout.getColOrder().stream().filter(idx -> idx >= 100000).collect(Collectors.toSet());
            layoutsGroupByMeasures.putIfAbsent(dimGroup, Sets.newHashSet());
            ((Set)layoutsGroupByMeasures.get(dimGroup)).add(layout);
        });
        layoutsGroupByMeasures.forEach((measures, layouts) -> {
            List<LayoutEntity> sortedLayouts = IndexPlanReduceUtil.descSortByColOrderSize(Lists.newArrayList((Iterable)layouts));
            lineageSet.addAll(this.findLineage(sortedLayouts));
        });
        return lineageSet;
    }

    private Set<Pair<LayoutEntity, LayoutEntity>> findLineage(List<LayoutEntity> sortedLayouts) {
        HashSet lineageSet = Sets.newHashSet();
        for (int i = 0; i < sortedLayouts.size(); ++i) {
            LayoutEntity father = sortedLayouts.get(i);
            for (int j = i + 1; j < sortedLayouts.size(); ++j) {
                LayoutEntity son = sortedLayouts.get(j);
                if (father.getColOrder().size() == son.getColOrder().size() || !Objects.equals(son.getShardByColumns(), father.getShardByColumns())) continue;
                ImmutableList fatherDims = father.getOrderedDimensions().keySet().asList();
                ImmutableList sonDims = son.getOrderedDimensions().keySet().asList();
                if (!IndexPlanReduceUtil.isSubPartColOrder((List<Integer>)sonDims, (List<Integer>)fatherDims)) continue;
                lineageSet.add(new Pair((Object)son, (Object)father));
            }
        }
        return lineageSet;
    }
}

