/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.DeriveInfo;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealizationCandidate;

public class NLayoutCandidate
implements IRealizationCandidate {
    private LayoutEntity layoutEntity;
    private NDataLayoutDetails dataLayoutDetails;
    private long layoutId;
    private double cost;
    private List<NDataSegment> prunedSegments;
    private CapabilityResult capabilityResult;
    private long range;
    private long maxSegEnd;
    private Map<Integer, DeriveInfo> derivedToHostMap = Maps.newHashMap();
    Set<String> derivedLookups = Sets.newHashSet();
    private boolean isStreaming;

    public NLayoutCandidate(LayoutEntity layoutEntity) {
        Preconditions.checkNotNull((Object)layoutEntity);
        this.layoutEntity = layoutEntity;
        this.layoutId = layoutEntity.getId();
    }

    public NLayoutCandidate(LayoutEntity layoutEntity, NDataLayoutDetails dataLayoutDetails) {
        Preconditions.checkNotNull((Object)layoutEntity);
        Preconditions.checkNotNull((Object)dataLayoutDetails);
        this.layoutEntity = layoutEntity;
        this.layoutId = layoutEntity.getId();
        this.dataLayoutDetails = dataLayoutDetails;
    }

    public NLayoutCandidate(LayoutEntity layoutEntity, double cost, CapabilityResult result) {
        this(layoutEntity);
        this.cost = cost;
        this.capabilityResult = result;
    }

    public static NLayoutCandidate ofEmptyCandidate() {
        LayoutEntity layout = new LayoutEntity();
        layout.setId(-1L);
        return new NLayoutCandidate(layout, 2.147483647E9, new CapabilityResult());
    }

    public boolean isEmpty() {
        return this.layoutEntity == null || this.layoutEntity.getId() == -1L;
    }

    public boolean isTableIndex() {
        return !this.isEmpty() && IndexEntity.isTableIndex(this.layoutId);
    }

    public boolean isAggIndex() {
        return !this.isEmpty() && IndexEntity.isAggIndex(this.layoutId);
    }

    public Map<List<Integer>, List<DeriveInfo>> makeHostToDerivedMap() {
        HashMap hostToDerivedMap = Maps.newHashMap();
        this.derivedToHostMap.forEach((derivedColId, deriveInfo) -> {
            DeriveInfo.DeriveType type = deriveInfo.type;
            List<Integer> columns = deriveInfo.columns;
            List infoList = hostToDerivedMap.computeIfAbsent(columns, k -> Lists.newArrayList());
            if (!NLayoutCandidate.isMerged(derivedColId, deriveInfo, infoList)) {
                infoList.add(new DeriveInfo(type, deriveInfo.join, Lists.newArrayList((Object[])new Integer[]{derivedColId}), false));
            }
        });
        return hostToDerivedMap;
    }

    private static boolean isMerged(Integer derCol, DeriveInfo deriveInfo, List<DeriveInfo> infoList) {
        DeriveInfo.DeriveType type = deriveInfo.type;
        boolean merged = false;
        for (DeriveInfo existing : infoList) {
            if (existing.type == type && existing.join.getPKSide().equals(deriveInfo.join.getPKSide())) {
                if (existing.columns.contains(derCol)) {
                    merged = true;
                }
                if (type == DeriveInfo.DeriveType.LOOKUP || type == DeriveInfo.DeriveType.LOOKUP_NON_EQUI) {
                    existing.columns.add(derCol);
                    merged = true;
                }
            }
            if (!merged) continue;
            break;
        }
        return merged;
    }

    public String toString() {
        String type = "";
        if (this.layoutEntity.isManual()) {
            type = type + "manual";
        } else if (this.layoutEntity.isAuto()) {
            type = type + "auto";
        }
        if (this.layoutEntity.isBase()) {
            type = type + (type.isEmpty() ? "base" : ",base");
        }
        if (type.isEmpty()) {
            type = "unknown";
        }
        return "LayoutCandidate{layout=" + this.layoutEntity + ", type=" + type + ", cost=" + this.cost + "}";
    }

    @Generated
    public LayoutEntity getLayoutEntity() {
        return this.layoutEntity;
    }

    @Generated
    public NDataLayoutDetails getDataLayoutDetails() {
        return this.dataLayoutDetails;
    }

    @Generated
    public long getLayoutId() {
        return this.layoutId;
    }

    @Override
    @Generated
    public double getCost() {
        return this.cost;
    }

    @Generated
    public List<NDataSegment> getPrunedSegments() {
        return this.prunedSegments;
    }

    @Generated
    public CapabilityResult getCapabilityResult() {
        return this.capabilityResult;
    }

    @Generated
    public long getRange() {
        return this.range;
    }

    @Generated
    public long getMaxSegEnd() {
        return this.maxSegEnd;
    }

    @Generated
    public Map<Integer, DeriveInfo> getDerivedToHostMap() {
        return this.derivedToHostMap;
    }

    @Generated
    public Set<String> getDerivedLookups() {
        return this.derivedLookups;
    }

    @Generated
    public boolean isStreaming() {
        return this.isStreaming;
    }

    @Generated
    public void setLayoutEntity(LayoutEntity layoutEntity) {
        this.layoutEntity = layoutEntity;
    }

    @Generated
    public void setDataLayoutDetails(NDataLayoutDetails dataLayoutDetails) {
        this.dataLayoutDetails = dataLayoutDetails;
    }

    @Generated
    public void setLayoutId(long layoutId) {
        this.layoutId = layoutId;
    }

    @Generated
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Generated
    public void setPrunedSegments(List<NDataSegment> prunedSegments) {
        this.prunedSegments = prunedSegments;
    }

    @Generated
    public void setCapabilityResult(CapabilityResult capabilityResult) {
        this.capabilityResult = capabilityResult;
    }

    @Generated
    public void setRange(long range) {
        this.range = range;
    }

    @Generated
    public void setMaxSegEnd(long maxSegEnd) {
        this.maxSegEnd = maxSegEnd;
    }

    @Generated
    public void setDerivedToHostMap(Map<Integer, DeriveInfo> derivedToHostMap) {
        this.derivedToHostMap = derivedToHostMap;
    }

    @Generated
    public void setDerivedLookups(Set<String> derivedLookups) {
        this.derivedLookups = derivedLookups;
    }

    @Generated
    public void setStreaming(boolean isStreaming) {
        this.isStreaming = isStreaming;
    }
}

