/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.exception.OutOfMaxCombinationException;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.math.LongMath;
import org.apache.kylin.metadata.cube.cuboid.CuboidScheduler;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NAggregationGroup
implements Serializable {
    @JsonProperty(value="includes")
    private Integer[] includes;
    @JsonProperty(value="measures")
    private Integer[] measures;
    @JsonProperty(value="select_rule")
    private SelectRule selectRule;
    @JsonProperty(value="index_range")
    private IndexEntity.Range indexRange = IndexEntity.Range.BATCH;
    private BigInteger partialCubeFullMask;
    private BigInteger mandatoryColumnMask;
    private BigInteger measureMask;
    private List<HierarchyMask> hierarchyMasks;
    private List<BigInteger> joints;
    private BigInteger jointDimsMask;
    private List<BigInteger> normalDimMeas;
    protected RuleBasedIndex ruleBasedAggIndex;
    private boolean isMandatoryOnlyValid;
    private HashMap<BigInteger, BigInteger> dim2JointMap;

    public void init(RuleBasedIndex ruleBasedCuboidsDesc) {
        this.ruleBasedAggIndex = ruleBasedCuboidsDesc;
        this.isMandatoryOnlyValid = ruleBasedCuboidsDesc.getIndexPlan().getConfig().getCubeAggrGroupIsMandatoryOnlyValid();
        if (this.includes == null || this.includes.length == 0 || this.selectRule == null) {
            throw new IllegalStateException("AggregationGroup incomplete");
        }
        this.checkAndNormalizeFields();
        this.buildMeasureMask();
        this.buildPartialCubeFullMask();
        this.buildMandatoryColumnMask();
        this.buildJointColumnMask();
        this.buildJointDimsMask();
        this.buildHierarchyMasks();
        this.buildNormalDimsMask();
    }

    private void buildMeasureMask() {
        if (this.measures == null || this.measures.length == 0) {
            this.measures = this.ruleBasedAggIndex.getMeasures().toArray(new Integer[0]);
        }
        this.measureMask = this.buildMask(this.measures);
    }

    private void checkAndNormalizeFields() {
        Preconditions.checkNotNull((Object)this.includes);
        this.checkAndNormalizeFields(this.includes);
        Preconditions.checkNotNull((Object)this.selectRule.mandatoryDims);
        this.checkAndNormalizeFields(this.selectRule.mandatoryDims);
        if (this.selectRule.hierarchyDims == null) {
            this.selectRule.hierarchyDims = new Integer[0][];
        }
        for (Integer[] cols : this.selectRule.hierarchyDims) {
            Preconditions.checkNotNull((Object)cols);
            this.checkAndNormalizeFields(cols);
        }
        if (this.selectRule.jointDims == null) {
            this.selectRule.jointDims = new Integer[0][];
        }
        for (Integer[] cols : this.selectRule.jointDims) {
            Preconditions.checkNotNull((Object)cols);
            this.checkAndNormalizeFields(cols);
        }
    }

    private void checkAndNormalizeFields(Integer[] dims) {
        if (dims == null) {
            return;
        }
        HashSet<Integer> set = new HashSet<Integer>(Arrays.asList(dims));
        if (set.size() < dims.length) {
            throw new IllegalStateException("Columns in aggrgroup must not contain duplication: " + Arrays.asList(dims));
        }
    }

    private void buildPartialCubeFullMask() {
        Preconditions.checkState((this.includes != null ? 1 : 0) != 0);
        Preconditions.checkState((this.includes.length != 0 ? 1 : 0) != 0);
        this.partialCubeFullMask = this.buildMask(this.includes);
    }

    private BigInteger buildMask(Integer[] ids) {
        BigInteger mask;
        BigInteger bigInteger = mask = this.measureMask == null ? BigInteger.ZERO : this.measureMask;
        if (ids == null || ids.length == 0) {
            return mask;
        }
        for (Integer id : ids) {
            mask = mask.setBit(this.ruleBasedAggIndex.getColumnBitIndex(id));
        }
        return mask;
    }

    private void buildJointColumnMask() {
        this.joints = Lists.newArrayList();
        this.dim2JointMap = Maps.newHashMap();
        if (this.selectRule.jointDims == null || this.selectRule.jointDims.length == 0) {
            return;
        }
        for (Integer[] jointDims : this.selectRule.jointDims) {
            if (jointDims == null || jointDims.length == 0) continue;
            BigInteger joint = this.buildMask(jointDims);
            Preconditions.checkState((!joint.equals(this.measureMask) ? 1 : 0) != 0);
            this.joints.add(joint);
        }
        for (BigInteger jt : this.joints) {
            for (int i = 0; i < jt.bitLength(); ++i) {
                if (!jt.testBit(i)) continue;
                BigInteger dim = BigInteger.ZERO;
                dim = dim.setBit(i).or(this.measureMask);
                this.dim2JointMap.put(dim, jt);
            }
        }
    }

    private void buildMandatoryColumnMask() {
        this.mandatoryColumnMask = this.buildMask(this.selectRule.mandatoryDims);
    }

    private void buildHierarchyMasks() {
        this.hierarchyMasks = Lists.newArrayList();
        if (this.selectRule.hierarchyDims == null || this.selectRule.hierarchyDims.length == 0) {
            return;
        }
        for (Integer[] hierarchyDims : this.selectRule.hierarchyDims) {
            HierarchyMask mask = new HierarchyMask();
            if (hierarchyDims == null || hierarchyDims.length == 0) continue;
            ArrayList<BigInteger> allMaskList = new ArrayList<BigInteger>();
            for (int i = 0; i < hierarchyDims.length; ++i) {
                Integer index = this.ruleBasedAggIndex.getColumnBitIndex(hierarchyDims[i]);
                BigInteger bit = BigInteger.ZERO.setBit(index);
                if (this.dim2JointMap.get(bit = bit.or(this.measureMask)) != null) {
                    bit = this.dim2JointMap.get(bit);
                }
                mask.fullMask = mask.fullMask.or(bit);
                allMaskList.add(mask.fullMask);
            }
            HierarchyMask.access$102(mask, (BigInteger[])allMaskList.stream().toArray(BigInteger[]::new));
            this.hierarchyMasks.add(mask);
        }
    }

    private void buildNormalDimsMask() {
        BigInteger leftover = this.partialCubeFullMask.andNot(this.mandatoryColumnMask);
        leftover = leftover.andNot(this.jointDimsMask);
        for (HierarchyMask hierarchyMask : this.hierarchyMasks) {
            leftover = leftover.andNot(hierarchyMask.fullMask);
        }
        this.normalDimMeas = this.bits(leftover);
    }

    private List<BigInteger> bits(BigInteger x) {
        ArrayList r = Lists.newArrayList();
        BigInteger l = x;
        while (!l.equals(BigInteger.ZERO)) {
            BigInteger bit2 = BigInteger.ZERO.setBit(l.getLowestSetBit());
            r.add(bit2);
            l = l.xor(bit2);
        }
        return r.stream().map(bit -> bit.or(this.measureMask)).collect(Collectors.toList());
    }

    public void buildJointDimsMask() {
        BigInteger ret = this.measureMask;
        for (BigInteger x : this.joints) {
            ret = ret.or(x);
        }
        this.jointDimsMask = ret;
    }

    public BigInteger getMandatoryColumnMask() {
        return this.mandatoryColumnMask;
    }

    public List<HierarchyMask> getHierarchyMasks() {
        return this.hierarchyMasks;
    }

    public long calculateCuboidCombination() {
        long combination;
        block9: {
            combination = 1L;
            try {
                if (this.getDimCap() > 0 || this.ruleBasedAggIndex.getGlobalDimCap() > 0) {
                    try {
                        CuboidScheduler cuboidScheduler = CuboidScheduler.getInstance(this.ruleBasedAggIndex.getIndexPlan(), this.ruleBasedAggIndex, true);
                        combination = cuboidScheduler.calculateCuboidsForAggGroup(this).size();
                        break block9;
                    }
                    catch (OutOfMaxCombinationException oe) {
                        return Long.MAX_VALUE;
                    }
                }
                TreeSet<Integer> includeDims = new TreeSet<Integer>(Arrays.asList(this.includes));
                TreeSet<Integer> mandatoryDims = new TreeSet<Integer>(Arrays.asList(this.selectRule.mandatoryDims));
                TreeSet<Integer> hierarchyDims = new TreeSet<Integer>();
                for (Integer[] ss : this.selectRule.hierarchyDims) {
                    hierarchyDims.addAll(Arrays.asList(ss));
                    combination = LongMath.checkedMultiply((long)combination, (long)(ss.length + 1));
                }
                TreeSet<Integer> jointDims = new TreeSet<Integer>();
                for (Integer[] ss : this.selectRule.jointDims) {
                    jointDims.addAll(Arrays.asList(ss));
                }
                combination = LongMath.checkedMultiply((long)combination, (long)(1L << this.selectRule.jointDims.length));
                TreeSet<Integer> normalDims = new TreeSet<Integer>((Collection<Integer>)includeDims);
                normalDims.removeAll(mandatoryDims);
                normalDims.removeAll(hierarchyDims);
                normalDims.removeAll(jointDims);
                combination = LongMath.checkedMultiply((long)combination, (long)(1L << normalDims.size()));
                if (this.isMandatoryOnlyValid && !mandatoryDims.isEmpty()) {
                    ++combination;
                }
                --combination;
            }
            catch (ArithmeticException e) {
                combination = Long.MAX_VALUE;
            }
        }
        if (combination < 0L) {
            combination = Long.MAX_VALUE;
        }
        return combination;
    }

    public boolean isOnTree(BigInteger cuboidId) {
        if (cuboidId.compareTo(BigInteger.ZERO) <= 0 || cuboidId.compareTo(this.measureMask) <= 0) {
            return false;
        }
        if (!cuboidId.andNot(this.partialCubeFullMask).equals(BigInteger.ZERO)) {
            return false;
        }
        return this.checkMandatoryColumns(cuboidId) && this.checkHierarchy(cuboidId) && this.checkJoint(cuboidId);
    }

    private boolean checkMandatoryColumns(BigInteger cuboidID) {
        if (!cuboidID.and(this.mandatoryColumnMask).equals(this.mandatoryColumnMask)) {
            return false;
        }
        boolean baseCuboidValid = this.ruleBasedAggIndex.getModel().getConfig().isBaseCuboidAlwaysValid();
        if (baseCuboidValid && cuboidID.equals(this.ruleBasedAggIndex.getFullMask())) {
            return true;
        }
        return this.isMandatoryOnlyValid || !cuboidID.andNot(this.mandatoryColumnMask).equals(BigInteger.ZERO);
    }

    private boolean checkJoint(BigInteger cuboidID) {
        for (BigInteger joint : this.joints) {
            BigInteger common = cuboidID.and(joint);
            if (common.equals(this.measureMask) || common.equals(joint)) continue;
            return false;
        }
        return true;
    }

    private boolean checkHierarchy(BigInteger cuboidID) {
        if (this.hierarchyMasks == null || this.hierarchyMasks.size() == 0) {
            return true;
        }
        for (HierarchyMask hierarchy : this.hierarchyMasks) {
            BigInteger result = cuboidID.and(hierarchy.fullMask);
            if (result.compareTo(this.measureMask) <= 0) continue;
            boolean meetHierarchy = false;
            for (BigInteger mask : hierarchy.allMasks) {
                if (!result.equals(mask)) continue;
                meetHierarchy = true;
                break;
            }
            if (meetHierarchy) continue;
            return false;
        }
        return true;
    }

    public List<BigInteger> getJoints() {
        return this.joints;
    }

    public List<BigInteger> getNormalDimMeas() {
        return this.normalDimMeas;
    }

    public BigInteger getPartialCubeFullMask() {
        return this.partialCubeFullMask;
    }

    public BigInteger getMeasureMask() {
        return this.measureMask;
    }

    public boolean isMandatoryOnlyValid() {
        return this.isMandatoryOnlyValid;
    }

    public int getDimCap() {
        return this.selectRule.dimCap == null ? 0 : this.selectRule.dimCap;
    }

    boolean checkDimCap(BigInteger cuboidID) {
        int dimCap = this.getDimCap();
        if (dimCap == 0) {
            dimCap = this.ruleBasedAggIndex.getGlobalDimCap();
        }
        if (dimCap <= 0) {
            return true;
        }
        int dimCount = 0;
        for (BigInteger normal : this.getNormalDimMeas()) {
            if (cuboidID.and(normal).equals(this.getMeasureMask())) continue;
            ++dimCount;
        }
        for (BigInteger joint : this.getJoints()) {
            if (cuboidID.and(joint).equals(this.getMeasureMask())) continue;
            ++dimCount;
        }
        for (HierarchyMask hierarchy : this.getHierarchyMasks()) {
            if (cuboidID.and(hierarchy.getFullMask()).equals(this.getMeasureMask())) continue;
            ++dimCount;
        }
        return dimCount <= dimCap;
    }

    @Generated
    public Integer[] getIncludes() {
        return this.includes;
    }

    @Generated
    public void setIncludes(Integer[] includes) {
        this.includes = includes;
    }

    @Generated
    public Integer[] getMeasures() {
        return this.measures;
    }

    @Generated
    public void setMeasures(Integer[] measures) {
        this.measures = measures;
    }

    @Generated
    public SelectRule getSelectRule() {
        return this.selectRule;
    }

    @Generated
    public void setSelectRule(SelectRule selectRule) {
        this.selectRule = selectRule;
    }

    @Generated
    public void setIndexRange(IndexEntity.Range indexRange) {
        this.indexRange = indexRange;
    }

    @Generated
    public IndexEntity.Range getIndexRange() {
        return this.indexRange;
    }

    public static class HierarchyMask
    implements Serializable {
        private BigInteger fullMask = BigInteger.ZERO;
        private BigInteger[] allMasks;

        @Generated
        public BigInteger getFullMask() {
            return this.fullMask;
        }

        @Generated
        public void setFullMask(BigInteger fullMask) {
            this.fullMask = fullMask;
        }

        @Generated
        public BigInteger[] getAllMasks() {
            return this.allMasks;
        }

        @Generated
        public void setAllMasks(BigInteger[] allMasks) {
            this.allMasks = allMasks;
        }

        static /* synthetic */ BigInteger[] access$102(HierarchyMask x0, BigInteger[] x1) {
            x0.allMasks = x1;
            return x1;
        }
    }
}

