/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.Comparator;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Ordering;
import org.apache.kylin.metadata.cube.cuboid.ChooserContext;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class ComparatorUtils {
    private ComparatorUtils() {
    }

    public static Comparator<NLayoutCandidate> simple() {
        return (o1, o2) -> o2.getLayoutEntity().getOrderedDimensions().size() - o1.getLayoutEntity().getOrderedDimensions().size();
    }

    public static Comparator<TblColRef> nonFilterColComparator() {
        return ComparatorUtils.colNameDictionaryOrder();
    }

    private static Comparator<TblColRef> colNameDictionaryOrder() {
        return (col1, col2) -> {
            Preconditions.checkArgument((col1 != null && col1.getFilterLevel() == TblColRef.FilterColEnum.NONE ? 1 : 0) != 0);
            Preconditions.checkArgument((col2 != null && col2.getFilterLevel() == TblColRef.FilterColEnum.NONE ? 1 : 0) != 0);
            return col1.getIdentity().compareToIgnoreCase(col2.getIdentity());
        };
    }

    private static Comparator<TblColRef> filterColNameDictionaryOrder() {
        return (col1, col2) -> {
            Preconditions.checkArgument((col1 != null ? 1 : 0) != 0);
            Preconditions.checkArgument((col2 != null ? 1 : 0) != 0);
            return col1.getIdentity().compareToIgnoreCase(col2.getIdentity());
        };
    }

    public static Comparator<TblColRef> filterColComparator(ChooserContext chooserContext) {
        return Ordering.from(ComparatorUtils.filterLevelComparator()).compound(ComparatorUtils.cardinalityComparator(chooserContext)).compound(ComparatorUtils.filterColNameDictionaryOrder());
    }

    private static Comparator<TblColRef> filterLevelComparator() {
        return (col1, col2) -> {
            if (col1 != null && col2 != null) {
                return col2.getFilterLevel().getPriority() - col1.getFilterLevel().getPriority();
            }
            return 0;
        };
    }

    public static Comparator<TblColRef> cardinalityComparator(ChooserContext chooserContext) {
        return (col1, col2) -> {
            if (col1 == null || col2 == null) {
                return 0;
            }
            TableExtDesc.ColumnStats ret1 = chooserContext.getColumnStats((TblColRef)col1);
            TableExtDesc.ColumnStats ret2 = chooserContext.getColumnStats((TblColRef)col2);
            if (ret2 == null && ret1 == null) {
                return col1.getIdentity().compareToIgnoreCase(col2.getIdentity());
            }
            if (ret2 == null) {
                return -1;
            }
            if (ret1 == null) {
                return 1;
            }
            return Long.compare(ret2.getCardinality(), ret1.getCardinality());
        };
    }

    public static <T> Comparator<T> nullLastComparator() {
        return (t1, t2) -> {
            if (t1 == null && t2 != null) {
                return 1;
            }
            if (t2 == null && t1 != null) {
                return -1;
            }
            return 0;
        };
    }
}

