/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ArrayListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRDigest;
import org.apache.kylin.metadata.acl.ColumnToConds;
import org.apache.kylin.metadata.acl.DependentColumnInfo;
import org.apache.kylin.metadata.acl.PrincipalRowFilter;
import org.apache.kylin.metadata.acl.RowSet;
import org.apache.kylin.metadata.acl.SensitiveDataMaskInfo;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.table.ATable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclTCRManager {
    private static final Logger logger = LoggerFactory.getLogger(AclTCRManager.class);
    private static final String IDENTIFIER_FORMAT = "%s.%s";
    private final KylinConfig config;
    private final String project;
    private CachedCrudAssist<AclTCR> crud;

    public static AclTCRManager getInstance(KylinConfig config, String project) {
        return (AclTCRManager)config.getManager(project, AclTCRManager.class);
    }

    static AclTCRManager newInstance(KylinConfig config, String project) {
        return new AclTCRManager(config, project);
    }

    public AclTCRManager(KylinConfig config, final String project) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing AclGroupManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.project = project;
        ResourceStore metaStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
        this.crud = new CachedCrudAssist<AclTCR>(metaStore, MetadataType.ACL, project, AclTCR.class){

            @Override
            protected AclTCR initEntityAfterReload(AclTCR acl, String resourceName) {
                acl.init(resourceName, project, resourceName.contains(".u."));
                return acl;
            }
        };
        this.crud.reloadAll();
    }

    public void unloadTable(String dbTblName) {
        this.crud.listAll().forEach(aclTCR -> {
            if (Objects.isNull(aclTCR.getTable())) {
                return;
            }
            AclTCR copied = this.crud.copyForWrite((AclTCR)((Object)aclTCR));
            copied.getTable().remove(dbTblName);
            this.crud.save(copied);
        });
    }

    public AclTCR getAclTCR(String sid, boolean principal) {
        return this.crud.get(AclTCR.generateResourceName(this.project, sid, principal));
    }

    public void updateAclTCR(AclTCR updateTo, String sid, boolean principal) {
        updateTo.init(AclTCR.generateResourceName(this.project, sid, principal), this.project, principal);
        this.doUpdate(updateTo, this.crud);
    }

    private void doUpdate(AclTCR updateTo, CachedCrudAssist<AclTCR> crud) {
        AclTCR cached = crud.get(updateTo.resourceName());
        AclTCR copied = crud.copyForWrite(cached == null ? updateTo : cached);
        if (copied.getMvcc() != -1L) {
            copied.setTable(updateTo.getTable());
        }
        crud.save(copied);
    }

    public void revokeAclTCR(String sid, boolean principal) {
        this.crud.delete(AclTCR.generateResourceName(this.project, sid, principal));
    }

    public List<AclTCR> getAclTCRs(String username, Set<String> groups) {
        ArrayList result = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            result.add(this.crud.get(AclTCR.generateResourceName(this.project, username, true)));
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        boolean batchEnabled = kylinConfig.isBatchGetRowAclEnabled();
        if (CollectionUtils.isNotEmpty(groups)) {
            if (batchEnabled) {
                RawResourceFilter filter = RawResourceFilter.equalFilter((String)"project", (String)this.project);
                filter.addConditions("metaKey", Arrays.asList(groups.toArray()), RawResourceFilter.Operator.IN);
                result.addAll(this.crud.listByFilter(filter));
            } else {
                groups.forEach(g -> result.add(this.crud.get(AclTCR.generateResourceName(this.project, g, false))));
            }
        }
        return result.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> getAuthorizedTables(String username, Set<String> groups) {
        List<AclTCR> all = this.getAclTCRs(username, groups);
        if (this.isTablesAuthorized(all)) {
            return this.getAllTables();
        }
        return all.stream().map(aclTCR -> aclTCR.getTable().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getAuthorizedColumns(String username, Set<String> groups) {
        List<AclTCR> all = this.getAclTCRs(username, groups);
        if (this.isTablesAuthorized(all)) {
            return this.getAllColumns();
        }
        return all.stream().map(aclTCR -> aclTCR.getTable().entrySet().stream().map(entry -> {
            TableDesc tableDesc = NTableMetadataManager.getInstance(this.config, this.project).getTableDesc((String)entry.getKey());
            if (Objects.isNull(tableDesc)) {
                return Sets.newHashSet();
            }
            if (Objects.isNull(entry.getValue()) || Objects.isNull(((AclTCR.ColumnRow)entry.getValue()).getColumn())) {
                return Optional.ofNullable(tableDesc.getColumns()).map(Arrays::stream).orElseGet(Stream::empty).map(columnDesc -> this.getDbTblCols(tableDesc, (ColumnDesc)columnDesc)).flatMap(Collection::stream).collect(Collectors.toSet());
            }
            return Optional.ofNullable(tableDesc.getColumns()).map(Arrays::stream).orElseGet(Stream::empty).filter(columnDesc -> ((AclTCR.ColumnRow)entry.getValue()).getColumn().contains(columnDesc.getName())).map(columnDesc -> this.getDbTblCols(tableDesc, (ColumnDesc)columnDesc)).flatMap(Collection::stream).collect(Collectors.toSet());
        }).flatMap(Collection::stream).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Multimap<String, String> getAuthorizedColumnsGroupByTable(String userName, Set<String> groups) {
        List<AclTCR> allAclTCRs = this.getAclTCRs(userName, groups);
        if (this.isTablesAuthorized(allAclTCRs)) {
            return ArrayListMultimap.create();
        }
        HashMultimap authorizedColsMap = HashMultimap.create();
        allAclTCRs.stream().forEach(aclTCR -> aclTCR.getTable().entrySet().stream().forEach(entry -> {
            TableDesc tableDesc = NTableMetadataManager.getInstance(this.config, this.project).getTableDesc((String)entry.getKey());
            if (Objects.isNull(tableDesc) || Objects.isNull(entry.getValue()) || Objects.isNull(((AclTCR.ColumnRow)entry.getValue()).getColumn())) {
                return;
            }
            authorizedColsMap.putAll((Object)tableDesc.getIdentity(), (Iterable)((AclTCR.ColumnRow)entry.getValue()).getColumn());
        }));
        return authorizedColsMap;
    }

    public Map<String, List<TableDesc>> getAuthorizedTablesAndColumns(String userName, Set<String> groups, boolean fullyAuthorized) {
        if (fullyAuthorized) {
            return NTableMetadataManager.getInstance(this.config, this.project).listTablesGroupBySchema();
        }
        List<AclTCR> allAclTCRs = this.getAclTCRs(userName, groups);
        if (this.isTablesAuthorized(allAclTCRs)) {
            return NTableMetadataManager.getInstance(this.config, this.project).listTablesGroupBySchema();
        }
        HashMap schemasMap = Maps.newHashMap();
        allAclTCRs.stream().map(aclTCR -> aclTCR.getTable().keySet()).flatMap(Collection::stream).forEach(tableName -> {
            TableDesc originTableDesc = NTableMetadataManager.getInstance(this.config, this.project).getTableDesc((String)tableName);
            TableDesc authorizedTableDesc = this.getAuthorizedTableDesc(originTableDesc, allAclTCRs);
            schemasMap.computeIfAbsent(originTableDesc.getDatabase(), value -> Lists.newArrayList());
            ((List)schemasMap.get(originTableDesc.getDatabase())).add(authorizedTableDesc);
        });
        return schemasMap;
    }

    public TableDesc getAuthorizedTableDesc(TableDesc originTable, List<AclTCR> allAclTCRs) {
        if (allAclTCRs.stream().noneMatch(aclTCR -> aclTCR.isAuthorized(originTable.getIdentity()))) {
            return null;
        }
        TableDesc table = new TableDesc(originTable);
        table.setColumns((ColumnDesc[])Optional.ofNullable(table.getColumns()).map(Arrays::stream).orElseGet(Stream::empty).filter(c -> allAclTCRs.stream().anyMatch(aclTCR -> aclTCR.isAuthorized(table.getIdentity(), c.getName()))).toArray(ColumnDesc[]::new));
        return table;
    }

    public boolean isColumnsAuthorized(String user, Set<String> groups, Set<String> columns) {
        List<AclTCR> allTCRs = this.getAclTCRs(user, groups);
        for (String column : columns) {
            String[] columnSplit = column.split("\\.");
            String tableIdentity = columnSplit[0] + "." + columnSplit[1];
            String columnName = columnSplit[2];
            if (!allTCRs.stream().noneMatch(aclTCR -> aclTCR.isAuthorized(tableIdentity, columnName))) continue;
            return false;
        }
        return true;
    }

    public Optional<String> failFastUnauthorizedTableColumn(String username, Set<String> groups, Map<String, Set<String>> tableColumns) {
        if (MapUtils.isEmpty(tableColumns)) {
            return Optional.empty();
        }
        List<AclTCR> all = this.getAclTCRs(username, groups);
        if (this.isTablesAuthorized(all)) {
            return Optional.empty();
        }
        Map<String, Set<String>> authorizedTableColumns = this.getAuthorizedTableColumns(all);
        return tableColumns.entrySet().stream().map(entry -> {
            if (!authorizedTableColumns.containsKey(entry.getKey())) {
                return Optional.of(entry.getKey());
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue())) || Objects.isNull(authorizedTableColumns.get(entry.getKey()))) {
                return Optional.empty();
            }
            return ((Set)entry.getValue()).stream().filter(colName -> !((Set)authorizedTableColumns.get(entry.getKey())).contains(colName)).map(colName -> String.format(Locale.ROOT, IDENTIFIER_FORMAT, entry.getKey(), colName)).findAny();
        }).filter(Optional::isPresent).findAny().orElse(Optional.empty());
    }

    public AclTCRDigest getAllUnauthorizedTableColumn(String username, Set<String> groups, Map<String, Set<String>> tableColumns) {
        HashSet unauthTables = Sets.newHashSet();
        HashSet unauthColumns = Sets.newHashSet();
        if (MapUtils.isEmpty(tableColumns)) {
            return new AclTCRDigest();
        }
        List<AclTCR> all = this.getAclTCRs(username, groups);
        if (all == null || all.isEmpty() || this.isTablesAuthorized(all)) {
            return new AclTCRDigest();
        }
        Map<String, Set<String>> authorizedTableColumns = this.getAuthorizedTableColumns(all);
        tableColumns.forEach((table, columns) -> {
            if (!authorizedTableColumns.containsKey(table)) {
                unauthTables.add(table);
                return;
            }
            Set authorizedColumns = (Set)authorizedTableColumns.get(table);
            if (CollectionUtils.isEmpty((Collection)columns) || Objects.isNull(authorizedColumns)) {
                return;
            }
            for (String column : columns) {
                if (authorizedColumns.contains(column)) continue;
                unauthColumns.add(table + "." + column);
            }
        });
        AclTCRDigest aclTCRDigest = new AclTCRDigest();
        aclTCRDigest.setTables(unauthTables);
        aclTCRDigest.setColumns(unauthColumns);
        return aclTCRDigest;
    }

    public Map<String, String> getTableColumnConcatWhereCondition(String username, Set<String> groups) {
        Map<Object, Object> result = Maps.newHashMap();
        List<AclTCR> all = this.getAclTCRs(username, groups);
        if (this.isTablesAuthorized(all)) {
            return result;
        }
        result = this.generateCondition(all);
        return result;
    }

    private Map<String, String> generateCondition(List<AclTCR> all) {
        HashMap result = Maps.newHashMap();
        Map<String, List<PrincipalRowFilter>> dbTblPrincipals = this.getTblPrincipalSet(all);
        if (MapUtils.isEmpty(dbTblPrincipals)) {
            return result;
        }
        dbTblPrincipals.forEach((dbTblName, principals) -> {
            TableDesc tableDesc = NTableMetadataManager.getInstance(this.config, this.project).getTableDesc((String)dbTblName);
            if (Objects.isNull(tableDesc)) {
                return;
            }
            Map<String, String> columnType = Optional.ofNullable(tableDesc.getColumns()).map(Arrays::stream).orElseGet(Stream::empty).map(columnDesc -> new AbstractMap.SimpleEntry<String, String>(StringUtils.upperCase((String)columnDesc.getName()), columnDesc.getTypeName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<String> conditions = principals.stream().map(p -> {
                if (CollectionUtils.isEmpty(p.getRowFilter())) {
                    return this.generateDbTblCondition((PrincipalRowFilter)p, columnType);
                }
                return this.generateDbTblConditionV2((PrincipalRowFilter)p, columnType);
            }).collect(Collectors.toList());
            result.put(dbTblName, this.concatPrincipalConditions(conditions));
        });
        return result;
    }

    private String generateDbTblCondition(PrincipalRowFilter principalRF, Map<String, String> columnType) {
        ColumnToConds columnConditions = new ColumnToConds();
        principalRF.getRowSets().stream().filter(r -> columnType.containsKey(r.getColumnName())).forEach(r -> {
            List cfr_ignored_0 = (List)columnConditions.put(r.getColumnName(), r.getValues().stream().map(v -> new ColumnToConds.Cond((String)v, ColumnToConds.IntervalType.CLOSED)).collect(Collectors.toList()));
        });
        ColumnToConds columnLikeConditions = new ColumnToConds();
        principalRF.getLikeRowSets().stream().filter(r -> columnType.containsKey(r.getColumnName())).forEach(r -> {
            List cfr_ignored_0 = (List)columnLikeConditions.put(r.getColumnName(), r.getValues().stream().map(v -> new ColumnToConds.Cond((String)v, ColumnToConds.IntervalType.LIKE)).collect(Collectors.toList()));
        });
        return ColumnToConds.concatConds(columnConditions, columnLikeConditions, columnType);
    }

    private String generateDbTblConditionV2(PrincipalRowFilter principalRF, Map<String, String> columnType) {
        if (principalRF == null || principalRF.getRowFilter() == null || principalRF.getRowFilter().isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("(");
        principalRF.getRowFilter().stream().filter(filterGroup -> MapUtils.isNotEmpty((Map)filterGroup.getFilters())).forEach(filterGroup -> {
            if (result.charAt(result.length() - 1) == ')') {
                result.append(" ").append((Object)filterGroup.getType()).append(" ");
            }
            result.append("(");
            filterGroup.getFilters().entrySet().stream().filter(entry -> CollectionUtils.isNotEmpty(((AclTCR.FilterItems)entry.getValue()).getInItems()) || CollectionUtils.isNotEmpty(((AclTCR.FilterItems)entry.getValue()).getLikeItems())).forEach(entry -> {
                String columnName = (String)entry.getKey();
                AclTCR.FilterItems filterItems = (AclTCR.FilterItems)entry.getValue();
                if (result.charAt(result.length() - 1) == ')') {
                    result.append(" ").append((Object)filterItems.getType()).append(" ");
                }
                result.append("(");
                String type = (String)Preconditions.checkNotNull(columnType.get(StringUtils.upperCase((String)columnName)), (Object)("Column:" + columnName + " type not found"));
                if (CollectionUtils.isNotEmpty(filterItems.getInItems())) {
                    result.append(columnName).append(" in (").append(Joiner.on((String)", ").join((Iterable)filterItems.getInItems().stream().map(item -> ColumnToConds.Cond.trimWithoutCheck(item, type)).collect(Collectors.toList()))).append(")");
                }
                if (CollectionUtils.isNotEmpty(filterItems.getLikeItems())) {
                    if (result.charAt(result.length() - 1) == ')') {
                        result.append(" OR ");
                    }
                    result.append(Joiner.on((String)" OR ").join((Iterable)filterItems.getLikeItems().stream().map(item -> columnName + " like " + ColumnToConds.Cond.trimWithoutCheck(item, type)).collect(Collectors.toList())));
                }
                result.append(")");
            });
            result.append(")");
        });
        result.append(")");
        return result.toString();
    }

    private String concatPrincipalConditions(List<String> conditions) {
        String joint = String.join((CharSequence)" OR ", conditions);
        if (conditions.size() > 1) {
            StringBuilder sb = new StringBuilder("(");
            sb.append(joint);
            sb.append(")");
            return sb.toString();
        }
        return joint;
    }

    public AclTCR.ColumnRealRows getAuthorizedRows(String dbTblName, String colName, List<AclTCR> aclTCRS) {
        AclTCR.RealRow authEqualRows = new AclTCR.RealRow();
        AclTCR.RealRow authLikeRows = new AclTCR.RealRow();
        for (AclTCR aclTCR : aclTCRS) {
            if (Objects.isNull(aclTCR.getTable())) {
                return new AclTCR.ColumnRealRows();
            }
            if (!aclTCR.getTable().containsKey(dbTblName)) continue;
            AclTCR.ColumnRow columnRow = (AclTCR.ColumnRow)aclTCR.getTable().get(dbTblName);
            if (Objects.isNull(columnRow)) {
                return new AclTCR.ColumnRealRows();
            }
            AclTCR.Row equalRow = columnRow.getRow();
            AclTCR.Row likeRow = columnRow.getLikeRow();
            if (!(equalRow != null && equalRow.get(colName) != null || likeRow != null && likeRow.get(colName) != null)) {
                return new AclTCR.ColumnRealRows();
            }
            if (equalRow != null && equalRow.get(colName) != null) {
                authEqualRows.addAll((Collection)equalRow.get(colName));
            }
            if (likeRow == null || likeRow.get(colName) == null) continue;
            authLikeRows.addAll((Collection)likeRow.get(colName));
        }
        String dbTblColName = dbTblName + "." + colName;
        return new AclTCR.ColumnRealRows(dbTblColName, authEqualRows, authLikeRows);
    }

    private static boolean isColumnWithoutRowLimit(String dbTblName, AclTCR aclTcr) {
        if (!aclTcr.getTable().containsKey(dbTblName)) {
            return false;
        }
        AclTCR.ColumnRow columnRow = (AclTCR.ColumnRow)aclTcr.getTable().get(dbTblName);
        return Objects.isNull(columnRow) || columnRow.isAllRowGranted();
    }

    private Map<String, List<PrincipalRowFilter>> getTblPrincipalSet(List<AclTCR> acls) {
        HashMap dbTblPrincipals = Maps.newHashMap();
        acls.forEach(tcr -> tcr.getTable().forEach((dbTblName, columnRow) -> {
            if (Objects.isNull(columnRow) || Objects.isNull(columnRow.getRow()) && Objects.isNull(columnRow.getLikeRow()) && Objects.isNull(columnRow.getRowFilter())) {
                return;
            }
            PrincipalRowFilter dbTblPrincipalRF = new PrincipalRowFilter();
            if (columnRow.getRowFilter() != null) {
                this.updatePrincipalRowFilter(columnRow.getRowFilter(), dbTblPrincipalRF, acls, (AclTCR)((Object)tcr), (String)dbTblName);
            } else {
                AclTCRManager.updatePrincipalRowSet(columnRow.getRow(), dbTblPrincipalRF.getRowSets(), acls, tcr, dbTblName);
                AclTCRManager.updatePrincipalRowSet(columnRow.getLikeRow(), dbTblPrincipalRF.getLikeRowSets(), acls, tcr, dbTblName);
            }
            if (CollectionUtils.isEmpty(dbTblPrincipalRF.getRowSets()) && CollectionUtils.isEmpty(dbTblPrincipalRF.getLikeRowSets()) && CollectionUtils.isEmpty(dbTblPrincipalRF.getRowFilter())) {
                return;
            }
            if (!dbTblPrincipals.containsKey(dbTblName)) {
                dbTblPrincipals.put(dbTblName, Lists.newArrayList());
            }
            ((List)dbTblPrincipals.get(dbTblName)).add(dbTblPrincipalRF);
        }));
        return dbTblPrincipals;
    }

    private static void updatePrincipalRowSet(AclTCR.Row sourceRow, List<RowSet> destRowSet, List<AclTCR> acls, AclTCR currentAcl, String dbTblName) {
        if (Objects.isNull(sourceRow)) {
            return;
        }
        sourceRow.forEach((colName, realRow) -> {
            if (Objects.isNull(realRow) || acls.stream().filter(e -> !e.equals((Object)currentAcl)).anyMatch(e -> AclTCRManager.isColumnWithoutRowLimit(dbTblName, e))) {
                return;
            }
            destRowSet.add(new RowSet((String)colName, (Set<String>)realRow));
        });
    }

    private void updatePrincipalRowFilter(List<AclTCR.FilterGroup> rowFilters, PrincipalRowFilter principalRF, List<AclTCR> acls, AclTCR currentAcl, String dbTblName) {
        if (Objects.isNull(rowFilters) || acls.stream().filter(e -> !e.equals((Object)currentAcl)).anyMatch(e -> AclTCRManager.isColumnWithoutRowLimit(dbTblName, e))) {
            return;
        }
        principalRF.getRowFilter().addAll(rowFilters);
    }

    private boolean isTablesAuthorized(List<AclTCR> all) {
        return all.stream().anyMatch(aclTCR -> Objects.isNull(aclTCR.getTable()));
    }

    private Set<String> getAllTables() {
        return NTableMetadataManager.getInstance(this.config, this.project).listAllTables().stream().map(ATable::getIdentity).collect(Collectors.toSet());
    }

    private Set<String> getAllColumns() {
        return NTableMetadataManager.getInstance(this.config, this.project).listAllTables().stream().map(tableDesc -> Optional.ofNullable(tableDesc.getColumns()).map(Arrays::stream).orElseGet(Stream::empty).map(columnDesc -> this.getDbTblCols((TableDesc)tableDesc, (ColumnDesc)columnDesc)).flatMap(Collection::stream).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> getDbTblCols(TableDesc tableDesc, ColumnDesc columnDesc) {
        HashSet result = Sets.newHashSet();
        if (columnDesc.isComputedColumn()) {
            result.addAll(ComputedColumnUtil.getCCUsedColsWithProject(this.project, columnDesc));
        } else {
            result.add(String.format(Locale.ROOT, IDENTIFIER_FORMAT, tableDesc.getIdentity(), columnDesc.getName()));
        }
        return result;
    }

    private Map<String, Set<String>> getAuthorizedTableColumns(List<AclTCR> all) {
        HashMap authorizedCoarse = Maps.newHashMap();
        all.forEach(aclTCR -> aclTCR.getTable().forEach((dbTblName, columnRow) -> {
            if (authorizedCoarse.containsKey(dbTblName) && Objects.isNull(authorizedCoarse.get(dbTblName))) {
                return;
            }
            if (Objects.isNull(columnRow) || Objects.isNull(columnRow.getColumn())) {
                authorizedCoarse.put(dbTblName, null);
                return;
            }
            if (Objects.isNull(authorizedCoarse.get(dbTblName))) {
                authorizedCoarse.put(dbTblName, Sets.newHashSet());
            }
            ((Set)authorizedCoarse.get(dbTblName)).addAll(columnRow.getColumn());
        }));
        return authorizedCoarse;
    }

    public SortedMap<String, AclTCR.Table> getDbAclTable(String project, AclTCR authorized) {
        if (Objects.isNull((Object)authorized)) {
            return Maps.newTreeMap();
        }
        if (Objects.isNull(authorized.getTable())) {
            return this.getAllDbAclTable(project);
        }
        TreeMap db2AclTable = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        authorized.getTable().forEach((dbTblName, cr) -> {
            TableDesc tableDesc = NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), project).getTableDesc((String)dbTblName);
            if (!db2AclTable.containsKey(tableDesc.getDatabase())) {
                db2AclTable.put(tableDesc.getDatabase(), new AclTCR.Table());
            }
            if (Objects.isNull(cr) || Objects.isNull(cr.getColumn())) {
                AclTCR.ColumnRow columnRow = new AclTCR.ColumnRow();
                AclTCR.Column aclColumn = new AclTCR.Column();
                aclColumn.addAll(this.getTableColumns(tableDesc));
                columnRow.setColumn(aclColumn);
                if (Objects.nonNull(cr)) {
                    columnRow.setRow(cr.getRow());
                    columnRow.setLikeRow(cr.getLikeRow());
                    columnRow.setRowFilter(cr.getRowFilter());
                }
                ((AclTCR.Table)db2AclTable.get(tableDesc.getDatabase())).put(tableDesc.getName(), columnRow);
            } else {
                ((AclTCR.Table)db2AclTable.get(tableDesc.getDatabase())).put(tableDesc.getName(), cr);
            }
        });
        return db2AclTable;
    }

    private List<String> getTableColumns(TableDesc t) {
        return Optional.ofNullable(t.getColumns()).map(Arrays::stream).orElseGet(Stream::empty).map(ColumnDesc::getName).collect(Collectors.toList());
    }

    public SortedMap<String, AclTCR.Table> getAllDbAclTable(String project) {
        TreeMap db2AclTable = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), project).listAllTables().stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getDatabase()) && StringUtils.isNotEmpty((CharSequence)t.getName())).forEach(t -> {
            AclTCR.ColumnRow columnRow = new AclTCR.ColumnRow();
            AclTCR.Column aclColumn = new AclTCR.Column();
            aclColumn.addAll(this.getTableColumns((TableDesc)t));
            columnRow.setColumn(aclColumn);
            if (!db2AclTable.containsKey(t.getDatabase())) {
                db2AclTable.put(t.getDatabase(), new AclTCR.Table());
            }
            ((AclTCR.Table)db2AclTable.get(t.getDatabase())).put(t.getName(), columnRow);
        });
        return db2AclTable;
    }

    public AclTCRDigest getAuthTablesAndColumns(String project, String sid, boolean principal) {
        HashSet tables = Sets.newHashSet();
        HashSet columns = Sets.newHashSet();
        SortedMap<String, AclTCR.Table> authorized = this.getDbAclTable(project, this.getAclTCR(sid, principal));
        for (Map.Entry<String, AclTCR.Table> database : authorized.entrySet()) {
            for (Map.Entry table : database.getValue().entrySet()) {
                tables.add(database.getKey() + "." + (String)table.getKey());
                for (String column : ((AclTCR.ColumnRow)table.getValue()).getColumn()) {
                    columns.add(database.getKey() + "." + (String)table.getKey() + "." + column);
                }
            }
        }
        AclTCRDigest aclTCRDigest = new AclTCRDigest();
        aclTCRDigest.setTables(tables);
        aclTCRDigest.setColumns(columns);
        return aclTCRDigest;
    }

    public boolean isAllTablesAuthorized(String username, Set<String> groups) {
        List<AclTCR> all = this.getAclTCRs(username, groups);
        return this.isTablesAuthorized(all);
    }

    public SensitiveDataMaskInfo getSensitiveDataMaskInfo(String username, Set<String> groups) {
        SensitiveDataMaskInfo maskInfo = new SensitiveDataMaskInfo();
        List<AclTCR> aclTCRS = this.getAclTCRs(username, groups);
        for (AclTCR aclTCR : aclTCRS) {
            if (aclTCR.getTable() == null) continue;
            for (Map.Entry entry : aclTCR.getTable().entrySet()) {
                String dbTableName = (String)entry.getKey();
                AclTCR.ColumnRow columnRow = (AclTCR.ColumnRow)entry.getValue();
                if (columnRow == null || columnRow.getColumnSensitiveDataMask() == null) continue;
                int sepIdx = dbTableName.indexOf(46);
                assert (sepIdx > -1);
                String dbName = dbTableName.substring(0, sepIdx);
                String tableName = dbTableName.substring(sepIdx + 1);
                maskInfo.addMasks(dbName, tableName, ((AclTCR.ColumnRow)entry.getValue()).getColumnSensitiveDataMask());
            }
        }
        return maskInfo;
    }

    public DependentColumnInfo getDependentColumns(String username, Set<String> groups) {
        DependentColumnInfo info = new DependentColumnInfo();
        List<AclTCR> aclTCRS = this.getAclTCRs(username, groups);
        for (AclTCR aclTCR : aclTCRS) {
            if (aclTCR.getTable() == null) continue;
            for (Map.Entry entry : aclTCR.getTable().entrySet()) {
                String dbTableName = (String)entry.getKey();
                AclTCR.ColumnRow columnRow = (AclTCR.ColumnRow)entry.getValue();
                if (columnRow == null || columnRow.getDependentColumns() == null) continue;
                int sepIdx = dbTableName.indexOf(46);
                assert (sepIdx > -1);
                String dbName = dbTableName.substring(0, sepIdx);
                String tableName = dbTableName.substring(sepIdx + 1);
                info.add(dbName, tableName, ((AclTCR.ColumnRow)entry.getValue()).getDependentColumns());
            }
        }
        info.validate();
        return info;
    }
}

