/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.Serializable;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.dimension.AbstractDateDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataType;

public class DateDimEnc
extends AbstractDateDimEnc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ID_9999_12_31 = 3652426;
    public static final String ENCODING_NAME = "date";

    public DateDimEnc() {
        super(3, new DateDimValueCodec(null));
    }

    public DateDimEnc(String[] args) {
        super(3, new DateDimValueCodec(args));
    }

    public static long getNumOfDaysSince0000FromMillis(long millis) {
        return (int)(millis / 86400000L + 719530L);
    }

    public static long getMillisFromNumOfDaysSince0000(long n) {
        long millis = (n - 719530L) * 86400000L;
        return millis;
    }

    public static String[] replaceEncodingArgs(String encoding, String[] encodingArgs, String encodingName, DataType type) {
        if (ENCODING_NAME.equals(encodingName) && type.isIntegerFamily()) {
            if (encodingArgs.length != 0) {
                throw new IllegalArgumentException("Date encoding should not specify arguments: " + encoding);
            }
            return new String[]{type.toString()};
        }
        return encodingArgs;
    }

    private static class DateDimValueCodec
    implements AbstractDateDimEnc.IValueCodec {
        private static final long serialVersionUID = 1L;
        private DataType datatype = null;

        public DateDimValueCodec(String[] args) {
            if (args != null && args.length == 1) {
                this.datatype = DataType.getType(args[0]);
            }
        }

        @Override
        public long valueToCode(String value) {
            long millis = DateFormat.stringToMillis((String)value);
            return DateDimEnc.getNumOfDaysSince0000FromMillis(millis);
        }

        @Override
        public String codeToValue(long code) {
            long millisFromNumOfDaysSince0000 = DateDimEnc.getMillisFromNumOfDaysSince0000(code);
            if (this.datatype != null && this.datatype.isIntegerFamily()) {
                return DateFormat.formatToCompactDateStr((long)millisFromNumOfDaysSince0000);
            }
            return String.valueOf(millisFromNumOfDaysSince0000);
        }
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return DateDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new DateDimEnc(args);
        }
    }
}

