/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.utils.HiveTransactionTableHelper;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.hive.HiveCmdBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectTemporaryTableCleanerHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectTemporaryTableCleanerHelper.class);
    private static final String TRANSACTIONAL_TABLE_NAME_SUFFIX = "_hive_tx_intermediate";

    public Map<String, List<String>> getDropTmpTableMap(String project, Set<String> tempTables) {
        ConcurrentMap dropDbTableNameMap = Maps.newConcurrentMap();
        NTableMetadataManager manager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        tempTables.forEach(tempTableName -> {
            String tableIdentity = tempTableName.split(TRANSACTIONAL_TABLE_NAME_SUFFIX).length == 2 ? tempTableName.split(TRANSACTIONAL_TABLE_NAME_SUFFIX)[0] : tempTableName;
            TableDesc tableDesc = manager.getTableDesc(tableIdentity);
            if (Objects.nonNull(tableDesc)) {
                tempTableName = StringUtils.substringAfter((String)tempTableName, (String)(tableDesc.getDatabase() + "."));
                this.putTableToMap(dropDbTableNameMap, tableDesc.getDatabase(), (String)tempTableName);
            } else {
                String dbName = StringUtils.substringBefore((String)tempTableName, (String)".");
                tempTableName = StringUtils.substringAfter((String)tempTableName, (String)".");
                this.putTableToMap(dropDbTableNameMap, dbName, (String)tempTableName);
            }
        });
        return dropDbTableNameMap;
    }

    public void putTableToMap(Map<String, List<String>> dbTableMap, String dbName, String tableName) {
        List<String> tableNameList = dbTableMap.getOrDefault(dbName, Lists.newArrayList());
        tableNameList.add(tableName);
        dbTableMap.put(dbName, tableNameList);
    }

    public Set<String> getJobTransactionalTable(String project, String jobId, FileSystem fs) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String dir = config.getJobTmpTransactionalTableDir(project, jobId);
        Path path = new Path(dir);
        HashSet tmpTableSet = Sets.newHashSet();
        try {
            if (!fs.exists(path)) {
                return tmpTableSet;
            }
            for (FileStatus fileStatus : fs.listStatus(path)) {
                String tempTableName = fileStatus.getPath().getName();
                if (!StringUtils.containsIgnoreCase((CharSequence)tempTableName, (CharSequence)TRANSACTIONAL_TABLE_NAME_SUFFIX)) continue;
                tmpTableSet.add(tempTableName);
            }
        }
        catch (IOException e) {
            log.error("Get Job Transactional Table failed!", (Throwable)e);
        }
        return tmpTableSet;
    }

    public String getDropTmpTableCmd(String project, Set<String> tempTables) {
        Map<String, List<String>> dropDbTableNameMap = this.getDropTmpTableMap(project, tempTables);
        if (dropDbTableNameMap.isEmpty()) {
            log.info("The temporary transaction table that will be deleted is empty.");
            return "";
        }
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(KylinConfig.getInstanceFromEnv());
        dropDbTableNameMap.forEach((dbName, tableNameList) -> tableNameList.forEach(tableName -> {
            log.info("Temporary transaction table that will be deleted: {}.{}", dbName, tableName);
            hiveCmdBuilder.addStatement(HiveTransactionTableHelper.generateHiveInitStatements((String)dbName) + HiveTransactionTableHelper.generateDropTableStatement((String)tableName));
        }));
        return hiveCmdBuilder.toString();
    }
}

