/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.hive;

import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.tool.util.ToolMainWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveClientJarTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiveClientJarTool.class);

    public static void main(String[] args) {
        ToolMainWrapper.wrap(args, () -> {
            HiveClientJarTool tool = new HiveClientJarTool();
            tool.execute();
        });
        Unsafe.systemExit((int)0);
    }

    public void execute() throws IOException {
        String sparkSqlHiveMetastoreJarsPath;
        Path jarsDirPath;
        Path uploadHiveJarFlag;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!config.getHiveClientJarUploadEnable()) {
            log.info("Not need upload hive client jar");
            return;
        }
        if (StringUtils.isBlank((CharSequence)config.getSparkSqlHiveMetastoreJarsPath())) {
            log.warn("kylin.engine.spark-conf.spark.sql.hive.metastore.jars.path not setting");
            return;
        }
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        if (fileSystem.exists(uploadHiveJarFlag = new Path(jarsDirPath = new Path(sparkSqlHiveMetastoreJarsPath = config.getSparkSqlHiveMetastoreJarsPath()).getParent(), "_upload_hive_jar_by_pass"))) {
            log.info("Not need upload Spark HIVE jars again");
            return;
        }
        String kylinSparkHiveJarsPath = this.getKylinSparkHiveJarsPath();
        if (StringUtils.isBlank((CharSequence)kylinSparkHiveJarsPath)) {
            log.warn("${KYLIN_HOME}/spark/hive_1_2_2 needs to be an existing directory");
            return;
        }
        this.uploadHiveJars(fileSystem, uploadHiveJarFlag, kylinSparkHiveJarsPath, jarsDirPath);
    }

    public void uploadHiveJars(FileSystem fileSystem, Path uploadHiveJarFlag, String kylinSparkHiveJarsPath, Path jarsDirPath) throws IOException {
        if (fileSystem.exists(jarsDirPath)) {
            log.warn("HDFS dir [{}] exist, not upload hive client jar", (Object)jarsDirPath);
            return;
        }
        fileSystem.mkdirs(jarsDirPath);
        List hiveJars = FileUtils.findFiles((String)kylinSparkHiveJarsPath);
        for (File jar : hiveJars) {
            Path sparkHiveJarPath = new Path(jar.getCanonicalPath());
            fileSystem.copyFromLocalFile(sparkHiveJarPath, jarsDirPath);
        }
        log.info("Upload Spark HIVE jars ending");
        try (FSDataOutputStream out = fileSystem.create(uploadHiveJarFlag, true);){
            out.write(new byte[0]);
        }
        log.info("Upload Spark HIVE jars success");
    }

    public String getKylinSparkHiveJarsPath() throws IOException {
        String sparkHome = KylinConfig.getSparkHome();
        File jar = FileUtils.findFile((String)sparkHome, (String)"hive_1_2_2");
        if (jar == null || jar.isFile()) {
            return "";
        }
        return jar.getCanonicalPath();
    }
}

