/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCleaner
extends MetadataCleaner {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotCleaner.class);
    private Set<String> staleSnapshotPaths = new HashSet<String>();

    public SnapshotCleaner(String project) {
        super(project);
    }

    @Override
    public void beforeExecute() {
    }

    @Override
    public void prepare() {
        NTableMetadataManager tMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        tMgr.listAllTables().forEach(tableDesc -> {
            String snapshotPath = tableDesc.getLastSnapshotPath();
            if (snapshotPath != null && !this.snapshotExist(snapshotPath, KapConfig.getInstanceFromEnv())) {
                this.staleSnapshotPaths.add(snapshotPath);
            }
        });
    }

    private boolean snapshotExist(String snapshotPath, KapConfig config) {
        if (this.staleSnapshotPaths.contains(snapshotPath)) {
            return false;
        }
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String baseDir = config.getMetadataWorkingDirectory();
        String resourcePath = baseDir + FileSystems.getDefault().getSeparator() + snapshotPath;
        try {
            return fs.exists(new Path(resourcePath));
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public void execute() {
        logger.info("Start to clean snapshot in project {}", (Object)this.project);
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        for (TableDesc tableDesc : tblMgr.listAllTables()) {
            if (!this.staleSnapshotPaths.contains(tableDesc.getLastSnapshotPath())) continue;
            TableDesc copy = tblMgr.copyForWrite(tableDesc);
            copy.deleteSnapshot(false);
            TableExtDesc ext = tblMgr.getOrCreateTableExt(tableDesc);
            TableExtDesc extCopy = tblMgr.copyForWrite(ext);
            extCopy.setOriginalSize(-1L);
            tblMgr.mergeAndUpdateTableExt(ext, extCopy);
            tblMgr.updateTableDesc(copy);
        }
        logger.info("Clean snapshot in project {} finished", (Object)this.project);
    }

    @Override
    public void afterExecute() {
    }
}

