/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;

public class ServiceInstanceSerializer<T>
extends JsonInstanceSerializer<T> {
    private ObjectMapper mapper = new ObjectMapper();

    public ServiceInstanceSerializer(Class<T> payloadClass) {
        super(payloadClass);
    }

    public ServiceInstance<T> deserialize(byte[] bytes) throws Exception {
        String content = new String(bytes, Charset.defaultCharset());
        Map map = (Map)this.mapper.readValue(content, Map.class);
        return this.castToServiceInstance(map);
    }

    private ServiceInstance<T> castToServiceInstance(Map map) {
        String name = map.getOrDefault("name", "");
        String id = map.getOrDefault("id", "");
        String address = map.getOrDefault("address", null);
        Integer port = map.getOrDefault("port", null);
        return new ServiceInstance(name, id, address, port, null, null, 0L, ServiceType.DYNAMIC, null);
    }
}

