/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.CancelableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class QueryHistoryOffsetTool
extends CancelableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String QUERY_HISTORY_DIR = "query_history_id_offset";
    private static final String ZIP_SUFFIX = ".zip";

    public void backup(String dir, String project) throws IOException {
        this.extractToHDFS(dir + "/" + QUERY_HISTORY_DIR, project);
    }

    public void restore(String dir, boolean isTruncate) throws IOException {
        Path path = new Path(dir + "/" + QUERY_HISTORY_DIR);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        for (FileStatus fileStatus : fs.listStatus(path)) {
            String fileName = fileStatus.getPath().getName();
            String project = fileName.substring(0, fileName.indexOf("."));
            this.restoreProject(dir, project, isTruncate);
        }
    }

    public void restoreProject(String dir, String project, boolean isTruncate) throws IOException {
        Path path = new Path(dir + "/" + QUERY_HISTORY_DIR + "/" + project + ZIP_SUFFIX);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        ArrayList offsets = Lists.newArrayList();
        QueryHistoryIdOffsetManager manager = QueryHistoryIdOffsetManager.getInstance((String)project);
        try (ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));){
            while (zis.getNextEntry() != null) {
                String value = br.readLine();
                QueryHistoryIdOffset offset = (QueryHistoryIdOffset)JsonUtil.readValue((String)value, QueryHistoryIdOffset.class);
                offset.setProject(project);
                offsets.add(offset);
            }
        }
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            if (isTruncate) {
                manager.delete();
            }
            for (QueryHistoryIdOffset offset : offsets) {
                manager.updateWithoutMvccCheck(offset);
            }
            return null;
        });
    }

    public void extractFull(File dir) throws IOException {
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        for (ProjectInstance project : projects) {
            this.extractProject(dir, project.getName());
        }
    }

    public void extractProject(File dir, String project) throws IOException {
        File projectFile = new File(dir, project);
        QueryHistoryIdOffsetManager manager = QueryHistoryIdOffsetManager.getInstance((String)project);
        try (OutputStream os = Files.newOutputStream(projectFile.toPath(), new OpenOption[0]);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset()));){
            for (QueryHistoryIdOffset.OffsetType type : QueryHistoryIdOffsetManager.ALL_OFFSET_TYPE) {
                QueryHistoryIdOffset offset = manager.get(type);
                try {
                    bw.write(JsonUtil.writeValueAsString((Object)offset));
                    bw.newLine();
                    if (!this.isCanceled()) continue;
                    logger.info("query history off set backup was canceled.");
                    return;
                }
                catch (Exception e) {
                    logger.error("Write error, id is {}", (Object)offset.getId(), (Object)e);
                }
            }
        }
    }

    public void extractToHDFS(String dir, String project) throws IOException {
        QueryHistoryIdOffsetManager manager = QueryHistoryIdOffsetManager.getInstance((String)project);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String filePathStr = dir + "/" + project + ZIP_SUFFIX;
        try (FSDataOutputStream fos = fs.create(new Path(filePathStr));
             ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)zos, Charset.defaultCharset()));){
            for (QueryHistoryIdOffset.OffsetType type : QueryHistoryIdOffsetManager.ALL_OFFSET_TYPE) {
                QueryHistoryIdOffset offset = manager.get(type);
                String pathStr = offset.getId() + "_" + type.getName() + ".json";
                zos.putNextEntry(new ZipEntry(pathStr));
                bw.write(JsonUtil.writeValueAsString((Object)offset));
                bw.flush();
            }
        }
    }

    public void backupToLocal(String dir, String project) throws IOException {
        String extractDir = this.prepareLocalBackupDir(dir, project);
        QueryHistoryIdOffsetManager manager = QueryHistoryIdOffsetManager.getInstance((String)project);
        for (QueryHistoryIdOffset.OffsetType type : QueryHistoryIdOffsetManager.ALL_OFFSET_TYPE) {
            QueryHistoryIdOffset offset = manager.get(type);
            String pathname = extractDir + offset.getId() + "_" + type.getName() + ".json";
            BufferedWriter bf = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(new File(pathname).toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                bf.write(JsonUtil.writeValueAsString((Object)offset));
                bf.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bf == null) continue;
                if (throwable != null) {
                    try {
                        bf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bf.close();
            }
        }
    }

    private String prepareLocalBackupDir(String dir, String project) throws IOException {
        String extractDirPath;
        File extractDir;
        String queryHistoryOffsetDirPath;
        File queryHistoryOffsetDir;
        File rootDir = new File(dir);
        if (!rootDir.exists()) {
            FileUtils.forceMkdir((File)rootDir);
        }
        if (!(queryHistoryOffsetDir = new File(queryHistoryOffsetDirPath = StringUtils.appendIfMissing((String)dir, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + QUERY_HISTORY_DIR)).exists()) {
            FileUtils.forceMkdir((File)queryHistoryOffsetDir);
        }
        if (!(extractDir = new File(extractDirPath = queryHistoryOffsetDirPath + "/" + project + "/")).exists()) {
            FileUtils.forceMkdir((File)extractDir);
        }
        return extractDirPath;
    }

    public void restoreFromLocal(String dir, boolean isTruncate) throws IOException {
        String restorePath = dir + "/" + QUERY_HISTORY_DIR;
        File restoreDir = new File(restorePath);
        if (!restoreDir.exists()) {
            return;
        }
        File[] projectDirs = restoreDir.listFiles();
        for (File projectDir : Objects.requireNonNull(projectDirs)) {
            String project = projectDir.getName();
            this.restoreProjectFromLocal(dir, project, isTruncate);
        }
    }

    public void restoreProjectFromLocal(String dir, String project, boolean isTruncate) throws IOException {
        String restoreProjectPath = dir + "/" + QUERY_HISTORY_DIR + "/" + project;
        File restoreProjectDir = new File(restoreProjectPath);
        if (!restoreProjectDir.exists()) {
            return;
        }
        File[] jsonFiles = restoreProjectDir.listFiles();
        ArrayList offsets = Lists.newArrayList();
        QueryHistoryIdOffsetManager manager = QueryHistoryIdOffsetManager.getInstance((String)project);
        for (File jsonFile : Objects.requireNonNull(jsonFiles)) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String value = br.readLine();
                QueryHistoryIdOffset offset = (QueryHistoryIdOffset)JsonUtil.readValue((String)value, QueryHistoryIdOffset.class);
                offset.setProject(project);
                offsets.add(offset);
            }
        }
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            if (isTruncate) {
                manager.delete();
            }
            for (QueryHistoryIdOffset offset : offsets) {
                manager.updateWithoutMvccCheck(offset);
            }
            return null;
        });
    }
}

