/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Litmus;
import org.apache.commons.collections.MapUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.apache.kylin.query.util.QueryAliasMatcher;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.SqlSubqueryFinder;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreFromComputedColumn
implements IPushDownConverter {
    private static final Logger logger = LoggerFactory.getLogger(RestoreFromComputedColumn.class);

    public static String convertWithGivenModels(String sql, String project, String defaultSchema, Map<String, NDataModel> idToModelMap) throws SqlParseException {
        if (MapUtils.isEmpty(idToModelMap)) {
            return sql;
        }
        List<SqlCall> selectOrOrderbys = SqlSubqueryFinder.getSubqueries(sql, true);
        ArrayList topColumns = Lists.newArrayList();
        for (SqlCall selectOrOrderby : selectOrOrderbys) {
            topColumns.add(RestoreFromComputedColumn.collectTopColumns(selectOrOrderby));
        }
        QueryAliasMatcher queryAliasMatcher = new QueryAliasMatcher(project, defaultSchema);
        int recursionTimes = 0;
        int maxRecursionTimes = NProjectManager.getProjectConfig((String)project).getConvertCcMaxIterations();
        while (recursionTimes < maxRecursionTimes) {
            QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted sql transformation at the stage of RestoreFromComputedColumn", (String)"Current step: SQL transformation");
            ++recursionTimes;
            boolean recursionCompleted = true;
            for (int i = 0; i < selectOrOrderbys.size(); ++i) {
                Pair<String, Integer> choiceForCurrentSubquery = RestoreFromComputedColumn.restoreComputedColumn(sql, selectOrOrderbys.get(i), (List<SqlNode>)((List)topColumns.get(i)), idToModelMap, queryAliasMatcher);
                if (choiceForCurrentSubquery == null) continue;
                sql = (String)choiceForCurrentSubquery.getFirst();
                selectOrOrderbys = SqlSubqueryFinder.getSubqueries(sql, true);
                recursionCompleted = false;
            }
            if (!recursionCompleted) continue;
            break;
        }
        return sql;
    }

    private static List<SqlNode> collectTopColumns(SqlCall selectOrOrderby) {
        ArrayList columnList = Lists.newArrayList();
        for (SqlNode node : selectOrOrderby.getOperandList()) {
            if (!(node instanceof SqlNodeList)) continue;
            columnList.addAll(((SqlNodeList)node).getList());
        }
        return columnList;
    }

    private static boolean needParenthesis(String originSql, List<SqlNode> topColumns, ReplaceRange replaceRange) {
        if (replaceRange.addAlias) {
            return false;
        }
        boolean topColumn = false;
        for (SqlNode column : topColumns) {
            if (column == null || !column.equalsDeep((SqlNode)replaceRange.column, Litmus.IGNORE)) continue;
            topColumn = true;
            break;
        }
        if (topColumn) {
            return false;
        }
        boolean hasLeft = false;
        for (int i = replaceRange.beginPos - 1; i >= 0; --i) {
            char c = originSql.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != '(' && c != ',') break;
            hasLeft = true;
            break;
        }
        boolean hasRight = false;
        for (int i = replaceRange.endPos; i < originSql.length(); ++i) {
            char c = originSql.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != ')' && c != ',') break;
            hasRight = true;
            break;
        }
        return !hasLeft || !hasRight;
    }

    static Pair<String, Integer> restoreComputedColumn(String sql, SqlCall selectOrOrderby, List<SqlNode> topColumns, Map<String, NDataModel> modelMap, QueryAliasMatcher queryAliasMatcher) {
        SqlSelect sqlSelect = QueryUtil.extractSqlSelect(selectOrOrderby);
        if (sqlSelect == null) {
            return Pair.newPair((Object)sql, (Object)0);
        }
        Pair<String, Integer> choiceForCurrentSubquery = null;
        for (NDataModel model : modelMap.values()) {
            Pair<String, Integer> ret;
            QueryAliasMatchInfo info = model.getComputedColumnDescs().isEmpty() ? null : queryAliasMatcher.match(model, sqlSelect);
            QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted sql transformation at the stage of RestoreFromComputedColumn", (String)"Current step: SQL transformation");
            if (info == null || (Integer)(ret = RestoreFromComputedColumn.restoreComputedColumn(sql, selectOrOrderby, topColumns, model, info)).getSecond() == 0 || choiceForCurrentSubquery != null && (Integer)ret.getSecond() <= (Integer)choiceForCurrentSubquery.getSecond()) continue;
            choiceForCurrentSubquery = ret;
        }
        return choiceForCurrentSubquery;
    }

    static Pair<String, Integer> restoreComputedColumn(String inputSql, SqlCall selectOrOrderby, List<SqlNode> topColumns, NDataModel dataModelDesc, QueryAliasMatchInfo matchInfo) {
        String result = inputSql;
        HashSet ccColNamesWithPrefix = Sets.newHashSet();
        ccColNamesWithPrefix.addAll(dataModelDesc.getComputedColumnNames());
        List<ColumnUsage> columnUsages = ColumnUsagesFinder.getColumnUsages(selectOrOrderby, ccColNamesWithPrefix);
        if (columnUsages.isEmpty()) {
            return Pair.newPair((Object)inputSql, (Object)0);
        }
        columnUsages.sort((item1, item2) -> {
            SqlIdentifier column1 = item1.sqlIdentifier;
            SqlIdentifier column2 = item2.sqlIdentifier;
            int linegap = column2.getParserPosition().getLineNum() - column1.getParserPosition().getLineNum();
            if (linegap != 0) {
                return linegap;
            }
            return column2.getParserPosition().getColumnNum() - column1.getParserPosition().getColumnNum();
        });
        ArrayList toBeReplacedUsages = Lists.newArrayList();
        for (ColumnUsage columnUsage : columnUsages) {
            SqlIdentifier column = columnUsage.sqlIdentifier;
            String columnName = (String)Iterables.getLast((Iterable)column.names);
            ComputedColumnDesc computedColumnDesc = dataModelDesc.findCCByCCColumnName(ComputedColumnDesc.getOriginCcName((String)columnName));
            String ccExpression = CalciteParser.replaceAliasInExpr((String)computedColumnDesc.getExpression(), (Map)matchInfo.getAliasMap().inverse());
            String replaceExpression = columnUsage.addAlias ? ccExpression + " AS " + computedColumnDesc.getColumnName() : ccExpression;
            Pair startEndPos = CalciteParser.getReplacePos((SqlNode)column, (String)inputSql);
            int begin = (Integer)startEndPos.getFirst();
            int end = (Integer)startEndPos.getSecond();
            ReplaceRange replaceRange = new ReplaceRange();
            replaceRange.beginPos = begin;
            replaceRange.endPos = end;
            replaceRange.column = column;
            replaceRange.replaceExpr = replaceExpression;
            replaceRange.addAlias = columnUsage.addAlias;
            toBeReplacedUsages.add(replaceRange);
        }
        toBeReplacedUsages.sort((o1, o2) -> Integer.compare(o2.beginPos, o1.beginPos));
        ReplaceRange last = null;
        for (ReplaceRange toBeReplaced : toBeReplacedUsages) {
            if (last != null) {
                if (last.beginPos == toBeReplaced.beginPos && last.endPos == toBeReplaced.endPos) {
                    last = toBeReplaced;
                    continue;
                }
                Preconditions.checkState((last.beginPos > toBeReplaced.endPos ? 1 : 0) != 0, (Object)"Positions for two column usage has overlaps");
            }
            logger.debug("Column Usage at [{}, {}] is replaced by {}.", new Object[]{toBeReplaced.beginPos, toBeReplaced.endPos, toBeReplaced.replaceExpr});
            String pattern = RestoreFromComputedColumn.needParenthesis(inputSql, topColumns, toBeReplaced) ? "{0}({1}){2}" : "{0}{1}{2}";
            result = Unsafe.format((Locale)Locale.ROOT, (String)pattern, (Object[])new Object[]{result.substring(0, toBeReplaced.beginPos), toBeReplaced.replaceExpr, result.substring(toBeReplaced.endPos)});
            last = toBeReplaced;
        }
        return Pair.newPair((Object)result, (Object)toBeReplacedUsages.size());
    }

    public String convert(String sql, String project, String defaultSchema) {
        try {
            if (project == null || sql == null) {
                return sql;
            }
            LinkedHashMap<String, NDataModel> modelMap = new LinkedHashMap<String, NDataModel>();
            NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            for (NDataModel modelDesc : dataflowManager.listUnderliningDataModels()) {
                modelMap.put(modelDesc.getUuid(), modelDesc);
            }
            return RestoreFromComputedColumn.convertWithGivenModels(sql, project, defaultSchema, modelMap);
        }
        catch (Exception e) {
            logger.debug("Something unexpected while RestoreFromComputedColumn transforming the query, return original query", (Throwable)e);
            return sql;
        }
    }

    private static class ColumnUsage {
        SqlIdentifier sqlIdentifier;
        boolean addAlias;

        ColumnUsage(SqlIdentifier sqlIdentifier, boolean addAlias) {
            this.sqlIdentifier = sqlIdentifier;
            this.addAlias = addAlias;
        }
    }

    static class ColumnUsagesFinder
    extends SqlBasicVisitor<SqlNode> {
        private final List<ColumnUsage> usages;
        private final Set<String> columnNames;

        ColumnUsagesFinder(Set<String> columnNames) {
            this.columnNames = columnNames;
            this.usages = Lists.newArrayList();
        }

        public static List<ColumnUsage> getColumnUsages(SqlCall selectOrOrderby, Set<String> columnNames) {
            ColumnUsagesFinder sqlSubqueryFinder = new ColumnUsagesFinder(columnNames);
            selectOrOrderby.accept((SqlVisitor)sqlSubqueryFinder);
            return sqlSubqueryFinder.getUsages();
        }

        public List<ColumnUsage> getUsages() {
            return this.usages;
        }

        public SqlNode visit(SqlIdentifier id) {
            if (this.matchName(id)) {
                this.usages.add(new ColumnUsage(id, false));
            }
            return null;
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlBasicCall && call.getOperator() instanceof SqlAsOperator) {
                List operands = call.getOperandList();
                if (operands != null && operands.size() == 2) {
                    ((SqlNode)operands.get(0)).accept((SqlVisitor)this);
                }
            } else {
                List operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    SqlNode operand = (SqlNode)operands.get(i);
                    if (operand == null) continue;
                    if (call instanceof SqlSelect && i == 1) {
                        this.traverseSelectList((SqlNodeList)operand);
                        continue;
                    }
                    operand.accept((SqlVisitor)this);
                }
            }
            return null;
        }

        private boolean matchName(SqlIdentifier sqlIdentifier) {
            return this.columnNames.contains(sqlIdentifier.names.get(sqlIdentifier.names.size() - 1));
        }

        private void traverseSelectList(SqlNodeList sqlSelectList) {
            for (SqlNode selectItem : sqlSelectList.getList()) {
                if (selectItem instanceof SqlIdentifier && this.matchName((SqlIdentifier)selectItem)) {
                    this.usages.add(new ColumnUsage((SqlIdentifier)selectItem, true));
                    continue;
                }
                selectItem.accept((SqlVisitor)this);
            }
        }
    }

    private static class ReplaceRange {
        String replaceExpr;
        boolean addAlias;
        int beginPos;
        int endPos;
        SqlIdentifier column;

        private ReplaceRange() {
        }
    }
}

