/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.CalciteNotSupportException;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.scd2.Scd2Simplifier;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.query.exception.NoAuthorizedColsError;
import org.apache.kylin.query.security.AccessDeniedException;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.query.util.EscapeTransformer;
import org.apache.kylin.query.util.KeywordDefaultDirtyHack;
import org.apache.kylin.query.util.ParseException;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.RawSql;
import org.apache.kylin.query.util.RawSqlParser;
import org.apache.kylin.query.util.RestoreFromComputedColumn;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.apache.kylin.source.adhocquery.PushdownResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownUtil {
    private static final Logger logger;
    public static final String DEFAULT_SCHEMA = "DEFAULT";
    public static final String CC_SPLITTER = "'##CC_PUSH_DOWN_TOKEN##'";
    private static final String UNDER_LINE = "_";
    private static final ExecutorService asyncExecutor;
    private static final Map<String, IPushDownConverter> PUSH_DOWN_CONVERTER_MAP;

    private PushDownUtil() {
    }

    public static PushdownResult tryIterQuery(QueryParams queryParams) throws SQLException {
        String sql;
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)queryParams.getProject());
        queryParams.setKylinConfig(projectConfig);
        if (!projectConfig.isPushDownEnabled()) {
            PushDownUtil.checkPushDownIncapable(queryParams);
            return null;
        }
        if (queryParams.isSelect()) {
            SQLException sqlEx = queryParams.getSqlException();
            if (ExceptionUtils.getRootCause((Throwable)sqlEx) instanceof NoRealizationFoundException) {
                logger.info("Query has no match model, routing to other engines -- {}", (Object)QueryContext.current().getMetrics().getCorrectedSql());
            } else {
                logger.info("Query hit error utilizing pre-calculation, routing to other engines -- {}", (Object)QueryContext.current().getMetrics().getCorrectedSql(), (Object)sqlEx);
            }
            if (!queryParams.isForcedToPushDown() && !PushDownUtil.isExpectedCause(sqlEx)) {
                logger.info("quit doPushDownQuery because prior exception thrown is unexpected");
                return null;
            }
        } else {
            Preconditions.checkState((queryParams.getSqlException() == null ? 1 : 0) != 0);
            logger.info("Kylin cannot support non-select queries, routing to other engines");
        }
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)projectConfig.getPushDownRunnerClassName());
        runner.init(projectConfig, queryParams.getProject());
        logger.debug("Query Pushdown runner {}", (Object)runner);
        int sourceType = projectConfig.getDefaultSource();
        String engine = sourceType == 9 && KapConfig.getInstanceFromEnv().isCloud() ? "OBJECT STORAGE" : runner.getName();
        QueryContext.current().setPushdownEngine(engine);
        try {
            sql = PushDownUtil.massagePushDownSql(queryParams);
        }
        catch (NoAuthorizedColsError e) {
            return PushdownResult.emptyResult();
        }
        QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted sql push down at the stage of QueryRoutingEngine", (String)"Current step: try push down select query");
        QueryContext.current().record("massage");
        QueryContext.currentTrace().startSpan("PREPARE_AND_SUBMIT_JOB");
        if (queryParams.isSelect()) {
            PushdownResult result = runner.executeQueryToIterator(sql, queryParams.getProject());
            if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
                AsyncQueryUtil.saveMetaDataAndFileInfo(QueryContext.current(), result.getColumnMetas());
            }
            return result;
        }
        return PushdownResult.emptyResult();
    }

    private static void checkPushDownIncapable(QueryParams queryParams) {
        if (queryParams.isForcedToPushDown()) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.INVALID_PARAMETER_PUSH_DOWN, MsgPicker.getMsg().getDisablePushDownPrompt());
        }
    }

    public static String massageComputedColumn(NDataModel model, String project, ComputedColumnDesc cc, QueryContext.AclInfo aclInfo) {
        return PushDownUtil.massageExpression(model, project, cc.getExpression(), aclInfo);
    }

    public static String massageExpression(NDataModel model, String project, String expression, QueryContext.AclInfo aclInfo) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String ccSql = PushDownUtil.expandComputedColumnExp(model, project, StringHelper.backtickToDoubleQuote((String)expression));
        QueryParams queryParams = new QueryParams(project, ccSql, DEFAULT_SCHEMA, false);
        queryParams.setKylinConfig(NProjectManager.getProjectConfig((String)project));
        queryParams.setAclInfo(aclInfo);
        String s = PushDownUtil.massagePushDownSql(queryParams);
        return s.substring("select ".length(), s.indexOf(CC_SPLITTER) - 2).trim();
    }

    public static String massagePushDownSql(QueryParams queryParams) {
        if (queryParams.getSql() == null) {
            return "";
        }
        String sql = queryParams.getSql();
        sql = QueryUtil.trimRightSemiColon(sql);
        sql = PushDownUtil.removeSqlHints(sql, queryParams.getKylinConfig());
        List<IPushDownConverter> pushDownConverters = PushDownUtil.fetchConverters(queryParams.getKylinConfig());
        if (logger.isDebugEnabled()) {
            logger.debug("All used push-down converters are: {}", (Object)pushDownConverters.stream().map(c -> c.getClass().getCanonicalName()).collect(Collectors.joining(",")));
        }
        for (IPushDownConverter converter : pushDownConverters) {
            QueryInterruptChecker.checkThreadInterrupted((String)("Interrupted sql transformation at the stage of " + converter.getClass()), (String)"Current step: Massage push-down sql. ");
            sql = converter.convert(sql, queryParams.getProject(), queryParams.getDefaultSchema());
        }
        sql = PushDownUtil.replaceEscapedQuote(sql);
        return sql.trim();
    }

    static String removeSqlHints(String sql, KylinConfig kylinConfig) {
        if (kylinConfig.isPushdownSqlHintsErasingEnabled()) {
            try {
                RawSql rawSql = new RawSqlParser(sql).parse();
                return rawSql.getStatementStringWithoutHints();
            }
            catch (ParseException e) {
                logger.error("Error on remove push-down sql hints", (Throwable)e);
            }
        }
        return sql;
    }

    static List<IPushDownConverter> fetchConverters(KylinConfig kylinConfig) {
        ArrayList converters = Lists.newArrayList();
        for (String clz : kylinConfig.getPushDownConverterClassNames()) {
            if (PUSH_DOWN_CONVERTER_MAP.containsKey(clz)) {
                converters.add(PUSH_DOWN_CONVERTER_MAP.get(clz));
                continue;
            }
            try {
                IPushDownConverter converter = (IPushDownConverter)ClassUtil.newInstance((String)clz);
                PUSH_DOWN_CONVERTER_MAP.put(clz, converter);
                converters.add(PUSH_DOWN_CONVERTER_MAP.get(clz));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to init pushdown converter", e);
            }
        }
        return converters;
    }

    public static String generateFlatTableSql(NDataModel model, boolean singleLine) {
        String sep = singleLine ? " " : "\n";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ").append(sep);
        ArrayList originTblColRefs = Lists.newArrayList((Iterable)model.getEffectiveCols().values());
        List<TblColRef> tblColRefs = PushDownUtil.getAuthorizedCols(model.getProject(), originTblColRefs);
        if (tblColRefs.isEmpty()) {
            sqlBuilder.append("1 ").append(sep);
        } else {
            String allColStr = tblColRefs.stream().filter(colRef -> !colRef.getColumnDesc().isComputedColumn()).map(colRef -> {
                String s = colRef.getTableAlias() + UNDER_LINE + colRef.getName();
                String colName = StringHelper.doubleQuote((String)s);
                return colRef.getDoubleQuoteExp() + " as " + colName + sep;
            }).collect(Collectors.joining(", "));
            sqlBuilder.append(allColStr);
        }
        sqlBuilder.append("FROM ").append(model.getRootFactTable().getTableDesc().getDoubleQuoteIdentity()).append(" as ").append(StringHelper.doubleQuote((String)model.getRootFactTable().getAlias()));
        PushDownUtil.appendJoinStatement(model, sqlBuilder, singleLine);
        sqlBuilder.append("WHERE ").append(sep);
        sqlBuilder.append("1 = 1").append(sep);
        if (StringUtils.isNotEmpty((CharSequence)model.getFilterCondition())) {
            String filterConditionWithCalciteFormat = QueryUtil.adaptCalciteSyntax(model.getFilterCondition());
            sqlBuilder.append(" AND (").append(filterConditionWithCalciteFormat).append(") ").append(sep);
        }
        return new EscapeTransformer().transform(sqlBuilder.toString());
    }

    private static List<TblColRef> getAuthorizedCols(String project, List<TblColRef> tableColRefs) {
        QueryContext.AclInfo aclInfo = QueryContext.current().getAclInfo();
        if (aclInfo != null && aclInfo.isHasAdminPermission()) {
            return tableColRefs;
        }
        String user = Objects.nonNull(aclInfo) ? aclInfo.getUsername() : null;
        Set groups = Objects.nonNull(aclInfo) ? aclInfo.getGroups() : null;
        KylinConfig config = NProjectManager.getProjectConfig((String)project);
        List aclTCRList = AclTCRManager.getInstance((KylinConfig)config, (String)project).getAclTCRs(user, groups);
        ArrayList result = Lists.newArrayList();
        block0: for (TblColRef tableColRef : tableColRefs) {
            ColumnDesc column = tableColRef.getColumnDesc();
            for (AclTCR aclTCR : aclTCRList) {
                if (!aclTCR.isAuthorized(tableColRef.getTableWithSchema(), column.getName())) continue;
                result.add(tableColRef);
                continue block0;
            }
        }
        return result;
    }

    public static String expandComputedColumnExp(NDataModel model, String project, String expression) {
        StringBuilder forCC = new StringBuilder();
        forCC.append("select ").append(expression).append(" ,").append(CC_SPLITTER).append(" FROM ").append(model.getRootFactTable().getTableDesc().getDoubleQuoteIdentity());
        PushDownUtil.appendJoinStatement(model, forCC, false);
        String ccSql = KeywordDefaultDirtyHack.transform(forCC.toString());
        try {
            HashMap modelMap = Maps.newHashMap();
            modelMap.put(model.getUuid(), model);
            ccSql = new EscapeTransformer().transform(ccSql);
            ccSql = RestoreFromComputedColumn.convertWithGivenModels(ccSql, project, DEFAULT_SCHEMA, modelMap);
        }
        catch (Exception e) {
            logger.warn("Failed to massage SQL expression [{}] with input model {}", (Object)ccSql, (Object)model.getUuid());
        }
        return ccSql;
    }

    public static void appendJoinStatement(NDataModel model, StringBuilder sql, boolean singleLine) {
        String sep = singleLine ? " " : "\n";
        HashSet dimTableCache = Sets.newHashSet();
        sql.append(sep);
        for (JoinTableDesc lookupDesc : model.getJoinTables()) {
            TblColRef[] fk;
            JoinDesc join = lookupDesc.getJoin();
            TableRef dimTable = lookupDesc.getTableRef();
            if (join == null || StringUtils.isEmpty((CharSequence)join.getType()) || dimTableCache.contains(dimTable)) continue;
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new IllegalStateException("Invalid join condition of lookup table: " + lookupDesc);
            }
            String joinType = join.getType().toUpperCase(Locale.ROOT);
            sql.append(joinType).append(" JOIN ").append(PushDownUtil.doubleQuote(dimTable)).append(" as ").append(StringHelper.doubleQuote((String)dimTable.getAlias())).append(sep).append("ON ");
            sql.append(PushDownUtil.concatEqualJoinCondition(pk, fk, sep));
            if (join.getNonEquiJoinCondition() != null) {
                NonEquiJoinCondition[] operands;
                for (NonEquiJoinCondition operand : operands = join.getNonEquiJoinCondition().getOperands()) {
                    sql.append(" AND ");
                    String cond = Scd2Simplifier.INSTANCE.simplifySCD2ChildCond(operand, join).displaySql();
                    sql.append(cond).append(sep);
                }
            }
            dimTableCache.add(dimTable);
        }
    }

    private static String doubleQuote(TableRef tableRef) {
        TableDesc table = tableRef.getTableDesc();
        return StringHelper.doubleQuote((String)table.getDatabase()) + "." + StringHelper.doubleQuote((String)table.getName());
    }

    private static String concatEqualJoinCondition(TblColRef[] pk, TblColRef[] fk, String sep) {
        StringJoiner joiner = new StringJoiner(" AND ", "", sep);
        for (int i = 0; i < pk.length; ++i) {
            String s = fk[i].getDoubleQuoteExp() + " = " + pk[i].getDoubleQuoteExp();
            joiner.add(s);
        }
        return joiner.toString();
    }

    static String replaceEscapedQuote(String sql) {
        boolean inStrVal = false;
        boolean needTransfer = false;
        char[] res = sql.toCharArray();
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == '\'') {
                if (inStrVal) {
                    if (needTransfer) {
                        res[i - 1] = 92;
                        needTransfer = false;
                        continue;
                    }
                    needTransfer = true;
                    continue;
                }
                inStrVal = true;
                continue;
            }
            if (!needTransfer) continue;
            inStrVal = false;
            needTransfer = false;
        }
        return new String(res);
    }

    public static Pair<String, String> probeMinMaxTsWithTimeout(String partitionColumn, String table, String project) throws ExecutionException, InterruptedException {
        Pair result;
        Future<Pair> pushDownTask = asyncExecutor.submit(() -> {
            try {
                return PushDownUtil.probeMinMaxTs(partitionColumn, table, project);
            }
            catch (Exception e) {
                logger.error("Failed to get partition column latest data range by push down!", (Throwable)e);
                if (e instanceof KylinException) {
                    throw e;
                }
                return null;
            }
        });
        try {
            result = pushDownTask.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            pushDownTask.cancel(true);
            throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. Current step: Getting latest data range by push down. ");
        }
        return result;
    }

    public static Pair<String, String> probeMinMaxTs(String partitionColumn, String table, String project) throws SQLException {
        String t = String.join((CharSequence)".", PushDownUtil.backtickQuote(table.split("\\.")));
        String pc = String.join((CharSequence)".", PushDownUtil.backtickQuote(partitionColumn.split("\\.")));
        String sql = String.format(Locale.ROOT, "select min(%s), max(%s) from %s", pc, pc, t);
        Pair result = new Pair();
        List returnRows = (List)PushDownUtil.probePartitionColInfo(sql, table, project).getFirst();
        if (returnRows.isEmpty() || ((List)returnRows.get(0)).get(0) == null || ((List)returnRows.get(0)).get(1) == null) {
            throw new BadRequestException(String.format(Locale.ROOT, MsgPicker.getMsg().getNoDataInTable(), table));
        }
        result.setFirst(((List)returnRows.get(0)).get(0));
        result.setSecond(((List)returnRows.get(0)).get(1));
        return result;
    }

    public static boolean needPushdown(String start, String end) {
        return StringUtils.isEmpty((CharSequence)start) && StringUtils.isEmpty((CharSequence)end);
    }

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> probePartitionColInfo(String sql, String table, String project) throws SQLException {
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        TableDesc tableDesc = tableMgr.getTableDesc(table);
        if (tableDesc.isView()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.VIEW_PARTITION_DATE_FORMAT_DETECTION_FORBIDDEN, MsgPicker.getMsg().getViewDateFormatDetectionError());
        }
        ArrayList returnRows = Lists.newArrayList();
        ArrayList returnColumnMeta = Lists.newArrayList();
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)projectConfig.getDefaultPartitionCheckerClassName());
        runner.init(projectConfig, project);
        runner.executeQuery(sql, (List)returnRows, (List)returnColumnMeta, project);
        return Pair.newPair((Object)returnRows, (Object)returnColumnMeta);
    }

    public static void trySimplyExecute(String sql, String project) throws SQLException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)kylinConfig.getPushDownRunnerClassName());
        runner.init(kylinConfig, project);
        runner.executeUpdate(sql, project);
    }

    public static String probeColFormat(String table, String partitionColumn, String project) throws SQLException {
        String t = String.join((CharSequence)".", PushDownUtil.backtickQuote(table.split("\\.")));
        String sql = String.format(Locale.ROOT, "select %s from %s where %s is not null limit 1", partitionColumn, t, partitionColumn);
        return PushDownUtil.probe(sql, table, project);
    }

    public static String probeExpFormat(String project, String table, String expression) throws SQLException {
        String t = String.join((CharSequence)".", PushDownUtil.backtickQuote(table.split("\\.")));
        String sql = String.format(Locale.ROOT, "select %s from %s limit 1", expression, t);
        return PushDownUtil.probe(sql, table, project);
    }

    private static String probe(String sql, String table, String project) throws SQLException {
        List returnRows = (List)PushDownUtil.probePartitionColInfo(sql, table, project).getFirst();
        if (CollectionUtils.isEmpty((Collection)returnRows) || CollectionUtils.isEmpty((Collection)((Collection)returnRows.get(0)))) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.EMPTY_TABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getNoDataInTable(), table));
        }
        return (String)((List)returnRows.get(0)).get(0);
    }

    public static List<String> backtickQuote(String[] arr) {
        return Arrays.stream(arr).map(StringHelper::backtickQuote).collect(Collectors.toList());
    }

    private static boolean isExpectedCause(SQLException sqlException) {
        Preconditions.checkArgument((sqlException != null ? 1 : 0) != 0);
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)sqlException);
        if (rootCause instanceof KylinTimeoutException || rootCause instanceof AccessDeniedException) {
            return false;
        }
        if (rootCause instanceof RoutingIndicatorException || rootCause instanceof CalciteNotSupportException) {
            return true;
        }
        if (QueryContext.current().getQueryTagInfo().isWithoutSyntaxError()) {
            logger.warn("route to push down for met error when running the query: {}", (Object)QueryContext.current().getMetrics().getCorrectedSql(), (Object)sqlException);
            return true;
        }
        if (rootCause.getMessage().contains("TIMESTAMPADD") || rootCause.getMessage().contains("TIMESTAMPDIFF")) {
            return true;
        }
        return QueryContext.current().getQueryTagInfo().isWithoutSyntaxError();
    }

    public static String calcStart(String start, SegmentRange<?> coveredRange) {
        if (coveredRange != null) {
            start = coveredRange.getEnd().toString();
        }
        return start;
    }

    static {
        String[] classNames;
        logger = LoggerFactory.getLogger((String)"query");
        asyncExecutor = Executors.newCachedThreadPool();
        PUSH_DOWN_CONVERTER_MAP = Maps.newConcurrentMap();
        for (String clz : classNames = KylinConfig.getInstanceFromEnv().getPushDownConverterClassNames()) {
            try {
                IPushDownConverter converter = (IPushDownConverter)ClassUtil.newInstance((String)clz);
                PUSH_DOWN_CONVERTER_MAP.put(clz, converter);
            }
            catch (Exception e) {
                logger.error("Failed to init push-down converter of the sys-config: {}", (Object)clz);
            }
        }
    }
}

